/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.parser;

import com.ibm.xylem.parser.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class ParserSource {
    private PushbackReader m_reader;
    int m_lineNumber = 1;
    int m_offset = 0;
    URL m_currentURL = null;

    public ParserSource() {
        this.m_currentURL = null;
    }

    public ParserSource(URL uRL) throws ParserException {
        this.m_currentURL = uRL;
        this.m_reader = new PushbackReader(this.getInputStreamReader(this.m_currentURL), 256);
    }

    public ParserSource(Reader reader, URL uRL) {
        this.m_currentURL = uRL;
        this.m_reader = new PushbackReader(reader, 256);
    }

    public ParserSource(Reader reader) {
        this(reader, null);
    }

    private final InputStreamReader getInputStreamReader(URL uRL) throws ParserException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(inputStream);
        }
        catch (Exception exception) {
            throw new ParserException("Error reading URL " + uRL, exception);
        }
    }

    void unread(char c) throws ParserException {
        try {
            this.m_reader.unread(c);
            --this.m_offset;
        }
        catch (IOException iOException) {
            throw new ParserException("I/O error", iOException);
        }
    }

    char read() throws ParserException {
        int n;
        try {
            n = this.m_reader.read();
            ++this.m_offset;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ParserException("I/O error", iOException);
        }
        if (n == -1) {
            throw new ParserException("Unexpected end of file");
        }
        if (n == 10) {
            ++this.m_lineNumber;
            this.m_offset = 0;
        }
        return (char)n;
    }
}

