/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.stream.SecuritySupport;

final class FactoryFinder {
    private static boolean debug;
    private static Properties staxProperties;
    private static long lastModified;
    private static final int DEFAULT_LINE_LENGTH = 80;

    private FactoryFinder() {
    }

    static Object find(String string, String string2) throws ConfigurationError {
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
        }
        return FactoryFinder.find(string, string, classLoader, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2, ClassLoader classLoader, String string3) throws ConfigurationError {
        Object object;
        if (debug) {
            FactoryFinder.dPrint("find factoryId=" + string);
        }
        try {
            String string4;
            if (string2.equals(string)) {
                string4 = SecuritySupport.getSystemProperty(string);
            } else {
                try {
                    string4 = System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    throw new ConfigurationError(securityException.getMessage(), securityException);
                }
            }
            if (string4 != null) {
                if (debug) {
                    FactoryFinder.dPrint("found system property, value=" + string4);
                }
                return FactoryFinder.newInstance(string4, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        boolean bl = false;
        File file = null;
        try {
            object = SecuritySupport.getSystemProperty("java.home");
            String string5 = (String)object + File.separator + "lib" + File.separator + "stax.properties";
            file = new File(string5);
            bl = SecuritySupport.getFileExists(file);
        }
        catch (SecurityException securityException) {
            lastModified = -1L;
            staxProperties = null;
        }
        object = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            boolean bl2 = false;
            FileInputStream fileInputStream = null;
            try {
                if (lastModified >= 0L) {
                    if (bl && lastModified < (lastModified = SecuritySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        lastModified = -1L;
                        staxProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    lastModified = SecuritySupport.getLastModified(file);
                }
                if (bl2) {
                    staxProperties = new Properties();
                    fileInputStream = SecuritySupport.getFileInputStream(file);
                    staxProperties.load(fileInputStream);
                }
            }
            catch (Exception exception) {
                lastModified = -1L;
                staxProperties = null;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            // ** MonitorExit[var6_9] (shouldn't be in output)
            if (staxProperties != null && (object = staxProperties.getProperty(string)) != null) {
                if (debug) {
                    FactoryFinder.dPrint("found in stax.properties, value=" + (String)object);
                }
                return FactoryFinder.newInstance((String)object, classLoader, true);
            }
            object = FactoryFinder.findJarServiceProvider(string);
            if (object != null) {
                return object;
            }
            if (string3 == null) {
                throw new ConfigurationError("Provider for " + string + " cannot be found", null);
            }
            if (debug) {
                FactoryFinder.dPrint("using fallback, value=" + string3);
            }
            return FactoryFinder.newInstance(string3, classLoader, true);
        }
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            Object object;
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                object = string.substring(0, n);
                securityManager.checkPackageAccess((String)object);
            }
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = FactoryFinder.class.getClassLoader();
                        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    throw classNotFoundException;
                }
            }
            object = clazz.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader != null) {
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                classLoader = FactoryFinder.class.getClassLoader();
                inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
            }
        } else {
            classLoader = FactoryFinder.class.getClassLoader();
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.dPrint("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        if (string3 != null && !"".equals(string3)) {
            if (debug) {
                FactoryFinder.dPrint("found in resource, value=" + string3);
            }
            return FactoryFinder.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static {
        staxProperties = null;
        lastModified = -1L;
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private static final long serialVersionUID = -7296589961713039167L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

