/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.lang.ref.SoftReference;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderManager {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static SAXParserFactory m_parserFactory;
    private static SAXParserFactory m_secureParserFactory;
    private ThreadLocal m_reader;
    private ThreadLocal m_secureReader;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance() {
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader() throws SAXException {
        return this.getXMLReader(false);
    }

    public synchronized XMLReader getXMLReader(boolean bl) throws SAXException {
        return this.getXMLReader(false, null);
    }

    public synchronized XMLReader getXMLReader(boolean bl, String string) throws SAXException {
        boolean bl2;
        XMLReader xMLReader = this.acquireThisThreadsReader(bl);
        boolean bl3 = bl2 = xMLReader != null;
        if (!bl2) {
            try {
                SAXParser sAXParser = this.getParserFactory(bl).newSAXParser();
                if (string != null) {
                    sAXParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", string);
                }
                xMLReader = sAXParser.getXMLReader();
                try {
                    xMLReader.setFeature(NAMESPACES_FEATURE, true);
                    xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                }
                catch (SAXException sAXException) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (this.getThisThreadsReader(bl) == null) {
                this.setThisThreadsReader(xMLReader, bl);
            }
        }
        return xMLReader;
    }

    public synchronized void releaseXMLReader(XMLReader xMLReader) {
        if (xMLReader == null) {
            return;
        }
        if (this.getThisThreadsReader(false) == xMLReader) {
            ((ReservableSoftReference)this.m_reader.get()).release();
        } else if (this.getThisThreadsReader(true) == xMLReader) {
            ((ReservableSoftReference)this.m_secureReader.get()).release();
        }
    }

    private XMLReader getThisThreadsReader(boolean bl) {
        XMLReader xMLReader = null;
        ThreadLocal threadLocal = this.getReader(bl);
        if (threadLocal == null) {
            return null;
        }
        ReservableSoftReference reservableSoftReference = (ReservableSoftReference)threadLocal.get();
        if (reservableSoftReference != null) {
            xMLReader = (XMLReader)reservableSoftReference.get();
        }
        return xMLReader;
    }

    private XMLReader acquireThisThreadsReader(boolean bl) {
        XMLReader xMLReader = null;
        ThreadLocal threadLocal = this.getReader(bl);
        if (threadLocal == null) {
            return null;
        }
        ReservableSoftReference reservableSoftReference = (ReservableSoftReference)threadLocal.get();
        if (reservableSoftReference != null && reservableSoftReference.isAvailable()) {
            xMLReader = (XMLReader)reservableSoftReference.get();
            reservableSoftReference.reserve();
        }
        return xMLReader;
    }

    private void setThisThreadsReader(XMLReader xMLReader, boolean bl) {
        if (xMLReader != null) {
            ReservableSoftReference reservableSoftReference = new ReservableSoftReference(xMLReader);
            if (bl) {
                this.m_secureReader.set(reservableSoftReference);
            } else {
                this.m_reader.set(reservableSoftReference);
            }
        }
    }

    private ThreadLocal getReader(boolean bl) {
        if (bl) {
            if (this.m_secureReader == null) {
                this.m_secureReader = new ThreadLocal();
                return null;
            }
            return this.m_secureReader;
        }
        if (this.m_reader == null) {
            this.m_reader = new ThreadLocal();
            return null;
        }
        return this.m_reader;
    }

    private SAXParserFactory getParserFactory(boolean bl) throws SAXException, ParserConfigurationException {
        if (bl) {
            if (m_secureParserFactory == null) {
                m_secureParserFactory = SAXParserFactory.newInstance();
                m_secureParserFactory.setNamespaceAware(true);
                m_secureParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            return m_secureParserFactory;
        }
        if (m_parserFactory == null) {
            m_parserFactory = SAXParserFactory.newInstance();
            m_parserFactory.setNamespaceAware(true);
            m_parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
        }
        return m_parserFactory;
    }

    private static class ReservableSoftReference
    extends SoftReference {
        private boolean m_inUse = true;

        public ReservableSoftReference(Object object) {
            super(object);
        }

        public boolean isAvailable() {
            return !this.m_inUse;
        }

        public void reserve() {
            this.m_inUse = true;
        }

        public void release() {
            this.m_inUse = false;
        }
    }
}

