/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertType;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.ClientCertDialog;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.PasswordCallbackHandler;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;

public final class X509DeployKeyManager
implements X509KeyManager {
    private X509KeyManager myKeyManager = null;
    private X509KeyManager browserKeyManager = null;
    private String userKeyStore = null;
    private String systemKeyStore = null;
    private KeyStore browserKeyStore = null;
    private boolean isWindows = Config.getOSName().indexOf("Windows") != -1;
    private static HashMap clientAuthCertsCachedMap = new HashMap();
    private static ThreadLocal clientCertDialogCancelled = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static ThreadLocal passwdDialogCancelled = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public X509DeployKeyManager() {
        this.userKeyStore = Config.getUserClientAuthCertFile();
        this.systemKeyStore = Config.getSystemClientAuthCertFile();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            this.browserKeyStore = service.getBrowserClientAuthKeyStore();
        }
    }

    private void init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
                    X509DeployKeyManager.this.do_init();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            if (exception instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)exception;
            }
            if (exception instanceof FileNotFoundException) {
                throw (FileNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
    }

    private void do_init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        this.browserKeyManager = this.getBrowserKeyManager(this.browserKeyStore);
        this.myKeyManager = Config.isJavaVersionAtLeast17() ? this.getNewMyKeyManager(this.userKeyStore, this.systemKeyStore) : this.getLegacyMyKeyManager(this.userKeyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        TreeMap<String, X509Certificate[]> treeMap = new TreeMap<String, X509Certificate[]>();
        TreeMap<String, CertType> treeMap2 = new TreeMap<String, CertType>();
        String string = null;
        String string2 = null;
        if (clientCertDialogCancelled.get().equals(Boolean.FALSE)) {
            Object object;
            String string3;
            Object object2;
            string2 = this.getHostnameForSocket(socket);
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = this.getClientAliases(stringArray[i], principalArray);
                if (object2 == null || ((String[])object2).length <= 0) continue;
                for (int j = 0; j < ((String[])object2).length; ++j) {
                    int n = CertType.PLUGIN.getType().length();
                    string3 = object2[j].substring(n);
                    object = this.getCertificateChain(string3);
                    try {
                        if (!CertUtils.checkTLSClient(object[0])) continue;
                        treeMap.put(string3, (X509Certificate[])object);
                        if (object2[j].startsWith(CertType.PLUGIN.getType())) {
                            treeMap2.put(string3, CertType.PLUGIN);
                        }
                        if (!object2[j].startsWith(CertType.BROWSER.getType())) continue;
                        treeMap2.put(string3, CertType.BROWSER);
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        Trace.msgSecurityPrintln("clientauth.checkTLSClient.failed", new Object[]{string3});
                    }
                }
            }
            if (passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                final TreeMap<String, X509Certificate[]> treeMap3 = treeMap;
                object2 = treeMap2;
                if (string2 != null) {
                    HashMap hashMap = clientAuthCertsCachedMap;
                    synchronized (hashMap) {
                        if (clientAuthCertsCachedMap.size() > 0) {
                            Iterator iterator = clientAuthCertsCachedMap.keySet().iterator();
                            string3 = null;
                            object = null;
                            while (iterator.hasNext()) {
                                string3 = (String)iterator.next();
                                if (string3.compareToIgnoreCase(string2) != 0) continue;
                                object = (String)clientAuthCertsCachedMap.get(string3);
                                Trace.msgSecurityPrintln("clientauth.readFromCache.success", new Object[]{object});
                                return object;
                            }
                        }
                    }
                }
                if (Config.getBooleanProperty("deployment.security.clientauth.keystore.auto") && treeMap3.size() <= 1) {
                    if (treeMap3.size() == 0) {
                        string = null;
                    } else {
                        Object[] objectArray = treeMap3.keySet().toArray();
                        string = (String)objectArray[0];
                    }
                } else {
                    DeploySysAction deploySysAction = new DeploySysAction((TreeMap)object2){
                        private final /* synthetic */ TreeMap val$theClientAuthTypeMap;
                        {
                            this.val$theClientAuthTypeMap = treeMap2;
                        }

                        public Object execute() {
                            return ClientCertDialog.showDialog(treeMap3, this.val$theClientAuthTypeMap);
                        }
                    };
                    string = (String)DeploySysRun.executePrivileged(deploySysAction, null);
                }
            }
            if (string == null) {
                clientCertDialogCancelled.set(Boolean.TRUE);
            }
            if (socket instanceof SSLSocket) {
                MyListener myListener = new MyListener(string2, string);
                ((SSLSocket)socket).addHandshakeCompletedListener(myListener);
            }
            return string;
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseClientAlias(stringArray, principalArray, null);
    }

    public synchronized String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = null;
        if (this.myKeyManager != null) {
            string2 = this.myKeyManager.chooseServerAlias(string, principalArray, socket);
        }
        if (string2 == null && this.browserKeyManager != null) {
            string2 = this.browserKeyManager.chooseServerAlias(string, principalArray, socket);
        }
        return string2;
    }

    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseServerAlias(string, principalArray, null);
    }

    public synchronized X509Certificate[] getCertificateChain(String string) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        X509Certificate[] x509CertificateArray = null;
        if (this.myKeyManager != null && !string.contains("Mozilla") && !string.contains("MSCrypto")) {
            x509CertificateArray = this.myKeyManager.getCertificateChain(string);
        }
        if (x509CertificateArray == null && this.browserKeyManager != null) {
            x509CertificateArray = this.browserKeyManager.getCertificateChain(string);
        }
        return x509CertificateArray;
    }

    public synchronized String[] getClientAliases(String string, Principal[] principalArray) {
        int n;
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.myKeyManager != null) {
            stringArray = this.myKeyManager.getClientAliases(string, principalArray);
        }
        if (this.browserKeyManager != null) {
            stringArray2 = this.browserKeyManager.getClientAliases(string, principalArray);
        }
        if (stringArray == null) {
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = CertType.BROWSER.getType() + stringArray2[i];
                }
            }
            return stringArray2;
        }
        if (stringArray2 == null) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = CertType.PLUGIN.getType() + stringArray[i];
                }
            }
            return stringArray;
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = CertType.PLUGIN.getType() + stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = CertType.BROWSER.getType() + stringArray2[n];
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public synchronized String[] getServerAliases(String string, Principal[] principalArray) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.myKeyManager != null) {
            stringArray = this.myKeyManager.getServerAliases(string, principalArray);
        }
        if (this.browserKeyManager != null) {
            stringArray2 = this.browserKeyManager.getServerAliases(string, principalArray);
        }
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public PrivateKey getPrivateKey(String string) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PrivateKey privateKey = null;
        if (this.myKeyManager != null && !string.contains("Mozilla") && !string.contains("MSCrypto")) {
            privateKey = this.myKeyManager.getPrivateKey(string);
        }
        if (privateKey == null && this.browserKeyManager != null) {
            privateKey = this.browserKeyManager.getPrivateKey(string);
        }
        return privateKey;
    }

    private X509KeyManager getBrowserKeyManager(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager x509KeyManager = null;
        if (keyStore != null) {
            keyStore.load(null, new char[0]);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("IbmX509");
            keyManagerFactory.init(keyStore, new char[0]);
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            for (int i = 0; i < keyManagerArray.length; ++i) {
                if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                x509KeyManager = (X509KeyManager)keyManagerArray[i];
                break;
            }
        }
        return x509KeyManager;
    }

    private X509KeyManager getNewMyKeyManager(String string, String string2) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager x509KeyManager;
        block6: {
            x509KeyManager = null;
            File file = new File(string);
            File file2 = new File(string2);
            if (file.exists() || file2.exists()) {
                try {
                    PasswordCallbackHandler passwordCallbackHandler = new PasswordCallbackHandler("clientauth.user.password.dialog.text");
                    PasswordCallbackHandler passwordCallbackHandler2 = new PasswordCallbackHandler("clientauth.system.password.dialog.text");
                    KeyStore.Builder builder = null;
                    KeyStore.Builder builder2 = null;
                    if (file.exists()) {
                        builder = KeyStore.Builder.newInstance("JKS", null, file, new KeyStore.CallbackHandlerProtection(passwordCallbackHandler));
                    }
                    if (file2.exists()) {
                        builder2 = KeyStore.Builder.newInstance("JKS", null, file2, new KeyStore.CallbackHandlerProtection(passwordCallbackHandler2));
                    }
                    KeyStoreBuilderParameters keyStoreBuilderParameters = new KeyStoreBuilderParameters(Arrays.asList(builder, builder2));
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("NewIbmX509");
                    keyManagerFactory.init(keyStoreBuilderParameters);
                    KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                    for (int i = 0; i < keyManagerArray.length; ++i) {
                        if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                        x509KeyManager = (X509KeyManager)keyManagerArray[i];
                        break;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (Trace.isAutomationEnabled()) break block6;
                    String string3 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.text");
                    String string4 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.caption");
                    ToolkitStore.getUI().showExceptionDialog(null, null, exception, string4, string3, null, null);
                }
            }
        }
        return x509KeyManager;
    }

    private X509KeyManager getLegacyMyKeyManager(String string) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager x509KeyManager = null;
        File file = new File(string);
        if (file.exists()) {
            boolean bl = true;
            while (bl) {
                Object object;
                String string2;
                try {
                    char[] cArray = this.getPasswordDialog("clientauth.user.password.dialog.text");
                    if (passwdDialogCancelled.get().equals(Boolean.TRUE)) break;
                    string2 = System.getProperty("javax.net.ssl.keyStoreType");
                    if (string2 == null) {
                        string2 = "JKS";
                    }
                    object = KeyStore.getInstance(string2);
                    ((KeyStore)object).load(new BufferedInputStream(new FileInputStream(string)), cArray);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("IbmX509");
                    keyManagerFactory.init((KeyStore)object, cArray);
                    KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                    for (int i = 0; i < keyManagerArray.length; ++i) {
                        if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                        x509KeyManager = (X509KeyManager)keyManagerArray[i];
                        break;
                    }
                    bl = false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (Trace.isAutomationEnabled()) continue;
                    string2 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.text");
                    object = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.caption");
                    ToolkitStore.getUI().showExceptionDialog(null, null, iOException, (String)object, string2, null, null);
                }
            }
        }
        return x509KeyManager;
    }

    private char[] getPasswordDialog(String string) {
        CredentialInfo credentialInfo = ToolkitStore.getUI().showPasswordDialog(null, X509DeployKeyManager.getMessage("password.dialog.title"), X509DeployKeyManager.getMessage(string), false, false, null, false, null);
        if (credentialInfo == null) {
            passwdDialogCancelled.set(Boolean.TRUE);
            return null;
        }
        return credentialInfo.getPassword();
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    String getHostnameForSocket(Socket socket) {
        String string;
        block4: {
            string = null;
            try {
                Class<?> clazz;
                boolean bl;
                String string2 = "com.sun.net.ssl.internal.ssl.SSLSocketImpl";
                if (Config.isJavaVersionAtLeast17()) {
                    string2 = "sun.security.ssl.SSLSocketImpl";
                }
                if (bl = (clazz = Class.forName(string2)).isInstance(socket)) {
                    Object obj = clazz.cast(socket);
                    final Method method = clazz.getDeclaredMethod("getHost", null);
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            method.setAccessible(true);
                            return null;
                        }
                    });
                    string = (String)method.invoke(obj, null);
                }
            }
            catch (Exception exception) {
                Trace.msgSecurityPrintln("clientauth.readFromCache.failed");
                if (exception == null) break block4;
                Trace.msgSecurityPrintln(exception.toString());
            }
        }
        return string;
    }

    static final class MyListener
    implements HandshakeCompletedListener {
        private String hostname;
        private String certName;

        public MyListener(String string, String string2) {
            this.hostname = string;
            this.certName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            Object object;
            if (this.hostname != null) {
                object = clientAuthCertsCachedMap;
                synchronized (object) {
                    clientAuthCertsCachedMap.put(this.hostname, this.certName);
                }
            }
            try {
                object = handshakeCompletedEvent.getSocket();
                ((SSLSocket)object).removeHandshakeCompletedListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof MyListener)) {
                return false;
            }
            MyListener myListener = (MyListener)object;
            return myListener.hostname.compareToIgnoreCase(this.hostname) == 0;
        }
    }
}

