/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

class X509Util {
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";

    X509Util() {
    }

    static Principal getIssuerPrincipal(Certificate certificate) {
        try {
            return ((X509Certificate)certificate).getIssuerX500Principal();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.println("NoSuchMethodError: X509Certificate.getIssuerX500Principal(): " + noSuchMethodError, TraceLevel.SECURITY);
            return ((X509Certificate)certificate).getIssuerDN();
        }
    }

    static Principal getSubjectPrincipal(Certificate certificate) {
        try {
            return ((X509Certificate)certificate).getSubjectX500Principal();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.println("NoSuchMethodError: X509Certificate.getSubjectX500Principal(): " + noSuchMethodError, TraceLevel.SECURITY);
            return ((X509Certificate)certificate).getSubjectDN();
        }
    }

    static List getExtendedKeyUsage(Certificate certificate) throws CertificateParsingException {
        try {
            return ((X509Certificate)certificate).getExtendedKeyUsage();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.println("NoSuchMethodError: X509Certificate.getExtendedKeyUsage(): " + noSuchMethodError, TraceLevel.SECURITY);
            try {
                return X509Util.oldGetExtendedKeyUsage((X509Certificate)certificate);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                String string = iOException.toString();
                throw new CertificateParsingException(string);
            }
            catch (CertificateException certificateException) {
                Trace.ignoredException(certificateException);
                String string = certificateException.toString();
                throw new CertificateParsingException(string);
            }
        }
    }

    private static List oldGetExtendedKeyUsage(X509Certificate x509Certificate) throws CertificateException, IOException {
        Object object;
        byte[] byArray = x509Certificate.getExtensionValue(OID_EXTENDED_KEY_USAGE);
        if (byArray == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        DerValue derValue = new DerValue(byArray2);
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>(1, 1);
        while (derValue.getData().available() != 0) {
            object = derValue.getData().getDerValue();
            ObjectIdentifier objectIdentifier = object.getOID();
            vector.addElement(objectIdentifier);
        }
        object = new ArrayList(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            ((ArrayList)object).add(vector.elementAt(i).toString());
        }
        return object;
    }

    static int showSecurityDialog(Certificate[] certificateArray, URL uRL, int n, int n2, boolean bl, int n3, Date date, AppInfo appInfo, boolean bl2, boolean bl3) throws CertificateException {
        int n4 = TrustDeciderDialog.showDialog(certificateArray, uRL, n, n2, bl, n3, date, appInfo, false, null, bl2, bl3);
        return n4;
    }
}

