/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.module;

import com.ibm.crypto.pkcs11impl.module.PKCS11Principal;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.nat.NativePKCS11;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PKCS11LoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private PKCS11Principal principal;
    private SessionManager sessionManager;
    private PKCS11 pkcs11 = null;
    private PKCS11Slot tokenSlot = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        fullFileName = null;
        findex = 0;
        slotIndex = 0;
        tokenSlots = null;
        this.succeeded = false;
        if (this.callbackHandler == null) {
            throw new FailedLoginException("callbackHandler is required for the PKCS11 Login Module.");
        }
        callbacks = new Callback[]{new TextInputCallback("PKCS11 DLL name: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            fullFileName = ((TextInputCallback)callbacks[0]).getText();
            tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication " + "information from the user");
        }
        if (this.debug) {
            System.out.println("DLL name: " + fullFileName);
        }
        if (fullFileName.toLowerCase().indexOf(".dll") < 0) {
            if (fullFileName.toLowerCase().indexOf(".so") < 0) {
                if (this.debug) {
                    System.out.println("fullFileName=" + fullFileName);
                    System.out.println("fullFileName.toLowerCase().indexOf()=" + fullFileName.toLowerCase().indexOf(".so"));
                }
                throw new LoginException("Invalid library name");
            }
            if (this.debug) {
                System.out.println("a unix lib:" + fullFileName);
            }
            findex = fullFileName.toLowerCase().indexOf(".so:") + 3;
            if (this.debug) {
                System.out.println("findex=" + findex);
            }
            if (findex > 2) {
                fileName = fullFileName.substring(0, findex);
                try {
                    if (this.debug) {
                        System.out.println("substring=" + fullFileName.substring(findex + 1, fullFileName.length()));
                    }
                    slotIndex = Integer.valueOf(fullFileName.substring(findex + 1, fullFileName.length()));
                    if (!this.debug) ** GOTO lbl60
                    System.out.println("slotIndex=" + slotIndex);
                }
                catch (NumberFormatException nfe) {
                    if (this.debug) {
                        nfe.printStackTrace();
                    }
                    throw new LoginException("Invalid slot number");
                }
            } else {
                findex = fullFileName.toLowerCase().indexOf(".so64:") + 3;
                if (findex > 2) {
                    fileName = fullFileName.substring(0, findex += 2);
                    try {
                        if (this.debug) {
                            System.out.println("substring=" + fullFileName.substring(findex + 1, fullFileName.length()));
                        }
                        slotIndex = Integer.valueOf(fullFileName.substring(findex + 1, fullFileName.length()));
                        if (!this.debug) ** GOTO lbl60
                        System.out.println("slotIndex=" + slotIndex);
                    }
                    catch (NumberFormatException nfe) {
                        throw new LoginException("Invalid slot number");
                    }
                } else {
                    fileName = fullFileName;
                }
            }
lbl60:
            // 5 sources

            aFile = new File(fileName);
            justFileName = aFile.getName();
            if (justFileName != null && justFileName.toLowerCase().startsWith("lib")) {
                fileName = aFile.getParent() + File.separator + justFileName.substring(3);
            }
            if (fileName.toLowerCase().endsWith(".so")) {
                fileName = fileName.substring(0, fileName.length() - 3);
            }
        } else {
            if (this.debug) {
                System.out.println("P4");
            }
            if ((findex = fullFileName.toLowerCase().indexOf(".dll:") + 4) > 3) {
                fileName = fullFileName.substring(0, findex);
                try {
                    slotIndex = Integer.valueOf(fullFileName.substring(findex + 1, fullFileName.length()));
                }
                catch (NumberFormatException nfe) {
                    throw new LoginException("Invalid slot number");
                }
            } else {
                fileName = fullFileName;
            }
            if (fileName.toLowerCase().endsWith(".dll")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
        }
        try {
            this.pkcs11 = new NativePKCS11(fileName);
        }
        catch (PKCS11Exception ex) {
            throw new LoginException("Invalid dll name : " + fileName);
        }
        if (this.debug) {
            System.out.println("P5");
        }
        this.pkcs11.libInitialize();
        try {
            this.pkcs11.libInitialize();
        }
        catch (PKCS11Exception pe) {
            // empty catch block
        }
        tokenSlots = this.pkcs11.getSlotList(true);
        if (slotIndex < 0 || slotIndex > tokenSlots.length - 1) {
            throw new LoginException("Invalid slot number : " + slotIndex);
        }
        this.tokenSlot = tokenSlots[slotIndex];
        session = null;
        try {
            this.sessionManager = SessionManager.getInstance(this.tokenSlot);
            session = this.sessionManager.getOpSession();
            if (password == null) {
                session.login(false, null);
            } else {
                session.login(false, new String(password));
            }
            this.sessionManager.releaseSession(session);
        }
        catch (Throwable var9_16) {
            this.sessionManager.releaseSession(session);
            throw var9_16;
        }
        this.principal = new PKCS11Principal(fullFileName, this.sessionManager);
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[PKCS11LoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
            if (this.debug) {
                System.out.println("\t\t[PKCS11LoginModule]: added PKCS11Principal");
            }
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[PKCS11LoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.principal = null;
            this.succeeded = false;
            this.sessionManager.closeAllSessions();
            this.tokenSlot.closeAllSessions();
            this.pkcs11.libFinalize();
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.principal);
        this.succeeded = false;
        this.commitSucceeded = false;
        this.principal = null;
        this.sessionManager.closeAllSessions();
        this.tokenSlot.closeAllSessions();
        this.pkcs11.libFinalize();
        if (this.debug) {
            System.out.println("\t\t[PKCS11LoginModule] completed logout processing");
        }
        return true;
    }
}

