/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.ec.ECParameters;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.security.auth.callback.CallbackHandler;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11keystore");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private SessionManager sessionManager = null;
    private Hashtable entries = new Hashtable();
    private Provider provider;
    private String providerName = "IBMPKCS11Impl";

    public PKCS11KeyStore() {
        this.sessionManager = ((IBMPKCS11Impl)Security.getProvider(this.providerName)).getSessionManager();
    }

    public PKCS11KeyStore(Provider provider) {
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.provider = provider;
        this.providerName = provider.getName();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)entry).key;
            }
            if (entry instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)entry).key;
            }
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
            chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                cert = ((TrustedCertEntry)entry).cert;
            } else if (entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
                cert = ((PrivateKeyEntry)entry).chain[0];
            }
        }
        return cert;
    }

    @Override
    public synchronized KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                PrivateKey privkey = (PrivateKey)((PrivateKeyEntry)entry).key;
                Certificate[] chain = null;
                if (((PrivateKeyEntry)entry).chain != null) {
                    chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
                }
                return new KeyStore.PrivateKeyEntry(privkey, chain);
            }
            if (entry instanceof SecretKeyEntry) {
                SecretKey seckey = (SecretKey)((SecretKeyEntry)entry).key;
                return new KeyStore.SecretKeyEntry(seckey);
            }
            if (entry instanceof TrustedCertEntry) {
                return new KeyStore.TrustedCertificateEntry(((TrustedCertEntry)entry).cert);
            }
        }
        return null;
    }

    @Override
    public synchronized void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            Certificate cert = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            this.engineSetCertificateEntry(alias, cert);
        } else if (entry instanceof KeyStore.PrivateKeyEntry) {
            PrivateKey key = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            Certificate[] chain = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
            char[] chars = null;
            this.engineSetKeyEntry(alias, key, chars, chain);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEnt = (KeyStore.SecretKeyEntry)entry;
            SecretKey skey = secretKeyEnt.getSecretKey();
            char[] chars = null;
            this.engineSetKeyEntry(alias, skey, chars, null);
        } else {
            throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date engineGetCreationDate(String alias) {
        Object date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            Session session = null;
            if (entry instanceof PrivateKeyEntry) {
                try {
                    session = this.sessionManager.getOpSession();
                    date = session.getAttrValue(((PrivateKeyEntry)entry).keyObject, 272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (date == null) {
                    PublicKey pkey;
                    Certificate[] chain;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the private key");
                    }
                    if ((chain = ((PrivateKeyEntry)entry).chain) != null && chain.length > 0 && (pkey = ((X509Certificate)chain[0]).getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof SecretKeyEntry) {
                try {
                    session = this.sessionManager.getOpSession();
                    date = session.getAttrValue(((SecretKeyEntry)entry).keyObject, 272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (date == null) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the secret key");
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof TrustedCertEntry) {
                try {
                    session = this.sessionManager.getOpSession();
                    date = session.getAttrValue(((TrustedCertEntry)entry).certObject, 272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (date == null) {
                    PublicKey pkey;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the certificate");
                    }
                    if ((pkey = ((TrustedCertEntry)entry).cert.getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            }
        }
        if (date == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetCreationDate", "no entry found associated with alias " + alias);
            }
            return null;
        }
        return (Date)date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  METHOD ENTRY.");
            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  DUMPING ALL ENTRIES IN THE HASHTABLE.");
            this.dumpKeyStoreEntries();
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Session session = null;
            PKCS11Object destroyIt = null;
            try {
                Object kf;
                String alg;
                Object entry;
                Session keySession;
                SessionManager keySessionManager;
                Object newEntry = null;
                session = this.sessionManager.getObjSession();
                if (this.engineIsCertificateEntry(alias)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineSetKeyEntry", "Alias exists for a certificate entry");
                        debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                    }
                    throw new KeyStoreException("Alias exists for a certificate entry");
                }
                if (this.engineIsKeyEntry(alias)) {
                    Object keyentry;
                    Object keyobj = this.entries.get(alias.toLowerCase());
                    if (keyobj instanceof PrivateKeyEntry) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The entry to be set is a PrivateKeyEntry at alias = " + alias.toLowerCase());
                            System.out.println("                                            This alias already exists.  We are attempting to replace it with another.");
                        }
                        keyentry = (PrivateKeyEntry)keyobj;
                        PKCS11PrivateKey ppkey = (PKCS11PrivateKey)((PrivateKeyEntry)keyentry).key;
                        destroyIt = ppkey.getObject();
                        if (debug != null) {
                            if (ppkey.getLabel() == null) {
                                System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The label lifted from the private key being replaced is NULL.  ");
                            } else {
                                System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The label lifted from the private key being replaced is = " + ppkey.getLabel());
                            }
                            if (ppkey.getID() == null) {
                                System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The ID lifted from the private key being replaced is NULL.  ");
                            } else {
                                System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The ID lifted from the private being replaced key is = " + PKCS11KeyStore.toHexString(ppkey.getID()));
                            }
                            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  Calling deleteChain( ) now ");
                        }
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  Calling deleteChain() to delete the cert chain from the pre-existing entry at alias = " + alias.toLowerCase());
                        }
                        this.deleteChain(session, ppkey.getID(), ppkey.getLabel());
                    } else {
                        keyentry = (SecretKeyEntry)keyobj;
                        PKCS11SecretKey skey = (PKCS11SecretKey)((SecretKeyEntry)keyentry).key;
                        destroyIt = ((SecretKeyEntry)keyentry).keyObject;
                    }
                }
                if (key instanceof PKCS11PrivateKey) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The entry to be set is a PrivateKeyEntry at alias = " + alias.toLowerCase());
                        System.out.println("                                            Creating the PrivateKeyEntry for the supplied key and cert chain.");
                        System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  The length of the cert chain for the PrivateKeyEntry to be created is: " + chain.length);
                        System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV BEGIN CHAIN VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV");
                        for (int ii = 0; ii < chain.length; ++ii) {
                            System.out.println(chain[ii].toString());
                        }
                        System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA END   CHAIN AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
                    }
                    keySessionManager = ((PKCS11PrivateKey)key).getSessionManager();
                    keySession = keySessionManager.getOpSession();
                    entry = new PrivateKeyEntry();
                    ((PrivateKeyEntry)entry).key = key;
                    ((PrivateKeyEntry)entry).keyObject = ((PKCS11PrivateKey)key).getObject();
                    Boolean tokenAttributeValue = (Boolean)this.getValue(keySession, ((PrivateKeyEntry)entry).keyObject, 1);
                    if (tokenAttributeValue == null || tokenAttributeValue != null && !tokenAttributeValue.booleanValue()) {
                        PKCS11PrivateKey pkey = this.makePrivKeyToken(session, (PKCS11PrivateKey)key, alias);
                        ((PrivateKeyEntry)entry).key = pkey;
                        ((PrivateKeyEntry)entry).keyObject = pkey.getObject();
                    } else if (!((String)this.getValue(keySession, ((PrivateKeyEntry)entry).keyObject, 3)).equalsIgnoreCase(alias)) {
                        PKCS11PrivateKey pkey = this.changePrivKeyLabel(session, (PKCS11PrivateKey)key, alias);
                        ((PrivateKeyEntry)entry).key = pkey;
                        ((PrivateKeyEntry)entry).keyObject = pkey.getObject();
                    }
                    ((PrivateKeyEntry)entry).chain = chain != null && chain[0] != null ? (Certificate[])chain.clone() : null;
                    if (destroyIt != null && destroyIt != ((PrivateKeyEntry)entry).keyObject) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  Destroying the pre-existing PrivateKey at alias:  " + alias.toLowerCase());
                        }
                        session.destroyObject(destroyIt);
                    }
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  Adding the new certificate chain to the PrivateKeyEntry being created.");
                    }
                    this.addCertificateChain(session, alias, ((PKCS11PrivateKey)key).getID(), ((PrivateKeyEntry)entry).chain, true);
                    newEntry = entry;
                    keySessionManager.releaseSession(keySession);
                } else if (key instanceof PKCS11SecretKey) {
                    keySessionManager = ((PKCS11SecretKey)key).getSessionManager();
                    keySession = keySessionManager.getOpSession();
                    entry = new SecretKeyEntry();
                    ((SecretKeyEntry)entry).key = key;
                    ((SecretKeyEntry)entry).keyObject = ((PKCS11SecretKey)key).getObject();
                    if (!((Boolean)this.getValue(keySession, ((SecretKeyEntry)entry).keyObject, 1)).booleanValue()) {
                        PKCS11SecretKey pkey = this.makeSecKeyToken(session, (PKCS11SecretKey)key, alias);
                        ((SecretKeyEntry)entry).key = pkey;
                        ((SecretKeyEntry)entry).keyObject = pkey.getObject();
                    } else if (!((String)this.getValue(keySession, ((SecretKeyEntry)entry).keyObject, 3)).equalsIgnoreCase(alias)) {
                        PKCS11SecretKey pkey = this.changeSecKeyLabel(session, (PKCS11SecretKey)key, alias);
                        ((SecretKeyEntry)entry).key = pkey;
                        ((SecretKeyEntry)entry).keyObject = pkey.getObject();
                    }
                    if (destroyIt != null && destroyIt != ((SecretKeyEntry)entry).keyObject) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                    newEntry = entry;
                    keySessionManager.releaseSession(keySession);
                } else if (key instanceof PrivateKey) {
                    PKCS11PrivateKey ppkey;
                    block64: {
                        alg = key.getAlgorithm();
                        ppkey = null;
                        kf = null;
                        try {
                            if (alg.equalsIgnoreCase("DSA")) {
                                kf = KeyFactory.getInstance("DSA", this.providerName);
                                ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                                break block64;
                            }
                            if (alg.equalsIgnoreCase("RSA")) {
                                kf = KeyFactory.getInstance("RSA", this.providerName);
                                ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                                break block64;
                            }
                            if (alg.equalsIgnoreCase("EC") || alg.equalsIgnoreCase("ECDSA")) {
                                kf = KeyFactory.getInstance("EC", this.providerName);
                                ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                                break block64;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + alg);
                                debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                            }
                            throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                        }
                        catch (Exception e) {
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)e);
                                debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                            }
                            throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                        }
                    }
                    PrivateKeyEntry entry2 = new PrivateKeyEntry();
                    if (!((String)this.getValue(session, ppkey.getObject(), 3)).equalsIgnoreCase(alias)) {
                        PKCS11PrivateKey pkey = this.changePrivKeyLabel(session, ppkey, alias);
                        entry2.key = pkey;
                        entry2.keyObject = pkey.getObject();
                    } else {
                        entry2.key = ppkey;
                        entry2.keyObject = ppkey.getObject();
                    }
                    entry2.chain = chain != null && chain[0] != null ? (Certificate[])chain.clone() : null;
                    if (destroyIt != null && destroyIt != entry2.keyObject) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                    if (((Boolean)this.getValue(session, entry2.keyObject, 1)).booleanValue()) {
                        this.addCertificateChain(session, alias, ppkey.getID(), entry2.chain, true);
                    } else {
                        this.addCertificateChain(session, alias, ppkey.getID(), entry2.chain, false);
                    }
                    newEntry = entry2;
                } else if (key instanceof SecretKey) {
                    alg = key.getAlgorithm();
                    PKCS11SecretKey skey = null;
                    kf = null;
                    try {
                        if (!(alg.equalsIgnoreCase("DES") || alg.equalsIgnoreCase("3DES") || alg.equalsIgnoreCase("DESede") || alg.equalsIgnoreCase("TripleDES") || alg.equalsIgnoreCase("ARCFOUR") || alg.equalsIgnoreCase("RC4") || alg.equalsIgnoreCase("Blowfish") || alg.equalsIgnoreCase("Generic") || alg.equalsIgnoreCase("AES"))) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + alg);
                                debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                            }
                            throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                        }
                        kf = SecretKeyFactory.getInstance(alg, this.providerName);
                        skey = (PKCS11SecretKey)((SecretKeyFactory)kf).translateKey((SecretKey)key);
                    }
                    catch (Exception e) {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)e);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                    }
                    SecretKeyEntry entry3 = new SecretKeyEntry();
                    if (!((String)this.getValue(session, skey.getObject(), 3)).equalsIgnoreCase(alias)) {
                        PKCS11SecretKey sskey = this.changeSecKeyLabel(session, skey, alias);
                        entry3.key = sskey;
                        entry3.keyObject = sskey.getObject();
                    } else {
                        entry3.key = skey;
                        entry3.keyObject = skey.getObject();
                    }
                    newEntry = entry3;
                    if (destroyIt != null && destroyIt != entry3.keyObject) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                } else {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineSetKeyEntry", "Invalid key type");
                        debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                    }
                    throw new KeyStoreException("Invalid key type");
                }
                this.entries.put(alias.toLowerCase(), newEntry);
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  METHOD EXIT.");
            System.out.println("PKCS11KeyStore.java:  engineSetKeyEntry():  DUMPING ALL ENTRIES IN THE HASHTABLE.");
            this.dumpKeyStoreEntries();
        }
    }

    private PKCS11PrivateKey changePrivKeyLabel(Session session, PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "changePrivKeyLabel", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{3};
        Object[] chgvalues = new Object[]{alias};
        return this.convertPrivKeyObj2(session, chgtypes, chgvalues, pkey, alias, true);
    }

    private PKCS11PrivateKey makePrivKeyToken(Session session, PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  makePrivKeyToken():  METHOD ENTRY");
            System.out.println("PKCS11KeyStore.java:  makePrivKeyToken():  The PKCS11Object of the PrivateKey passed in is:");
            System.out.println(pkey.getObject().toString());
        }
        int[] chgtypes = new int[]{1, 2, 3, 257};
        DerOutputStream privKeyDos = null;
        String privKeyNewString = null;
        X500Name privKeySubjName = null;
        String[] privKeyStringArray = null;
        UnstructuredName privKeyUnstructName = null;
        byte[] pkeySubject = null;
        byte[] pkeyEncodedSubject = null;
        pkeySubject = pkey.getSubject();
        if (pkeySubject != null) {
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "makePrivKeyToken_3a", "Try DER encoding private key subject name as X500 name initially");
                }
                privKeyDos = new DerOutputStream();
                privKeyNewString = new String(pkeySubject, "8859_1");
                privKeySubjName = new X500Name(privKeyNewString);
                privKeySubjName.encode(privKeyDos);
                pkeyEncodedSubject = privKeyDos.toByteArray();
            }
            catch (Exception ex3b) {
                try {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "makePrivKeyToken_3b", "DER encode private key subject name as UnstructuredName instead");
                    }
                    privKeyDos = new DerOutputStream();
                    privKeyStringArray = new String[]{new String(pkeySubject, "8859_1")};
                    privKeyUnstructName = new UnstructuredName(privKeyStringArray);
                    privKeyUnstructName.encode((OutputStream)privKeyDos);
                    pkeyEncodedSubject = privKeyDos.toByteArray();
                }
                catch (Exception ex3c) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "makePrivKeyToken_3c", (Throwable)ex3c);
                    }
                    throw new KeyStoreException(ex3c.getMessage());
                }
            }
        }
        Object[] chgvalues = new Object[]{Boolean.TRUE, Boolean.TRUE, alias, pkeyEncodedSubject};
        PKCS11PrivateKey convertedKey = this.convertPrivKeyObj2(session, chgtypes, chgvalues, pkey, alias, true);
        convertedKey.setKeyAsToken(true);
        pkey.setKeyAsToken(true);
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  makePrivKeyToken():  The PKCS11Object of the returned PrivateKey is:");
            System.out.println(convertedKey.getObject().toString());
            System.out.println("PKCS11KeyStore.java:  makePrivKeyToken():  METHOD EXIT");
        }
        return convertedKey;
    }

    private PKCS11PrivateKey convertPrivKeyObj2(Session session, int[] chgtypes, Object[] chgvalues, PKCS11PrivateKey pkey, String alias, boolean token) throws KeyStoreException {
        PKCS11Key key;
        block39: {
            key = null;
            PKCS11Object newObj = null;
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  METHOD ENTRY");
                System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The PKCS11Object taken from pkey with label = " + alias);
                System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  Trying to set the TOKEN attribute to:  " + token);
                System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The PKCS11Object from the private key passed in is:");
                System.out.println(pkey.getObject().toString());
            }
            try {
                newObj = session.copy(pkey.getObject(), chgtypes, chgvalues);
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The COPY attempt succeeded.  A new PKCS11Object was returned.");
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The copied PKCS11Object is shown below.  It should match the one above.");
                    System.out.println(newObj.toString());
                }
            }
            catch (Exception ke) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The COPY attempt failed.");
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The following exception was thrown while trying to make a copy of the PKCS11Object taken from pkey:");
                    System.out.println(ke.toString());
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The stack trace of that exception is:");
                    ke.printStackTrace();
                }
                int[] attrtypes = null;
                Object[] attrvalues = null;
                if (pkey instanceof PKCS11RSAPrivateKey) {
                    PKCS11RSAPrivateKey pRSA = (PKCS11RSAPrivateKey)pkey;
                    int[] attrtypesRSA = new int[]{0, 1, 2, 3, 256, 257, 258, 264, 265, 288, 291, 261, 268, 259, 296, 290, 292, 293, 294, 295};
                    Object[] attrvaluesRSA = new Object[]{PKCS11Object.PRIVATE_KEY, token, Boolean.TRUE, alias, PKCS11Object.RSA, pRSA.getSubject(), pRSA.getID(), pRSA.getSign(), pRSA.getSignRecover(), pRSA.getModulus(), pRSA.getPrivateExponent(), pRSA.getDecrypt(), pRSA.getDerive(), pRSA.getSensitive(), pRSA.getCoefficient(), pRSA.getPublicExponent(), pRSA.getPrime1(), pRSA.getPrime2(), pRSA.getExponent1(), pRSA.getExponent2()};
                    attrtypes = attrtypesRSA;
                    attrvalues = attrvaluesRSA;
                } else if (pkey instanceof PKCS11DSAPrivateKey) {
                    PKCS11DSAPrivateKey pDSA = (PKCS11DSAPrivateKey)pkey;
                    int[] attrtypesDSA = new int[]{17, 0, 1, 2, 3, 256, 257, 258, 264, 265, 306, 305, 304, 261, 268, 259};
                    Object[] attrvaluesDSA = new Object[]{pDSA.getValue().toByteArray(), PKCS11Object.PRIVATE_KEY, token, Boolean.TRUE, alias, PKCS11Object.DSA, pDSA.getSubject(), pDSA.getID(), pDSA.getSign(), pDSA.getSignRecover(), pDSA.getBase(), pDSA.getSubprime(), pDSA.getPrime(), pDSA.getDecrypt(), pDSA.getDerive(), pDSA.getSensitive()};
                    attrtypes = attrtypesDSA;
                    attrvalues = attrvaluesDSA;
                } else if (pkey instanceof PKCS11ECPrivateKey) {
                    PKCS11ECPrivateKey myPKCS11ECPrivateKey = (PKCS11ECPrivateKey)pkey;
                    int[] attrtypesEC = new int[]{17, 384, 0, 1, 2, 3, 256, 257, 258, 264, 265, 261, 268, 259};
                    BigInteger s = myPKCS11ECPrivateKey.getS();
                    ECParameterSpec params = myPKCS11ECPrivateKey.getParams();
                    byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
                    Object[] attrvaluesEC = new Object[]{PKCS11KeyStore.getMagnitude(s), encodedParams, PKCS11Object.PRIVATE_KEY, token, Boolean.TRUE, alias, PKCS11Object.EC, myPKCS11ECPrivateKey.getSubject(), myPKCS11ECPrivateKey.getID(), myPKCS11ECPrivateKey.getSign(), myPKCS11ECPrivateKey.getSignRecover(), myPKCS11ECPrivateKey.getDecrypt(), myPKCS11ECPrivateKey.getDerive(), myPKCS11ECPrivateKey.getSensitive()};
                    attrtypes = attrtypesEC;
                    attrvalues = attrvaluesEC;
                } else {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  PKCS11KeyStore cannot handle a key which is an instance of:  " + pkey.getClass().getName());
                    }
                    throw new KeyStoreException("PKCS11Keystore cannot handle a key which is an instance of:  " + pkey.getClass().getName());
                }
                try {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  Since the COPY attempt failed, try to CREATE a new PKCS11Object");
                    }
                    newObj = session.createObject(attrtypes, attrvalues);
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The CREATE of a new PKCS11Object succeeded");
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The newly created PKCS11Object is shown below.  It should match the one above.");
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The new PKCS11Object is:");
                        System.out.println(newObj.toString());
                    }
                }
                catch (Exception e) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  THE CREATION OF A NEW PKCS11Object FAILED");
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The following exception was thrown while trying to create a new PKCS11Object:");
                        System.out.println(e.toString());
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The stack trace of that exception is:");
                        e.printStackTrace();
                    }
                    if (newObj != null) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  For some reason, a newobj was created, in spite of the fact that an exception was thrown.");
                            System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  Destroying newobj now.");
                        }
                        session.destroyObject(newObj);
                    } else if (debug != null && newObj != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  As expected, a newobj was NOT created, since an exception was thrown.");
                    }
                    throw new KeyStoreException(e.getMessage());
                }
            }
            try {
                if (pkey instanceof PKCS11RSAPrivateKey) {
                    PKCS11RSAPrivateKey pRSA = (PKCS11RSAPrivateKey)pkey;
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  Attempting to create a new RSAPrivateKey instance using the 'COPIED' or 'CREATED' PKCS11Object");
                    }
                    key = new RSAPrivateKey(session, newObj, pRSA.getID(), pRSA.getSubject(), alias, token, pRSA.getSensitive(), pRSA.getSign(), pRSA.getDecrypt(), pRSA.getUnwrap(), pRSA.getExtractable(), pRSA.getModulus(), pRSA.getPublicExponent(), pRSA.getPrivateExponent(), pRSA.getPrime1(), pRSA.getPrime2(), pRSA.getExponent1(), pRSA.getExponent2(), pRSA.getCoefficient());
                    break block39;
                }
                if (pkey instanceof PKCS11DSAPrivateKey) {
                    PKCS11DSAPrivateKey pDSA = (PKCS11DSAPrivateKey)pkey;
                    key = new DSAPrivateKey(session, newObj, alias, pDSA.getID(), pDSA.getSubject(), token, pDSA.getSensitive(), pDSA.getExtractable(), pDSA.getPrime(), pDSA.getSubprime(), pDSA.getBase(), pDSA.getValue());
                    break block39;
                }
                if (pkey instanceof PKCS11ECPrivateKey) {
                    PKCS11ECPrivateKey pEC = (PKCS11ECPrivateKey)pkey;
                    ECParameterSpec params = pEC.getParams();
                    byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
                    try {
                        key = new PKCS11ECPrivateKey(session, newObj, pEC.getID(), pEC.getSubject(), alias, encodedParams, pEC.getS());
                    }
                    catch (Exception ex) {
                        key = new PKCS11ECPrivateKey(session, newObj, pEC.getID(), pEC.getSubject(), alias, encodedParams);
                    }
                    break block39;
                }
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  PKCS11KeyStore cannot handle a key which is an instance of:  " + pkey.getClass().getName());
                }
                throw new KeyStoreException("PKCS11Keystore cannot handle a key which is an instance of:  " + pkey.getClass().getName());
            }
            catch (Exception ie) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The following exception was thrown while attempting to create a new Java PrivateKey object using the COPIED or CREATED PKCS11Object");
                    System.out.println(ie.toString());
                    System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The stack trace of that exception is:");
                    ie.toString();
                }
                if (!IBMPKCS11Impl.doMemoryManagement()) {
                    if (!key.getToken().booleanValue()) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2( ):   key is NOT a token object.   Calling rm( ) ");
                            System.out.println("                                              The key label is  = " + key.getLabel());
                        }
                        key.rm();
                    } else if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2( ):  key is a token object.   NOT CALLING rm( )");
                        System.out.println("                                             The key label is  = " + key.getLabel());
                    }
                }
                throw new KeyStoreException(ie.getMessage());
            }
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  The new private key was created successfully.");
            System.out.println("PKCS11KeyStore.java:  convertPrivKeyObj2():  METHOD EXIT");
        }
        return key;
    }

    private PKCS11SecretKey changeSecKeyLabel(Session session, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "changeSecKeyLabel", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{3};
        Object[] chgvalues = new Object[]{alias};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "changeSecKeyLabel");
        }
        return this.convertSecKeyObj(session, chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11SecretKey makeSecKeyToken(Session session, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "makeSecKeyToken", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{1, 2, 3};
        Object[] chgvalues = new Object[]{Boolean.TRUE, Boolean.TRUE, alias};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "makeSecKeyToken");
        }
        return this.convertSecKeyObj(session, chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11SecretKey convertSecKeyObj(Session session, int[] chgtypes, Object[] chgvalues, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        PKCS11Object newObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "convertSecKeyObj");
        }
        try {
            newObj = session.copy(pkey.getObject(), chgtypes, chgvalues);
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertSecKeyObj", "make copy of secret key");
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertSecKeyObj", "Copy failed try to create token key");
            }
            try {
                PKCS11SecretKey gk;
                byte[] value = null;
                if (pkey instanceof GeneralKey) {
                    gk = (GeneralKey)pkey;
                    value = ((GeneralKey)gk).getValue();
                } else if (pkey instanceof PKCS11DESedeKey) {
                    gk = (PKCS11DESedeKey)pkey;
                    value = gk.getValue();
                } else if (pkey instanceof PKCS11DESKey) {
                    gk = (PKCS11DESKey)pkey;
                    value = gk.getValue();
                }
                int[] attrTypes = new int[]{0, 256, 258, 3, 2, 1, 259, 268, 260, 261, 262, 263, 17};
                Object[] attrValues = new Object[]{PKCS11Object.SECRET_KEY, pkey.getKeyType(), pkey.getID(), alias, Boolean.TRUE, Boolean.TRUE, pkey.getSensitive(), pkey.getDerive(), pkey.getEncrypt(), pkey.getDecrypt(), pkey.getWrap(), pkey.getUnwrap(), value};
                newObj = session.createObject(attrTypes, attrValues);
            }
            catch (PKCS11Exception pe) {
                if (newObj != null) {
                    session.destroyObject(newObj);
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "convertSecKeyObj", (Throwable)pe);
                    debug.exit(16384L, (Object)className, "convertSecKeyObj");
                }
                throw new KeyStoreException(pe.getMessage());
            }
        }
        GeneralKey key = null;
        try {
            if (pkey instanceof GeneralKey) {
                GeneralKey genKey = (GeneralKey)pkey;
                key = new GeneralKey(session, newObj, genKey.mechanismBuilder.getAlgorithm());
            } else if (pkey instanceof PKCS11DESKey) {
                key = new GeneralKey(session, newObj, "DES");
            } else if (pkey instanceof PKCS11DESedeKey) {
                key = new GeneralKey(session, newObj, "DESede");
            }
        }
        catch (InvalidKeyException ke) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "convertSecKeyObj", (Throwable)ke);
                debug.exit(16384L, (Object)className, "convertSecKeyObj");
            }
            throw new KeyStoreException(ke.getMessage());
        }
        finally {
            session.destroyObject(pkey.getObject());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "convertSecKeyObj");
        }
        return key;
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
            debug.text(16384L, (Object)className, "engineSetKeyEntry", "This method is not supported");
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetCertificateEntry", (Object)alias, (Object)cert);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Cannot overwrite key entry");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            Object[] certObj = new Object[2];
            byte[] id = null;
            if (cert instanceof X509Certificate) {
                byte[] subject = null;
                try {
                    id = alias.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    id = alias.getBytes();
                }
                byte[] issuer = null;
                CertificateSerialNumber serialNumber = null;
                byte[] encodedSerialNumber = null;
                DerOutputStream dos = null;
                if (id.length > 20) {
                    byte[] bytes = new byte[20];
                    System.arraycopy(id, 0, bytes, 0, 20);
                    id = bytes;
                }
                Session session = null;
                try {
                    session = this.sessionManager.getObjSession();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X509", this.providerName);
                    if (cert instanceof X509CertImpl) {
                        X509CertImpl thecert = (X509CertImpl)cert;
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getSubjectDN()).encode(dos);
                        subject = dos.toByteArray();
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getIssuerDN()).encode(dos);
                        issuer = dos.toByteArray();
                        dos = new DerOutputStream();
                        serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                        serialNumber.encode((OutputStream)dos);
                        encodedSerialNumber = dos.toByteArray();
                        certObj = this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
                    X509CertImpl thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    dos = new DerOutputStream();
                    serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                    serialNumber.encode((OutputStream)dos);
                    encodedSerialNumber = dos.toByteArray();
                    certObj = this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
                }
                catch (Exception ioe) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetCertificateEntry", (Throwable)ioe);
                        debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                    }
                    throw new KeyStoreException("Cannot store certificate :" + ioe.getMessage());
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Unsupported certificate type. Only X509 certificate is supported");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = cert;
            trustedCertEntry.certObject = (PKCS11Object)certObj[0];
            trustedCertEntry.label = alias;
            TrustedCertEntry.access$102(trustedCertEntry, id);
            if (certObj[1] != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetCertificateEntry", "certificate is session object, session " + certObj[1]);
                }
                trustedCertEntry.session = (Session)certObj[1];
            }
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
        }
    }

    private void addCertificateChain(Session session, String alias, byte[] id, Certificate[] cert, boolean isToken) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addCertificateChain", (Object)alias, (Object)isToken);
        }
        int[] attrType = new int[]{1, 0, 257, 130};
        byte[] subject = null;
        byte[] issuer = null;
        CertificateSerialNumber serialNumber = null;
        byte[] encodedSerialNumber = null;
        DerOutputStream dos = null;
        X509CertImpl thecert = null;
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "cert chain is null");
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            return;
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X509", this.providerName);
            if (cert[0] instanceof X509CertImpl) {
                thecert = (X509CertImpl)cert[0];
                dos = new DerOutputStream();
                ((X500Name)thecert.getSubjectDN()).encode(dos);
                subject = dos.toByteArray();
                dos = new DerOutputStream();
                ((X500Name)thecert.getIssuerDN()).encode(dos);
                issuer = dos.toByteArray();
                dos = new DerOutputStream();
                serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                serialNumber.encode((OutputStream)dos);
                encodedSerialNumber = dos.toByteArray();
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(cert[0].getEncoded());
                thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                dos = new DerOutputStream();
                ((X500Name)thecert.getSubjectDN()).encode(dos);
                subject = dos.toByteArray();
                dos = new DerOutputStream();
                ((X500Name)thecert.getIssuerDN()).encode(dos);
                dos = new DerOutputStream();
                serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                serialNumber.encode((OutputStream)dos);
                encodedSerialNumber = dos.toByteArray();
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "Alias = " + alias);
                debug.text(16384L, (Object)className, "addCertificateChain", "id = " + new HexDumpEncoder().encode(id));
            }
            this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
            for (int i = 1; i < cert.length; ++i) {
                if (cert[i] instanceof X509CertImpl) {
                    thecert = (X509CertImpl)cert[i];
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    issuer = dos.toByteArray();
                    dos = new DerOutputStream();
                    serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                    serialNumber.encode((OutputStream)dos);
                    encodedSerialNumber = dos.toByteArray();
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert[i].getEncoded());
                    thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    dos = new DerOutputStream();
                    serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                    serialNumber.encode((OutputStream)dos);
                    encodedSerialNumber = dos.toByteArray();
                }
                Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, subject, encodedSerialNumber};
                PKCS11Object pkcs11obj = null;
                session.findObjectsInit(attrType, attrVal);
                pkcs11obj = session.findObject();
                session.findObjectsFinal();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "addCertificateChain", "pkcs11obj = " + pkcs11obj);
                }
                if (pkcs11obj != null) continue;
                this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
            }
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "addCertificateChain", (Throwable)ex);
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            throw new KeyStoreException(ex.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addCertificateChain");
        }
    }

    private Object[] createCertObject(Session session, String label, Boolean isToken, byte[] value, byte[] subject, byte[] id, byte[] issuer, byte[] encodedSerialNumber) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "createCertObject", (Object)label, (Object)isToken);
        }
        int[] attrtypes = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] attrvalues = new Object[]{PKCS11Object.CERTIFICATE, isToken, Boolean.FALSE, label, PKCS11Object.X_509, id, subject, encodedSerialNumber, value, issuer};
        Object[] result = new Object[2];
        PKCS11Object newobj = null;
        try {
            newobj = session.createObject(attrtypes, attrvalues);
            if (!isToken.booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)"PKCS11KeyStore", "createCertObject", "certificate is session object, session is " + session);
                }
                session.addObject();
                result[1] = session;
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "createCertObject", (Throwable)e);
                debug.exit(16384L, (Object)className, "createCertObject");
            }
            throw new KeyStoreException("Cannot store certificate: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "createCertObject");
        }
        result[0] = newobj;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  METHOD ENTRY.");
            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  Delete the entry with label = " + alias);
            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  DUMPING ALL ENTRIES IN THE HASHTABLE AT METHOD ENTRY.");
            this.dumpKeyStoreEntries();
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Session session = null;
            try {
                session = this.sessionManager.getOpSession();
                if (this.engineIsKeyEntry(alias)) {
                    Object entry = this.entries.get(alias.toLowerCase());
                    if (entry instanceof PrivateKeyEntry) {
                        PrivateKeyEntry keyentry = (PrivateKeyEntry)entry;
                        byte[] savedIdFromPrivateKey = ((PKCS11Key)((Object)keyentry.key)).getID();
                        String savedLabelFromPrivateKey = ((PKCS11Key)((Object)keyentry.key)).getLabel();
                        this.deleteChain(session, ((PKCS11Key)((Object)keyentry.key)).getID(), ((PKCS11Key)((Object)keyentry.key)).getLabel());
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  The cert chain for the entry with label " + alias + " has been deleted.");
                        }
                        this.deleteKey(session, (PKCS11Key)((Object)keyentry.key), PKCS11Object.PRIVATE_KEY);
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  The private key for the entry with label " + alias + " has been deleted.");
                            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  BOTH THE PRIVATE KEY AND CERT CHAIN HAVE NOW BEEN DELETED FOR label = " + alias);
                        }
                        keyentry.chain = null;
                        keyentry.key = null;
                        keyentry.keyObject = null;
                    } else {
                        SecretKeyEntry keyentry = (SecretKeyEntry)entry;
                        this.deleteKey(session, (PKCS11Key)((Object)keyentry.key), PKCS11Object.SECRET_KEY);
                        keyentry.key = null;
                        keyentry.keyObject = null;
                    }
                } else if (this.engineIsCertificateEntry(alias)) {
                    TrustedCertEntry certentry = (TrustedCertEntry)this.entries.get(alias.toLowerCase());
                    this.deleteCert(session, certentry.keyID, certentry.label);
                    if (certentry.session != null) {
                        certentry.session.removeObject();
                        certentry.session = null;
                    }
                    certentry.cert = null;
                    certentry.certObject = null;
                    TrustedCertEntry.access$102(certentry, null);
                    certentry.label = null;
                }
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
            this.entries.remove(alias.toLowerCase());
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  METHOD EXIT.");
            System.out.println("PKCS11KeyStore.java:  engineDeleteEntry():  DUMPING ALL ENTRIES IN THE HASHTABLE AT METHOD EXIT.");
            this.dumpKeyStoreEntries();
        }
    }

    private void deleteKey(Session session, PKCS11Key key, int classNum) {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "deleteKey", (Object)keyString, (Object)classNum);
        }
        PKCS11Object pkcs11obj = null;
        String label = key.getLabel();
        byte[] id = key.getID();
        Integer keytype = key.getKeyType();
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  deleteKey():  Called to delete the key associated with label = " + label);
            System.out.println("                                    Calling the key's rm() method now.");
        }
        key.rm();
        int cnt = 5;
        if (label == null) {
            --cnt;
        }
        if (id == null || id.length == 0) {
            --cnt;
        }
        int[] attrTypeID = new int[cnt];
        Object[] val = new Object[cnt];
        int x = 0;
        attrTypeID[x] = 1;
        val[x] = Boolean.FALSE;
        attrTypeID[++x] = 0;
        val[x] = classNum;
        attrTypeID[++x] = 2;
        val[x] = Boolean.FALSE;
        ++x;
        if (label != null) {
            attrTypeID[x] = 3;
            val[x] = label;
            ++x;
        }
        if (id != null && id.length > 0) {
            attrTypeID[x] = 258;
            val[x] = id;
        }
        session.findObjectsInit(attrTypeID, val);
        pkcs11obj = session.findObject();
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteKey", (Object)"No Session object found.");
            }
            return;
        }
        session.destroyObject(pkcs11obj);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteKey", (Object)"Session object found.");
        }
    }

    private void deletePublicKey(Session session, Certificate[] cert, PKCS11Key key) {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "deletePublicKey", (Object)cert, (Object)keyString);
        }
        PKCS11Object pkcs11obj = null;
        int[] attrTypeID = null;
        Object[] val = null;
        if (cert == null || cert[0] == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "deletePublicKey", "No cert associated with private key.");
            }
            int[] attrTypeIDN = new int[]{1, 256, 0, 3, 258};
            Object[] valN = new Object[]{Boolean.TRUE, key.getKeyType(), PKCS11Object.PUBLIC_KEY, key.getLabel(), key.getID()};
            session.findObjectsInit(attrTypeIDN, valN);
            pkcs11obj = session.findObject();
            session.findObjectsFinal();
            if (pkcs11obj == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
                }
                return;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)("Object = " + pkcs11obj));
            }
            session.destroyObject(pkcs11obj);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
            }
            return;
        }
        PKCS11PublicKey pub = (PKCS11PublicKey)((X509Certificate)cert[0]).getPublicKey();
        if (pub.getKeyType() == PKCS11Object.RSA) {
            PKCS11RSAPublicKey pubRSA = (PKCS11RSAPublicKey)pub;
            int[] attrTypeIDRSA = new int[]{1, 256, 0, 288, 290, 3, 258};
            Object[] valRSA = new Object[]{Boolean.TRUE, PKCS11Object.RSA, PKCS11Object.PUBLIC_KEY, pubRSA.getModulus(), pubRSA.getPublicExponent(), key.getLabel(), key.getID()};
            attrTypeID = attrTypeIDRSA;
            val = valRSA;
        } else if (pub.getKeyType() == PKCS11Object.DSA) {
            PKCS11DSAPublicKey pubDSA = (PKCS11DSAPublicKey)pub;
            int[] attrTypeIDDSA = new int[]{1, 256, 0, 304, 305, 306, 17, 3, 258};
            Object[] valDSA = new Object[]{Boolean.TRUE, PKCS11Object.DSA, PKCS11Object.PUBLIC_KEY, pubDSA.getPrime(), pubDSA.getSubprime(), pubDSA.getBase(), pubDSA.getValue().toByteArray(), key.getLabel(), key.getID()};
            attrTypeID = attrTypeIDDSA;
            val = valDSA;
        } else if (pub.getKeyType() == PKCS11Object.EC) {
            PKCS11ECPublicKey pubEC = (PKCS11ECPublicKey)pub;
            int[] attrTypeIDEC = new int[]{1, 256, 0, 3, 258, 384, 385};
            ECParameterSpec params = pubEC.getParams();
            byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
            ECPoint point = pubEC.getW();
            byte[] pointdata = ECParameters.encodePoint((ECPoint)point, (EllipticCurve)params.getCurve());
            DerValue der = new DerValue(4, pointdata);
            byte[] encodedECPoint = null;
            try {
                encodedECPoint = der.toByteArray();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            Object[] valEC = new Object[]{Boolean.TRUE, PKCS11Object.EC, PKCS11Object.PUBLIC_KEY, key.getLabel(), key.getID(), encodedParams, encodedECPoint};
            attrTypeID = attrTypeIDEC;
            val = valEC;
        } else {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Key type not RSA, DSA, or EC.");
            }
            return;
        }
        session.findObjectsInit(attrTypeID, val);
        pkcs11obj = session.findObject();
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
            }
            return;
        }
        session.destroyObject(pkcs11obj);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
        }
    }

    private void deleteCert(Session session, byte[] id, String label) {
        int[] attrTypeID = new int[]{1, 0, 258};
        int[] attrTypeLabel = new int[]{1, 0, 3};
        byte[] subject = null;
        byte[] issuer = null;
        PKCS11Object pkcs11obj = null;
        if (debug != null) {
            if (label != null) {
                System.out.println("PKCS11KeyStore.java:  deleteCert():  METHOD ENTRY:  label=" + label);
            } else {
                System.out.println("PKCS11KeyStore.java:  deleteCert():  METHOD ENTRY:  label = NULL");
            }
        }
        if (id != null && id.length > 0) {
            Object[] val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, id};
            session.findObjectsInit(attrTypeID, val);
        } else {
            Object[] val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, label};
            session.findObjectsInit(attrTypeLabel, val);
        }
        pkcs11obj = session.findObject();
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  deleteCert():  No leaf cert found.  label=" + label + "   Returning.");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "deleteCert", "Delete Cert found.");
        }
        subject = (byte[])this.getValue(session, pkcs11obj, 257);
        issuer = (byte[])this.getValue(session, pkcs11obj, 129);
        session.destroyObject(pkcs11obj);
        if (this.bytesEquals(issuer, subject)) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  deleteCert():  The deleted cert was self-signed, so returning to caller.");
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteCert");
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase());
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
            isKey = true;
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntry) {
            isCert = true;
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = (String)e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                certElem = ((TrustedCertEntry)entry).cert;
            } else {
                if (!(entry instanceof PrivateKeyEntry) || ((PrivateKeyEntry)entry).chain == null) continue;
                certElem = ((PrivateKeyEntry)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            throw new IllegalArgumentException("LoadStoreParameter must not be null");
        }
        KeyStore.ProtectionParameter protectionParam = param.getProtectionParameter();
        if (protectionParam instanceof KeyStore.PasswordProtection) {
            char[] pwd = ((KeyStore.PasswordProtection)protectionParam).getPassword();
            this.engineLoad(null, pwd);
        } else if (protectionParam instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler handler = ((KeyStore.CallbackHandlerProtection)protectionParam).getCallbackHandler();
            Provider p1 = Security.getProvider(this.providerName);
            try {
                ((IBMPKCS11Impl)p1).login(null, handler);
            }
            catch (PKCS11Exception pex) {
                if (pex.getCode() != 256) {
                    throw new IOException(pex.getMessage());
                }
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            this.engineLoad(null, null);
        } else {
            throw new IllegalArgumentException("ProtectionParameter must be aPasswordProtection or CallbackHandlerProtection");
        }
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    private Object[] getValues(Session session, PKCS11Object pkcs11obj, int[] attrs) {
        return session.getAttrValues(pkcs11obj, attrs);
    }

    private Object[] getAttributes(PKCS11Object pkcs11obj) {
        return null;
    }

    private boolean bytesEquals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected void finalize() {
    }

    public static byte[] getMagnitude(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }

    public boolean doesPublicKeyMatchPrivateKey(PublicKey publicKey, PrivateKey privateKey, String providerName) throws NoSuchAlgorithmException {
        if (debug != null) {
            String algorithm = privateKey.getAlgorithm();
            if (algorithm == null) {
                System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The algorithm carried by the privateKey is NULL !!!!");
            } else {
                System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The algorithm carried by the privateKey is:  " + algorithm);
            }
        }
        byte[] origMsg = "this is a testmessage used by the signature algorithm".getBytes();
        Signature sig = null;
        try {
            if (debug != null) {
                String algorithm = privateKey.getAlgorithm();
                if (algorithm == null) {
                    System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  Creating a Signature object for a NULL algorithm name.  An exception should be thrown.");
                } else {
                    System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  Creating a Signature object for the algorithm:               " + algorithm);
                    System.out.println("                                                      Creating the Signature object using the following provider:  " + providerName);
                }
            }
            sig = Signature.getInstance(privateKey.getAlgorithm(), providerName);
        }
        catch (Exception ex) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The following exception was thrown while trying to create the Signature object:  ");
                ex.printStackTrace();
            }
            sig = Signature.getInstance(privateKey.getAlgorithm());
        }
        byte[] signature = null;
        try {
            sig.initSign(privateKey);
            sig.update(origMsg);
            signature = sig.sign();
            if (debug != null) {
                if (signature == null) {
                    System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The returned signature byte array is NULL.  This likely signals an error.");
                } else if (signature.length == 0) {
                    System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The length of the returned signature array is 0.  This likely signals an error. ");
                } else {
                    System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The length of the returned signature array is:  " + signature.length);
                }
            }
        }
        catch (Exception ex) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  An error occurred while trying to compute the Signature.");
                System.out.println("The exception thrown is:");
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            return false;
        }
        try {
            sig.initVerify(publicKey);
            sig.update(origMsg);
            if (sig.verify(signature)) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The public key matches the private key.");
                }
                return true;
            }
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  The public key DOES NOT match the private key.");
            }
            return false;
        }
        catch (Exception ex) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java: doesPublicKeyMatchPrivateKey():  An error occurred while trying to verify the Signature.");
                System.out.println("                                                      Therefore, the public key DOES NOT match the private key.");
            }
            return false;
        }
    }

    public boolean isSigner(X509Certificate signerCert, X509Certificate signedCert, String providerName) {
        if (debug != null) {
            System.out.println("=============================================================================================================");
            System.out.println("PKCS11KeyStore.java:  isSigner():  The signerCert passed in is:  " + signerCert.getSubjectX500Principal().toString());
            System.out.println("                                   The signedCert passed in is:  " + signedCert.getSubjectX500Principal().toString());
        }
        PublicKey signerPubKey = signerCert.getPublicKey();
        try {
            if (providerName != null) {
                signedCert.verify(signerPubKey, providerName);
            } else {
                signedCert.verify(signerPubKey);
            }
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  isSigner():  The signerCert DID sign the signedCert.  Returning 'true' ");
                System.out.println("=============================================================================================================");
            }
            return true;
        }
        catch (Exception ex) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  isSigner():  The signerCert DID NOT sign the signedCert.  Returning 'false' ");
                System.out.println("=============================================================================================================");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  engineLoad():  METHOD ENTRY.");
            System.out.println("PKCS11KeyStore.java:  engineLoad():  DUMPING ALL ENTRIES IN THE HASHTABLE AT METHOD ENTRY.");
            this.dumpKeyStoreEntries();
        }
        Session session = null;
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            block108: {
                try {
                    String label;
                    session = this.sessionManager.getOpSession();
                    if (password != null) {
                        block105: {
                            try {
                                session.login(false, new String(password));
                            }
                            catch (PKCS11Exception pex) {
                                if (pex.getCode() == 256) break block105;
                                throw new IOException(pex.getMessage());
                            }
                        }
                        password = null;
                    }
                    this.entries.clear();
                    PKCS11Object pkcs11obj = null;
                    Object obj = null;
                    CertificateFactory certFactory = null;
                    try {
                        certFactory = CertificateFactory.getInstance("X509", this.providerName);
                    }
                    catch (Exception ee) {
                        if (debug != null) {
                            ee.printStackTrace();
                            if (debug != null) {
                                debug.exit(16384L, (Object)className, "engineLoad");
                            }
                        }
                        throw new RuntimeException("PKCS11KeyStore.java:  engineLoad():  Failure while creating a CertificateFactory object.");
                    }
                    Vector<PKCS11Object> privKeys = new Vector<PKCS11Object>();
                    Vector<PKCS11Object> secretKeys = new Vector<PKCS11Object>();
                    Vector<PKCS11CertObj> certs = new Vector<PKCS11CertObj>();
                    session.findObjectsInit(null, null);
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  engineLoad():  Entering loop to begin building the object vectors");
                    }
                    while ((pkcs11obj = session.findObject()) != null) {
                        obj = this.getValue(session, pkcs11obj, 0);
                        if (obj != null && ((Integer)obj).equals(PKCS11Object.PRIVATE_KEY)) {
                            if (debug != null) {
                                System.out.println("PKCS11KeyStore.java:  engineLoad():  Adding an element to the private keys Vector");
                                System.out.println("                                     The label of this element is = " + (String)this.getValue(session, pkcs11obj, 3));
                            }
                            privKeys.add(pkcs11obj);
                            continue;
                        }
                        if (obj != null && ((Integer)obj).equals(PKCS11Object.CERTIFICATE)) {
                            if (debug != null) {
                                System.out.println("PKCS11KeyStore.java:  engineLoad():  Adding an element to the certificates Vector");
                                System.out.println("                                     The label of this element is = " + (String)this.getValue(session, pkcs11obj, 3));
                            }
                            certs.add(new PKCS11CertObj(pkcs11obj));
                            continue;
                        }
                        if (obj != null && ((Integer)obj).equals(PKCS11Object.SECRET_KEY)) {
                            if (debug != null) {
                                System.out.println("PKCS11KeyStore.java:  engineLoad():  Adding an element to the secret keys Vector");
                                System.out.println("                                     The label of this element is = " + (String)this.getValue(session, pkcs11obj, 3));
                            }
                            secretKeys.add(pkcs11obj);
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("PKCS11KeyStore.java:  engineLoad():  THIS HARDWARE OBJECT WAS NOT ADDED TO ANY VECTOR.");
                    }
                    session.findObjectsFinal();
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + privKeys.size() + " # certs=" + certs.size() + " # secret keys=" + secretKeys.size());
                    }
                    if (debug != null) {
                        System.out.println("=======================================================================================================");
                        System.out.println("PKCS11KeyStore.java:  engineLoad():  OBJECT VECTOR BUILDING HAS COMPLETED.");
                        System.out.println("PKCS11KeyStore.java:  engineLoad():  The initial certs      Vector contains " + certs.size() + " entries.");
                        System.out.println("PKCS11KeyStore.java:  engineLoad():  The initial privKeys   Vector contains " + privKeys.size() + " entries.");
                        System.out.println("PKCS11KeyStore.java:  engineLoad():  The initial secretKeys Vector contains " + secretKeys.size() + " entries.");
                        if (certs.size() != 0) {
                            System.out.println("PKCS11KeyStore.java:  engineLoad(): Dumping the initial certs vector contents: ");
                            for (int kkk = 0; kkk < certs.size(); ++kkk) {
                                PKCS11CertObj mycertobj = (PKCS11CertObj)certs.get(kkk);
                                X509Certificate mytempcert = mycertobj.getX509Certificate(certFactory, session);
                                System.out.println(mytempcert.toString());
                            }
                            System.out.println("PKCS11KeyStore.java:  engineLoad(): End of initial certs vector contents.");
                        }
                        System.out.println("=======================================================================================================");
                    }
                    String tmpKeyName = "privateKey";
                    int nameNum = 0;
                    int num = 0;
                    if (privKeys.size() > 0) {
                        Enumeration en = privKeys.elements();
                        boolean p = false;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                        }
                        label = null;
                        byte[] id = null;
                        byte[] sub = null;
                        Object[] results = null;
                        Boolean isToken = new Boolean("false");
                        while (en.hasMoreElements()) {
                            PKCS11Object pobj = (PKCS11Object)en.nextElement();
                            results = this.getValues(session, pobj, new int[]{3, 258, 257, 1});
                            label = (String)results[0];
                            id = (byte[])results[1];
                            sub = (byte[])results[2];
                            isToken = (Boolean)results[3];
                            if (debug != null) {
                                System.out.println("\nPKCS11Keystore.java:  engineLoad():  THIS IS THE TOP OF THE WHILE LOOP FOR THE NEXT PRIVATE KEY");
                                System.out.println("                                     The next private key to be processed has the following label:  " + label);
                            }
                            String empty = "e";
                            if (label != null && isToken.booleanValue()) {
                                PrivateKey key;
                                if (debug != null) {
                                    System.out.println("\nPKCS11KeyStore.java:  engineLoad():  The label of this private key taken from the Vector was NOT NULL, ");
                                    System.out.println("                                     AND this private key carries a TOKEN attribute of 'true'");
                                    System.out.println("                                     Try to create a PrivateKeyEntry from it.");
                                }
                                if ((key = this.buildPrivateKey(session, pobj)) == null) continue;
                                PKCS11CertObj cobj = null;
                                X509Certificate[] chain = null;
                                ArrayList<PKCS11Object> sortedCertObjects = new ArrayList<PKCS11Object>();
                                int sortedCertObjectsIndex = 0;
                                PKCS11Object myobj = this.findThePrivateKeysCert(session, id, label, key);
                                if (myobj == null) continue;
                                if (debug != null) {
                                    System.out.println("PKCS11KeyStore.java:  engineLoad():  findThePrivateKeysCert() found a matching cert for the private key at label = " + label);
                                }
                                sortedCertObjects.add(sortedCertObjectsIndex, myobj);
                                ++sortedCertObjectsIndex;
                                myobj = this.findSigner(session, myobj);
                                while (myobj != null) {
                                    sortedCertObjects.add(sortedCertObjectsIndex, myobj);
                                    ++sortedCertObjectsIndex;
                                    myobj = this.findSigner(session, myobj);
                                }
                                chain = new X509Certificate[sortedCertObjects.size()];
                                cobj = null;
                                X509Certificate mycert = null;
                                for (int i = 0; i < sortedCertObjects.size(); ++i) {
                                    cobj = new PKCS11CertObj((PKCS11Object)sortedCertObjects.get(i));
                                    try {
                                        mycert = cobj.getX509Certificate(certFactory, session);
                                        if (mycert == null) {
                                            throw new RuntimeException("PKCS11KeyStore.java:  engineLoad():  Invalid certificate PKCS11CertObj");
                                        }
                                        chain[i] = mycert;
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        if (debug != null) {
                                            System.out.println("PKCS11KeyStore.java:  engineLoad():  The following exception was thrown while executing cobj.getX509Certificate(certFactory, session):");
                                            System.out.println(ex.toString());
                                            ex.printStackTrace();
                                        }
                                        throw new RuntimeException("PKCS11KeyStore.java:  engineLoad():  Failure while executing cobj.getX509Certificate(certFactory, session)");
                                    }
                                }
                                if (debug != null) {
                                    System.out.println("PKCS11KeyStore.java:  engineLoad():  The size of the sorted X509Certificate chain built is: " + chain.length);
                                    System.out.println("PKCS11KeyStore.java:  engineLoad():  The elements of the chain are:");
                                    for (int zz = 0; zz < chain.length; ++zz) {
                                        System.out.println(chain[zz].toString());
                                    }
                                }
                                PrivateKeyEntry keyEntry = new PrivateKeyEntry();
                                keyEntry.key = key;
                                keyEntry.keyObject = pobj;
                                keyEntry.chain = chain;
                                if (label != null && label.length() != 0) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "label != null");
                                    }
                                    ((PKCS11Key)((Object)key)).getLabel();
                                    if (!this.entries.containsKey(label.toLowerCase())) {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                        }
                                        this.entries.put(label.toLowerCase(), keyEntry);
                                        if (debug == null) continue;
                                        debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + label.toLowerCase() + "] to entries");
                                        continue;
                                    }
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                    }
                                    boolean foundLabel = false;
                                    while (!foundLabel) {
                                        String newLabel = label + "key" + num;
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "finding label: " + newLabel);
                                        }
                                        if (this.entries.get(newLabel.toLowerCase()) == null) {
                                            this.entries.put(newLabel.toLowerCase(), keyEntry);
                                            if (debug != null) {
                                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + newLabel.toLowerCase() + "] to entries");
                                            }
                                            foundLabel = true;
                                            continue;
                                        }
                                        ++num;
                                    }
                                    continue;
                                }
                                boolean foundName = false;
                                while (!foundName) {
                                    String keyName = tmpKeyName + nameNum;
                                    if (!this.entries.containsKey(keyName.toLowerCase())) {
                                        this.entries.put(keyName.toLowerCase(), keyEntry);
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + keyName.toLowerCase() + "] to entries");
                                        }
                                        foundName = true;
                                        continue;
                                    }
                                    ++nameNum;
                                }
                                continue;
                            }
                            if (debug == null) continue;
                            System.out.println("\nPKCS11KeyStore.java:  engineLoad():  Either the label of this private key taken from the Vector was null, ");
                            System.out.println("                                     OR this private key does not carry a TOKEN attribute of 'true'");
                            System.out.println("                                     No attempt will be made to create a PrivateKeyEntry from it.");
                        }
                        privKeys.removeAllElements();
                    } else if (debug != null) {
                        System.out.println("PKCS11Keystore.java:  engineLoad():  No private keys were found on the hardware.  Therefore, no PrivateKeyEntries have been created.");
                    }
                    if (debug != null) {
                        System.out.println("PKCS11Keystore.java:  engineLoad():  FINISHED.  All private keys have been processed.  All PrivateKeyEntry's have been created.");
                    }
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java: engineLoad():  Begin processing the secretKeys VECTOR.  The number of secretKeys in the VECTOR is:  " + secretKeys.size());
                    }
                    tmpKeyName = "secretKey";
                    nameNum = 0;
                    num = 0;
                    Enumeration myEnum = secretKeys.elements();
                    block36: while (myEnum.hasMoreElements()) {
                        GeneralKey key;
                        PKCS11Object sobj;
                        block107: {
                            Integer keytype;
                            block106: {
                                sobj = null;
                                label = null;
                                keytype = null;
                                Object[] results = null;
                                sobj = (PKCS11Object)myEnum.nextElement();
                                try {
                                    results = this.getValues(session, sobj, new int[]{3, 256});
                                    label = (String)results[0];
                                    keytype = (Integer)results[1];
                                    if (label == null) {
                                        if (debug == null) continue;
                                        System.out.println("PKCS11KeyStore.java: engineLoad():  The CKA_LABEL of this hardware secret key is null.  SKIPPING IT.");
                                        continue;
                                    }
                                    if (debug != null) {
                                        System.out.println("PKCS11KeyStore.java: engineLoad():  The CKA_LABEL of this hardware secret key is:  " + label);
                                    }
                                    if (keytype == null) {
                                        if (debug == null) continue;
                                        System.out.println("PKCS11KeyStore.java: engineLoad():  The KEY_TYPE of this hardware secret key is null.  SKIPPING IT.");
                                        continue;
                                    }
                                    if (debug == null) break block106;
                                    System.out.println("PKCS11KeyStore.java: engineLoad():  The THE KEY_TYPE of this hardware secret key is:  " + keytype);
                                }
                                catch (Exception nsee) {
                                    if (debug == null) continue;
                                    System.out.println("PKCS11KeyStore.java: engineLoad():  The following exception was thrown while trying to learn attributes from a hardware secret key:");
                                    continue;
                                }
                            }
                            key = null;
                            try {
                                switch (keytype) {
                                    case 19: {
                                        key = new GeneralKey(session, sobj, "DES");
                                        break block107;
                                    }
                                    case 21: {
                                        key = new GeneralKey(session, sobj, "DESede");
                                        break block107;
                                    }
                                    case 18: {
                                        key = new GeneralKey(session, sobj, "RC4");
                                        break block107;
                                    }
                                    case 31: {
                                        key = new GeneralKey(session, sobj, "AES");
                                        break block107;
                                    }
                                    case 16: {
                                        key = new GeneralKey(session, sobj, "Generic");
                                        break block107;
                                    }
                                    case 32: {
                                        key = new GeneralKey(session, sobj, "BLOWFISH");
                                        break block107;
                                    }
                                    default: {
                                        if (debug == null) continue block36;
                                        debug.text(16384L, (Object)className, "engineLoad_4", "Key Type not supported. " + keytype);
                                        break;
                                    }
                                }
                                continue;
                            }
                            catch (Exception ikee) {
                                if (debug == null) break block107;
                                debug.exception(16384L, (Object)className, "engineLoad_4.1", (Throwable)ikee);
                            }
                        }
                        SecretKeyEntry keyEntry = new SecretKeyEntry();
                        keyEntry.key = key;
                        keyEntry.keyObject = sobj;
                        if (debug != null) {
                            try {
                                debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + ((Object)key).toString() + "\nkeyObject =" + sobj + "\nLabel = " + label);
                            }
                            catch (Exception ex) {
                                debug.exception(16384L, (Object)className, "engineLoad", (Throwable)ex);
                            }
                        }
                        if (label != null && label.length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(label.toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(label.toLowerCase(), keyEntry);
                                if (debug == null) continue;
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + label.toLowerCase() + "] to entries");
                                continue;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                            }
                            boolean foundLabel = false;
                            while (!foundLabel) {
                                String newLabel;
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                }
                                if (this.entries.get((newLabel = label + "sec" + num).toLowerCase()) == null) {
                                    this.entries.put(newLabel.toLowerCase(), keyEntry);
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + newLabel.toLowerCase() + "] to entries");
                                    }
                                    foundLabel = true;
                                    continue;
                                }
                                ++num;
                            }
                            continue;
                        }
                        boolean foundName = false;
                        while (!foundName) {
                            String keyName = tmpKeyName + nameNum;
                            if (!this.entries.containsKey(keyName.toLowerCase())) {
                                this.entries.put(keyName.toLowerCase(), keyEntry);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + keyName.toLowerCase() + "] to entries");
                                }
                                foundName = true;
                                continue;
                            }
                            ++nameNum;
                        }
                    }
                    secretKeys.removeAllElements();
                    String tmpCertName = "cert";
                    nameNum = 0;
                    if (certs.size() <= 0) break block108;
                    int j = certs.size();
                    Enumeration e = certs.elements();
                    for (int k = 0; k < j; ++k) {
                        PKCS11CertObj cobj;
                        block109: {
                            cobj = null;
                            try {
                                cobj = (PKCS11CertObj)e.nextElement();
                                if (debug == null) break block109;
                                debug.text(16384L, (Object)className, "engineLoad", "cobj: " + cobj);
                            }
                            catch (NoSuchElementException nsee) {
                                k = j;
                                continue;
                            }
                        }
                        String label2 = cobj.getLabel(session);
                        TrustedCertEntry ce = new TrustedCertEntry();
                        ce.cert = cobj.getX509Certificate(certFactory, session);
                        ce.certObject = cobj.getPKCS11Object();
                        ce.label = label2;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + ce.cert.toString() + "\n CertObject =" + cobj + "\nLabel = " + label2);
                        }
                        if (label2 != null && label2.length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(label2.toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(label2.toLowerCase(), ce);
                                if (debug == null) continue;
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + label2.toLowerCase() + "] to entries");
                                continue;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                            }
                            boolean foundLabel = false;
                            while (!foundLabel) {
                                String newLabel;
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                }
                                if (this.entries.get((newLabel = label2 + "cert" + num).toLowerCase()) == null) {
                                    this.entries.put(newLabel.toLowerCase(), ce);
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + newLabel.toLowerCase() + "] to entries");
                                    }
                                    foundLabel = true;
                                    continue;
                                }
                                ++num;
                            }
                            continue;
                        }
                        boolean foundName = false;
                        while (!foundName) {
                            String keyName = tmpCertName + nameNum;
                            if (!this.entries.containsKey(keyName.toLowerCase())) {
                                this.entries.put(keyName.toLowerCase(), ce);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + keyName.toLowerCase() + "] to entries");
                                }
                                foundName = true;
                                continue;
                            }
                            ++nameNum;
                        }
                    }
                    certs.removeAllElements();
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            }
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  engineLoad():  METHOD EXIT.");
            System.out.println("PKCS11KeyStore.java:  engineLoad():  DUMPING ALL ENTRIES IN THE HASHTABLE AT METHOD EXIT.");
            this.dumpKeyStoreEntries();
        }
    }

    private PKCS11Object findThePrivateKeysCert(Session session, byte[] id, String label, PrivateKey privateKey) {
        Object[] val;
        int[] attrTypeID = new int[]{1, 0, 258};
        int[] attrTypeLabel = new int[]{1, 0, 3};
        PKCS11Object pkcs11obj = null;
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  METHOD ENTRY");
            System.out.println("PKCS11KeyStore.java:  findThePrivateKeyCert( ):  The label of the private key passed in is:  " + label);
        }
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X509", this.providerName);
        }
        catch (Exception ee) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  The following exception was thrown attempting to obtain CertificateFactory object.");
                System.out.println(ee.toString());
                ee.printStackTrace();
            }
            throw new RuntimeException("PKCS11KeyStore.findThePrivateKeysCert() failed.  A CertificateFactory instance could not be created.");
        }
        if (id != null && id.length > 0) {
            val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, id};
            session.findObjectsInit(attrTypeID, val);
        } else {
            val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, label};
            session.findObjectsInit(attrTypeLabel, val);
        }
        PKCS11CertObj cobj = null;
        X509Certificate myTempCert = null;
        pkcs11obj = session.findObject();
        while (pkcs11obj != null) {
            try {
                PublicKey publicKey;
                cobj = new PKCS11CertObj(pkcs11obj);
                myTempCert = cobj.getX509Certificate(certFactory, session);
                if (myTempCert == null) {
                    throw new RuntimeException("PKCS11KeyStore.java:  findThePrivateKeysCert():  Invalid certificate PKCS11CertObj");
                }
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  subjectDN of the next cert being examined is = " + myTempCert.getSubjectX500Principal().toString());
                }
                if (!this.doesPublicKeyMatchPrivateKey(publicKey = myTempCert.getPublicKey(), privateKey, this.providerName)) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  This cert does not match the private key.");
                        System.out.println("                                                 Continue the search.                     ");
                    }
                    pkcs11obj = session.findObject();
                    continue;
                }
                if (debug == null) break;
                System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  This cert matches the private key associated with label=" + label);
                System.out.println("                                                 Terminating the search.                                 ");
                break;
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  The following exception was thrown while trying to find the cert which matches the private key.");
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
                return null;
            }
        }
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  The cert which matches the private key WAS NOT found.  Returning null.");
                System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  METHOD EXIT");
            }
            return null;
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  The cert which matches the private key was found.");
            System.out.println("PKCS11KeyStore.java:  findThePrivateKeysCert():  METHOD EXIT");
        }
        return pkcs11obj;
    }

    public PrivateKey buildPrivateKey(Session session, PKCS11Object pobj) {
        if (pobj != null) {
            PrivateKeyInfo key = null;
            Integer keytype = (Integer)this.getValue(session, pobj, 256);
            if (keytype.equals(PKCS11Object.RSA)) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java: buildPrivateKey(): The private key is an RSA key");
                }
                try {
                    key = new RSAPrivateKey(session, pobj);
                    return key;
                }
                catch (Exception ike) {
                    try {
                        key = new RSAPrivateKey(session, pobj, (byte[])this.getValue(session, pobj, 258), (byte[])this.getValue(session, pobj, 257), (String)this.getValue(session, pobj, 3), (Boolean)this.getValue(session, pobj, 1), (Boolean)this.getValue(session, pobj, 259), (Boolean)this.getValue(session, pobj, 264), (Boolean)this.getValue(session, pobj, 261), (Boolean)this.getValue(session, pobj, 263), (Boolean)this.getValue(session, pobj, 354), (BigInteger)this.getValue(session, pobj, 288), (BigInteger)this.getValue(session, pobj, 290));
                        return key;
                    }
                    catch (InvalidKeyException ikee) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java: buildPrivateKey(): The following exception was thrown while trying to create an RSAPrivateKey object:");
                            System.out.println(ikee.toString());
                            ikee.printStackTrace();
                        }
                        return null;
                    }
                }
            }
            if (keytype.equals(PKCS11Object.DSA)) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java: buildPrivateKey(): The private key is a DSA key");
                }
                try {
                    key = new DSAPrivateKey(session, pobj);
                    return key;
                }
                catch (Exception ike) {
                    try {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                        }
                        key = new DSAPrivateKey(session, pobj, (String)this.getValue(session, pobj, 3), (byte[])this.getValue(session, pobj, 258), (byte[])this.getValue(session, pobj, 257), (Boolean)this.getValue(session, pobj, 1), (Boolean)this.getValue(session, pobj, 259), (Boolean)this.getValue(session, pobj, 354));
                        return key;
                    }
                    catch (InvalidKeyException ikee) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java: buildPrivateKey(): The following exception was thrown while trying to create a DSAPrivateKey object:");
                            System.out.println(ikee.toString());
                            ikee.printStackTrace();
                        }
                        return null;
                    }
                }
            }
            if (keytype.equals(PKCS11Object.ECDSA)) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java: buildPrivateKey(): The private key is an ECDSA key");
                }
                try {
                    key = new PKCS11ECPrivateKey(session, pobj, (byte[])this.getValue(session, pobj, 258), (byte[])this.getValue(session, pobj, 257), (String)this.getValue(session, pobj, 3), (byte[])this.getValue(session, pobj, 384));
                    return key;
                }
                catch (Exception ike) {
                    try {
                        byte[] SValue = (byte[])this.getValue(session, pobj, 17);
                        BigInteger S = new BigInteger(SValue);
                        key = new PKCS11ECPrivateKey(session, pobj, (byte[])this.getValue(session, pobj, 258), (byte[])this.getValue(session, pobj, 257), (String)this.getValue(session, pobj, 3), (byte[])this.getValue(session, pobj, 384), S);
                        return key;
                    }
                    catch (InvalidKeyException ikee) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java: buildPrivateKey(): The following exception was thrown while trying to create an ECDSAPrivateKey object:");
                            System.out.println(ikee.toString());
                            ikee.printStackTrace();
                        }
                        return null;
                    }
                }
            }
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  buildPrivateKey():  The type of the private key (RSA, DSA, ECDSA) could not be determined.  Returning null.");
            }
            return null;
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  buildPrivateKey():  The PKCS11Object passed in was null.  Returning null.");
        }
        return null;
    }

    public PrivateKey getPrivateKey(Session session, byte[] id, String label) {
        int[] attrTypeID = new int[]{1, 0, 258};
        int[] attrTypeLabel = new int[]{1, 0, 3};
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  getPrivateKey( ):  The label of the private key sought is:  " + label);
        }
        Object[] val = new Object[]{Boolean.TRUE, PKCS11Object.PRIVATE_KEY, label};
        session.findObjectsInit(attrTypeLabel, val);
        PKCS11Object pobj = session.findObject();
        session.findObjectsFinal();
        PrivateKey key = this.buildPrivateKey(session, pobj);
        return key;
    }

    private PKCS11Object findSigner(Session session, PKCS11Object pkcs11obj) {
        X509Certificate possibleSignerCert;
        int[] attrTypeID = new int[]{1, 0, 258};
        int[] attrTypeLabel = new int[]{1, 0, 3};
        int[] attrTypeSub = new int[]{1, 0, 257};
        int[] attrTypeIss = new int[]{1, 0, 129};
        byte[] subject = null;
        byte[] issuer = null;
        subject = (byte[])this.getValue(session, pkcs11obj, 257);
        issuer = (byte[])this.getValue(session, pkcs11obj, 129);
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  findSigner():  The cert for which the signer obj is sought has the following subject dn AND issuer dn:");
            System.out.println("   subject = " + new String(subject));
            System.out.println("   issuer  = " + new String(issuer));
        }
        if (this.bytesEquals(issuer, subject)) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  findSigner():   The cert for which the signer obj is sought is self signed.  Returning null.");
            }
            return null;
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  findSigner():  Searching for the signer cert whose subject DN is:");
            System.out.println("   subject  = " + new String(issuer));
        }
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X509", this.providerName);
        }
        catch (Exception ee) {
            if (debug != null) {
                ee.printStackTrace();
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineLoad");
                }
            }
            throw new RuntimeException("PKCS11KeyStore.java:  findSigner():  Failure while creating a CertificateFactory object.");
        }
        PKCS11CertObj cobj = new PKCS11CertObj(pkcs11obj);
        X509Certificate inputCert = null;
        try {
            inputCert = cobj.getX509Certificate(certFactory, session);
            if (inputCert == null) {
                throw new RuntimeException("PKCS11KeyStore.java:  findSigner():  Invalid certificate PKCS11CertObj");
            }
        }
        catch (Exception ex) {
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  findSigner():  The following exception was thrown while executing cobj.getX509Certificate(certFactory, session):");
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            throw new RuntimeException("PKCS11KeyStore.java:  findSigner():  Failure while executing cobj.getX509Certificate(certFactory, session)");
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  findSigner():  The cert passed in as an argument is:");
            System.out.println(inputCert.toString());
        }
        Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, issuer};
        session.findObjectsInit(attrTypeSub, attrVal);
        do {
            if ((pkcs11obj = session.findObject()) == null) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  findSigner():  No signer cert was found for the cert with issuer= " + new String(issuer) + ".  Returning null.");
                }
                session.findObjectsFinal();
                return null;
            }
            PKCS11CertObj cobj2 = new PKCS11CertObj(pkcs11obj);
            possibleSignerCert = null;
            try {
                possibleSignerCert = cobj2.getX509Certificate(certFactory, session);
                if (possibleSignerCert == null) {
                    throw new RuntimeException("PKCS11KeyStore.java:  findSigner():  Invalid certificate PKCS11CertObj");
                }
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  findSigner():  The following exception was thrown while executing cobj2.getX509Certificate(certFactory, session):");
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
                throw new RuntimeException("PKCS11KeyStore.java:  findSigner():  Failure while executing cobj2.getX509Certificate(certFactory, session)");
            }
        } while (!this.isSigner(possibleSignerCert, inputCert, this.providerName));
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  findSigner():  The signer cert found is:");
            System.out.println(possibleSignerCert.toString());
        }
        session.findObjectsFinal();
        return pkcs11obj;
    }

    private void deleteChain(Session session, byte[] id, String label) {
        block42: {
            CertificateFactory certFactory;
            PrivateKey privateKey;
            PKCS11Object pkcs11obj;
            byte[] issuer;
            byte[] subject;
            int[] attrTypeSub;
            int[] attrTypeLabel;
            block41: {
                int[] attrTypeID = new int[]{1, 0, 258};
                attrTypeLabel = new int[]{1, 0, 3};
                attrTypeSub = new int[]{1, 0, 257};
                int[] attrTypeIss = new int[]{1, 0, 129};
                subject = null;
                issuer = null;
                pkcs11obj = null;
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  METHOD ENTRY");
                    System.out.println("                                      label = " + label);
                }
                if ((privateKey = this.getPrivateKey(session, id, label)) == null) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  deleteChain():  NO PRIVATE KEY WAS FOUND FOR label = " + label);
                        System.out.println("                                      NO CHAIN WAS DELETED.  RETURNING.");
                        System.out.println("PKCS11KeyStore.java:  deleteChain():  METHOD EXIT");
                    }
                    return;
                }
                certFactory = null;
                try {
                    certFactory = CertificateFactory.getInstance("X509", this.providerName);
                }
                catch (Exception ee) {
                    if (debug == null) break block41;
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  The following exception was thrown attempting to obtain CertificateFactory object.");
                    System.out.println(ee.toString());
                    ee.printStackTrace();
                }
            }
            Object[] val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, label};
            session.findObjectsInit(attrTypeLabel, val);
            PKCS11CertObj cobj = null;
            X509Certificate myTempCert = null;
            pkcs11obj = session.findObject();
            while (pkcs11obj != null) {
                try {
                    PublicKey publicKey;
                    cobj = new PKCS11CertObj(pkcs11obj);
                    myTempCert = cobj.getX509Certificate(certFactory, session);
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  deleteChain():  subjectDN of the next cert is = " + myTempCert.getSubjectX500Principal().toString());
                    }
                    if (!this.doesPublicKeyMatchPrivateKey(publicKey = myTempCert.getPublicKey(), privateKey, this.providerName)) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  deleteChain():  This cert does not match the private key associated with label=" + label);
                            System.out.println("                                      Continue the search.                                                   ");
                        }
                        pkcs11obj = session.findObject();
                        continue;
                    }
                    if (debug == null) break;
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  This cert matches the private key associated with label=" + label);
                    System.out.println("                                      Terminating the search.                                         ");
                    break;
                }
                catch (Exception ex) {
                    if (debug == null) continue;
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  The following exception was thrown while trying to find the cert which matches the private key associated with label=" + label);
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
            }
            session.findObjectsFinal();
            if (pkcs11obj == null) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  The cert which matches the private key associated with label=" + label + " WAS NOT found.");
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  METHOD EXIT");
                }
                return;
            }
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  deleteChain():  The cert which matches the private key associated with label=" + label + " was found.");
                System.out.println("                                      Its subject and issuer are:");
                this.printCertDNs(pkcs11obj, certFactory);
            }
            subject = (byte[])this.getValue(session, pkcs11obj, 257);
            issuer = (byte[])this.getValue(session, pkcs11obj, 129);
            X509Certificate leafX509Certificate = null;
            try {
                PKCS11CertObj mytempcobj = new PKCS11CertObj(pkcs11obj);
                leafX509Certificate = mytempcobj.getX509Certificate(certFactory, session);
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  The following exception was throw while trying to get an X509Certificate for the leaf cert found.  Returning.");
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  METHOD EXIT");
                }
                return;
            }
            if (debug != null) {
                System.out.println("deleteChain():   Destroying the cert which matches the private key.");
            }
            session.destroyObject(pkcs11obj);
            if (this.bytesEquals(issuer, subject)) {
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():   The cert which matches the private key was self signed.  THERE IS NO MORE WORK TO DO.  Returning.");
                    System.out.println("PKCS11KeyStore.java:  deleteChain():   METHOD EXIT");
                }
                return;
            }
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  deleteChain():   Entering loop to find and delete any signer certs of the leaf cert.");
            }
            X509Certificate previousX509Certificate = leafX509Certificate;
            while (true) {
                Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, issuer};
                session.findObjectsInit(attrTypeSub, attrVal);
                pkcs11obj = session.findObject();
                if (pkcs11obj == null) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  deleteChain():  The next signer cert was not found for the certificate chain associated with label=" + label);
                    }
                    session.findObjectsFinal();
                    break block42;
                }
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  The next signer cert was found for the certificate chain associated with label=" + label);
                    System.out.println("                                      Its subject and issuer are:");
                    this.printCertDNs(pkcs11obj, certFactory);
                }
                X509Certificate signerX509Certificate = null;
                try {
                    PKCS11CertObj tempcobj = new PKCS11CertObj(pkcs11obj);
                    signerX509Certificate = tempcobj.getX509Certificate(certFactory, session);
                }
                catch (Exception ex) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  deleteChain():  The following exception was throw while trying to get an X509Certificate for the signer cert found.  Returning.");
                        System.out.println("PKCS11KeyStore.java:  deleteChain():  METHOD EXIT");
                    }
                    return;
                }
                if (!this.isSigner(signerX509Certificate, previousX509Certificate, this.providerName)) {
                    if (debug == null) continue;
                    System.out.println("PKCS11KeyStore.java:  deleteChain():  This wasn't the next signer cert in the chain.  Continue searching.");
                    continue;
                }
                previousX509Certificate = signerX509Certificate;
                subject = (byte[])this.getValue(session, pkcs11obj, 257);
                issuer = (byte[])this.getValue(session, pkcs11obj, 129);
                session.findObjectsFinal();
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():   Before deleting the signer cert found, determine whether is is the issuer of any other cert in the keystore.");
                    System.out.println("                                       If it is, then do not delete it.");
                }
                Session session2 = this.sessionManager.getOpSession();
                int[] attrTypes = new int[]{1, 0};
                Object[] values = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE};
                session2.findObjectsInit(attrTypes, values);
                PKCS11Object otherCert = session2.findObject();
                boolean wasOtherCertFound = false;
                while (otherCert != null) {
                    byte[] subjectOfOtherCert = (byte[])this.getValue(session, otherCert, 257);
                    byte[] issuerOfOtherCert = (byte[])this.getValue(session, otherCert, 129);
                    X509Certificate otherX509Certificate = null;
                    try {
                        PKCS11CertObj mytempcobj2 = new PKCS11CertObj(otherCert);
                        otherX509Certificate = mytempcobj2.getX509Certificate(certFactory, session);
                    }
                    catch (Exception ex) {
                        if (debug != null) {
                            System.out.println("PKCS11KeyStore.java:  deleteChain():  The following exception was throw while trying to get an X509Certificate for the other cert found.  Returning.");
                            System.out.println("PKCS11KeyStore.java:  deleteChain():   METHOD EXIT");
                        }
                        return;
                    }
                    if (this.bytesEquals(subject, subjectOfOtherCert) && this.bytesEquals(issuer, issuerOfOtherCert)) {
                        otherCert = session2.findObject();
                        continue;
                    }
                    if (this.isSigner(signerX509Certificate, otherX509Certificate, this.providerName)) {
                        wasOtherCertFound = true;
                        break;
                    }
                    otherCert = session2.findObject();
                }
                session2.findObjectsFinal();
                this.sessionManager.releaseSession(session2);
                if (!wasOtherCertFound) {
                    if (debug != null) {
                        System.out.println("PKCS11KeyStore.java:  deleteChain():   The signer cert WAS NOT the signer of another certificate.  IT IS BEING DELETED.");
                        System.out.println("                                       That signer cert was:");
                        System.out.println(signerX509Certificate.toString());
                    }
                    Session session3 = this.sessionManager.getOpSession();
                    session.destroyObject(pkcs11obj);
                    this.sessionManager.releaseSession(session3);
                    continue;
                }
                if (debug != null) {
                    System.out.println("PKCS11KeyStore.java:  deleteChain():   The signer cert WAS the signer of another certificate.  IT WILL NOT BE DELETED.");
                    System.out.println("                                       That signer cert was:");
                    System.out.println(signerX509Certificate.toString());
                }
                if (this.bytesEquals(subject, issuer)) break;
            }
            if (debug != null) {
                System.out.println("PKCS11KeyStore.java:  deleteChain():   The signer cert just considered for deletion was SELF SIGNED.");
                System.out.println("                                       That means that deleteChain() has reached the end of the chain and can EXIT.");
            }
        }
        if (debug != null) {
            System.out.println("PKCS11KeyStore.java:  deleteChain():   METHOD EXIT.");
        }
    }

    private void printCertDNs(PKCS11Object pkcs11obj, CertificateFactory certFactory) {
        try {
            Session session = this.sessionManager.getOpSession();
            PKCS11CertObj cobj = new PKCS11CertObj(pkcs11obj);
            X509Certificate myTempCert = cobj.getX509Certificate(certFactory, session);
            System.out.println("             subjectDN of the cert is  = " + myTempCert.getSubjectX500Principal().toString());
            System.out.println("             issuerDN  of the cert is  = " + myTempCert.getIssuerX500Principal().toString());
            this.sessionManager.releaseSession(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dumpKeyStoreEntries() {
        Enumeration myenum = this.entries.keys();
        System.out.println("\n\n\n=============================== dumpKeyStoreEntries() BELOW ===============================================");
        while (myenum.hasMoreElements()) {
            String alias = (String)myenum.nextElement();
            System.out.println("PKCS11KeyStore.java:  dumpKeyStoreEntries():  The next alias is:  " + alias);
            if (alias != null) {
                Object object = this.entries.get(alias);
                if (object instanceof PrivateKeyEntry) {
                    System.out.println("PKCS11KeyStore.java:  dumpKeyStoreEntries():  " + alias + " is is a PrivateKeyEntry");
                    continue;
                }
                if (object instanceof TrustedCertEntry) {
                    System.out.println("PKCS11KeyStore.java:  dumpKeyStoreEntries():  " + alias + " is a TrustedCertificateEntry");
                    continue;
                }
                if (object instanceof SecretKeyEntry) {
                    System.out.println("PKCS11KeyStore.java:  dumpKeyStoreEntries():  " + alias + " is a SecretKeyEntry");
                    continue;
                }
                System.out.println("PKCS11KeyStore.java:  dumpKeyStoreEntries():  " + alias + " IS AN UNKNOWN OBJECT OF THE CLASS " + object.getClass().getName());
                continue;
            }
            System.out.println("PKCS11KeyStore.java:  dumpKeyStoreEntries():  The next alias is NULL.  Should never happen.");
        }
        System.out.println("=============================== dumpKeyStoreEntries() ABOVE ===============================================\n\n\n");
    }

    class PKCS11CertObj {
        private PKCS11Object certObj;
        private X509Certificate cert;
        private byte[] keyID;
        private String label;

        PKCS11CertObj(PKCS11Object obj) {
            this.certObj = obj;
        }

        public X509Certificate getX509Certificate(CertificateFactory certFactory, Session session) throws IOException, CertificateException {
            if (this.cert == null) {
                byte[] bytearray = (byte[])PKCS11KeyStore.this.getValue(session, this.certObj, 17);
                if (bytearray == null) {
                    return null;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(bytearray);
                this.cert = (X509Certificate)certFactory.generateCertificate(bais);
            }
            return this.cert;
        }

        public byte[] getKeyIdentifier(Session session) {
            if (this.keyID == null) {
                Object[] result = PKCS11KeyStore.this.getValues(session, this.certObj, new int[]{258, 3});
                this.keyID = (byte[])result[0];
                this.label = (String)result[1];
            }
            return this.keyID;
        }

        public PKCS11Object getPKCS11Object() {
            return this.certObj;
        }

        public String getLabel(Session session) {
            if (this.label == null) {
                this.label = (String)PKCS11KeyStore.this.getValue(session, this.certObj, 3);
            }
            return this.label;
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;
        private byte[] keyID;
        private String label;
        Session session;

        TrustedCertEntry() {
        }

        static /* synthetic */ byte[] access$102(TrustedCertEntry x0, byte[] x1) {
            x0.keyID = x1;
            return x1;
        }
    }
}

