/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RSACipher
extends CipherSpi {
    private boolean decrypting = false;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private PKCS11Key hw_key_to_delete = null;
    private int mechanism;
    private Session session = null;
    private SessionManager sessionManager;
    private Provider provider = null;
    private Config config = null;
    private int paddingIndicator = 0;
    private BigInteger modulus;
    private byte[] data = null;
    private int dataUsed = 0;
    private int opmode;
    private Key key;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSACipher";

    public RSACipher(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            System.out.println("RSACipher.java:  CONSTRUCTOR:  Setting the mechanism to RSA_PKCS by default");
        }
        this.mechanism = 1;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && (mode.equals(" ") || mode.equals("ECB") || mode.equals("SSL"))) {
            return;
        }
        if (mode != null) {
            throw new NoSuchAlgorithmException("Mode: " + mode + " not implemented");
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            System.out.println("RSACipher.java:  engineSetPadding():  The padding scheme passed in is:  " + paddingScheme);
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetPadding", (Object)("." + paddingScheme + "."));
        }
        if ((paddingScheme.equalsIgnoreCase("PKCS1Padding") || paddingScheme.equalsIgnoreCase("PKCS")) && this.config != null && this.config.supportMechanism(1)) {
            this.paddingIndicator = 0;
            if (debug != null) {
                System.out.println("RSACipher.java:  engineSetPadding():  Padding scheme=PKCS1Padding.  Setting mechanism to RSA_PKCS");
            }
            this.mechanism = 1;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"PKCS");
            }
            return;
        }
        if ((paddingScheme.equals(" ") || paddingScheme.equalsIgnoreCase("NoPadding") || paddingScheme == null) && this.config != null && this.config.supportMechanism(3)) {
            this.paddingIndicator = 1;
            if (debug != null) {
                System.out.println("RSACipher.java:  engineSetPadding():  Padding scheme=NoPadding.  Setting mechanism to RSA_X_509");
            }
            this.mechanism = 3;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"RAW RSA");
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"No such padding.");
        }
        throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.modulus.toByteArray().length;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInit");
        }
        this.decrypting = opmode == 2 || opmode == 4;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        PKCS11Key p11key = this.translateToP11Key(key);
        String pszkey = key.getAlgorithm();
        if (!pszkey.equals("RSA")) {
            throw new InvalidKeyException("Not a RSA key.  Key algorithm is " + pszkey + ".");
        }
        this.data = new byte[(this.modulus.bitLength() + 7) / 8];
        this.dataUsed = 0;
        if (debug != null) {
            if (this.mechanism == 1) {
                System.out.println("RSACipher.java:  engineInit():  Creating a PKCS11Cipher object with mechanism = RSA_PKCS");
            } else if (this.mechanism == 3) {
                System.out.println("RSACipher.java:  engineInit():  Creating a PKCS11Cipher object with mechanism = RSA_X_509");
            }
        }
        PKCS11Cipher cp = null;
        cp = new PKCS11Cipher(this.mechanism);
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        } else {
            this.cancelOperation();
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            }
        }
        try {
            cp.engineInit(this.session, opmode, p11key.getObject(), null, (this.modulus.bitLength() + 7) / 8);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        this.opmode = opmode;
        this.key = key;
        this.cipher = cp;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    private void cancelOperation() {
        block13: {
            if (debug != null) {
                debug.entry(16384L, (Object)"RSACipher", "cancelOperation");
            }
            if (this.session == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"RSACipher", "cancelOperation", "session is null");
                }
                this.cipher = null;
                this.key = null;
                if (this.hw_key_to_delete != null) {
                    this.hw_key_to_delete.rm();
                    this.hw_key_to_delete = null;
                }
                return;
            }
            if (!this.session.hasObjects()) {
                if (debug != null) {
                    debug.text(16384L, (Object)"RSACipher", "cancelOperation", "session has no objects, close session handle = " + this.session.getID());
                }
                this.sessionManager.closeSession(this.session);
                this.session = null;
                this.cipher = null;
                this.key = null;
                if (this.hw_key_to_delete != null) {
                    this.hw_key_to_delete.rm();
                    this.hw_key_to_delete = null;
                }
                return;
            }
            int blocksize = this.engineGetBlockSize();
            if (blocksize == 0) {
                blocksize = 8;
            }
            byte[] data = new byte[blocksize];
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)"RSACipher", "cancelOperation", "call do final to clean up buffered data");
                }
                this.cipher.engineDoFinal(this.session, data, 0, blocksize);
            }
            catch (Exception ex) {
                if (debug == null) break block13;
                debug.exception(16384L, (Object)"RSACipher", "cancelOperation", (Throwable)ex);
            }
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        this.cipher = null;
        this.key = null;
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"RSACipher", "cancelOperation");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        this.dataUsed += inputLen;
        if (debug != null) {
            debug.text(16384L, (Object)"RSACipher", "engineUpdate1", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
        }
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        this.dataUsed += inputLen;
        if (debug != null) {
            debug.text(16384L, (Object)"RSACipher", "engineUpdate2", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] saved_rc;
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        if (inputLen != 0) {
            System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        }
        try {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineDoFinal1", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
            }
            if (this.dataUsed + inputLen == 0) {
                this.data = null;
            }
            saved_rc = this.cipher.engineDoFinal(this.session, this.data, 0, this.dataUsed + inputLen);
            this.dataUsed = 0;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return saved_rc;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int saved_rc;
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        if (inputLen != 0) {
            System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        }
        try {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineDoFinal2", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
            }
            if (this.dataUsed + inputLen == 0) {
                this.data = null;
            }
            saved_rc = this.cipher.engineDoFinal(this.session, this.data, 0, this.dataUsed + inputLen, output, outputOffset);
            this.dataUsed = 0;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return saved_rc;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PublicKey) {
            try {
                BigInteger n = ((RSAPublicKey)key).getModulus();
                return n.bitLength();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        if (key instanceof PrivateKey) {
            try {
                RSAPrivateKey priv = (RSAPrivateKey)key;
                BigInteger n = priv.getModulus();
                return n.bitLength();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        throw new InvalidKeyException("Must be either public key or private key.");
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] saved_rc;
        int len = 0;
        len = (this.modulus.bitLength() + 7) / 8;
        if (this.session == null) {
            if (this.key != null) {
                this.engineInit(this.opmode, this.key, null);
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            saved_rc = this.cipher.engineWrap(this.session, ((PKCS11Key)((Object)key)).getObject(), len);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return saved_rc;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        if (this.session == null) {
            if (this.key != null) {
                this.engineInit(this.opmode, this.key, null);
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            switch (wrappedKeyType) {
                case 3: {
                    attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm, this.provider);
                    break;
                }
                case 2: {
                    attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm, this.provider);
                    break;
                }
                case 1: {
                    attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm, this.provider);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return result;
    }

    private PKCS11Key translateToP11Key(Key key) throws InvalidKeyException {
        PKCS11Key p11key = null;
        if (key instanceof PublicKey) {
            if (this.decrypting) {
                throw new InvalidKeyException("Public Key cannot be used to decrypt.");
            }
            if (key instanceof PKCS11Key) {
                p11key = (PKCS11Key)((Object)key);
            } else if (key instanceof RSAPublicKey) {
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    this.hw_key_to_delete = p11key = (PKCS11Key)((Object)kf.translateKey(key));
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("not RSA key: " + key);
            }
            try {
                RSAPublicKey pub = (RSAPublicKey)key;
                this.modulus = pub.getModulus();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else if (key instanceof PrivateKey) {
            if (!this.decrypting) {
                throw new InvalidKeyException("Private key cannot be used to encrypt.");
            }
            if (key instanceof PKCS11Key) {
                p11key = (PKCS11Key)((Object)key);
            } else if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    this.hw_key_to_delete = p11key = (PKCS11Key)((Object)kf.translateKey(key));
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("not RSA key: " + key);
            }
            try {
                RSAPrivateKey priv = (RSAPrivateKey)key;
                this.modulus = priv.getModulus();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else {
            throw new InvalidKeyException("Must be either public key or private key.");
        }
        return p11key;
    }
}

