/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jit.JITHelpers;
import com.ibm.jvm.packed.ImportPacked;
import com.ibm.jvm.packed.reflect.PackedArray;
import com.ibm.jvm.packed.types.PackedByte;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;

@ImportPacked(value={"com/ibm/jvm/packed/types/PackedByte", "com/ibm/jvm/packed/types/PackedByte$Array"})
public abstract class PackedObject {
    public static final native <T extends PackedObject> T newPackedObject(Class<T> var0) throws InstantiationException;

    @CallerSensitive
    public static final <T extends PackedObject> T newNativePackedObject(Class<T> packedClass, long dataPtr) throws InstantiationException {
        if (dataPtr != 0L) {
            VM.ensureCalledFromBootstrapClass();
        }
        return PackedObject.newNativePackedObjectImpl(packedClass, dataPtr);
    }

    public static final <T extends PackedObject> T newNativePackedObject(Class<T> packedClass) throws InstantiationException {
        return PackedObject.newNativePackedObjectImpl(packedClass, 0L);
    }

    private static native <T extends PackedObject> T newNativePackedObjectImpl(Class<T> var0, long var1) throws InstantiationException;

    public final native void freeNativePackedObject();

    public static final boolean isPackedClass(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException();
        }
        JITHelpers h = PackedObject.getJITHelpers();
        if (h.is32Bit()) {
            int classDepthAndFlags = h.getClassDepthAndFlagsFromJ9Class32(h.getJ9ClassFromClass32(clazz));
            return (classDepthAndFlags >> VM.J9_JAVA_CLASS_RAM_SHAPE_SHIFT & VM.OBJECT_HEADER_SHAPE_MASK) == VM.OBJECT_HEADER_SHAPE_PACKED;
        }
        long classDepthAndFlags = h.getClassDepthAndFlagsFromJ9Class64(h.getJ9ClassFromClass64(clazz));
        return (classDepthAndFlags >> VM.J9_JAVA_CLASS_RAM_SHAPE_SHIFT & (long)VM.OBJECT_HEADER_SHAPE_MASK) == (long)VM.OBJECT_HEADER_SHAPE_PACKED;
    }

    public final boolean isPackedArray() {
        return PackedObject.isPackedArrayImpl(this.getClass());
    }

    public static final boolean isPackedArray(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException();
        }
        return PackedObject.isPackedArrayImpl(clazz);
    }

    private static final boolean isPackedArrayImpl(Class<?> clazz) {
        JITHelpers h = PackedObject.getJITHelpers();
        if (h.is32Bit()) {
            return 0 != (h.getClassFlagsFromJ9Class32(h.getJ9ClassFromClass32(clazz)) & VM.J9CLASS_PACKED_ARRAY);
        }
        return 0 != (h.getClassFlagsFromJ9Class64(h.getJ9ClassFromClass64(clazz)) & VM.J9CLASS_PACKED_ARRAY);
    }

    public final native boolean isNativePacked();

    public static final native boolean isMixedPacked(Class<? extends PackedObject> var0);

    public final boolean isMixedPacked() {
        return PackedObject.isMixedPacked(this.getClass());
    }

    public static final boolean isPackedSupportEnabled() {
        return VM.PACKED_SUPPORT_ENABLED;
    }

    public final long getPackedDataSize() {
        long result = PackedObject.getPackedDataSize(this.getClass());
        if (this.isPackedArray()) {
            result *= (long)PackedArray.getLength(this);
        }
        return result;
    }

    public static final native long getPackedDataSize(Class<? extends PackedObject> var0);

    public final native int writePackedDataToByteArray(long var1, byte[] var3, int var4, int var5);

    public final native int readPackedDataFromByteArray(long var1, byte[] var3, int var4, int var5);

    public static final <T extends PackedObject> void arraycopy(T src, int srcPos, T dest, int destPos, int length) throws IndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (null == src || null == dest) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (srcPos < 0) {
            throw new IndexOutOfBoundsException("srcPos: " + srcPos);
        }
        if (destPos < 0) {
            throw new IndexOutOfBoundsException("destPos: " + destPos);
        }
        if (!((PackedObject)src).isPackedArray()) {
            throw new IllegalArgumentException();
        }
        if (src.getClass() != dest.getClass()) {
            throw new IllegalArgumentException();
        }
        if (srcPos + length > PackedArray.getLength(src)) {
            throw new IndexOutOfBoundsException("srcPos + length > src.length");
        }
        if (destPos + length > PackedArray.getLength(dest)) {
            throw new IndexOutOfBoundsException("destPos + length > dest.length");
        }
        if (0 == length) {
            return;
        }
        if (src == dest && srcPos == destPos) {
            return;
        }
        Object offsetSrc = ((PackedObject)src).unsafeCast(srcPos, src.getClass(), length);
        Object offsetDest = ((PackedObject)dest).unsafeCast(destPos, dest.getClass(), length);
        ((PackedObject)offsetDest).copyFrom((PackedObject)offsetSrc);
    }

    public final native void copyFrom(PackedObject var1);

    public final boolean isIdentical(Object obj) {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            return this == obj;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        PackedObject packedObj = (PackedObject)obj;
        if (this.getPackedTarget() == packedObj.getPackedTarget() && this.getPackedOffset() == packedObj.getPackedOffset()) {
            if (this.isPackedArray()) {
                return PackedArray.getLength(this) == PackedArray.getLength(packedObj);
            }
            return true;
        }
        return false;
    }

    private final <T extends PackedObject> T getPackedTarget() {
        if (PackedObject.isPackedArrayImpl(this.getClass())) {
            if (PackedObject.isContiguousIndexableImpl(this)) {
                return PackedObject.getPackedIndexableContiguousTargetImpl(this);
            }
            return PackedObject.getPackedIndexableDiscontiguousTargetImpl(this);
        }
        return PackedObject.getPackedTargetImpl(this);
    }

    private final long getPackedOffset() {
        JITHelpers h = PackedObject.getJITHelpers();
        if (PackedObject.isPackedArrayImpl(this.getClass())) {
            if (PackedObject.isContiguousIndexableImpl(this)) {
                if (h.is32Bit()) {
                    return PackedObject.getPackedIndexableContiguousOffset32Impl(this);
                }
                return PackedObject.getPackedIndexableContiguousOffset64Impl(this);
            }
            if (h.is32Bit()) {
                return PackedObject.getPackedIndexableDiscontiguousOffset32Impl(this);
            }
            return PackedObject.getPackedIndexableDiscontiguousOffset64Impl(this);
        }
        if (h.is32Bit()) {
            return PackedObject.getPackedOffset32Impl(this);
        }
        return PackedObject.getPackedOffset64Impl(this);
    }

    protected Object clone() throws CloneNotSupportedException {
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (!Cloneable.class.isInstance(this)) {
            throw new CloneNotSupportedException(this.getClass().getName());
        }
        Object cloneObject = null;
        if (this.isPackedArray()) {
            cloneObject = this.isNativePacked() ? PackedArray.newNativeArray(this.getClass(), PackedArray.getLength(this), 0L) : PackedArray.newArray(this.getClass(), PackedArray.getLength(this));
        } else {
            try {
                cloneObject = this.isNativePacked() ? PackedObject.newNativePackedObject(this.getClass(), 0L) : PackedObject.newPackedObject(this.getClass());
            }
            catch (InstantiationException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        ((PackedObject)cloneObject).copyFrom(this);
        return cloneObject;
    }

    public boolean equals(Object obj) {
        return this.isIdentical(obj);
    }

    public String toString() {
        Class<? extends Object> cls = this.getClass();
        if (this.isNativePacked()) {
            return cls.getName() + "[native]";
        }
        return cls.getName() + "[heap]";
    }

    protected final void finalize() {
    }

    private final native <T extends PackedObject> T unsafeCastHelperImpl(boolean var1, int var2, boolean var3, Class<T> var4, int var5) throws ArrayIndexOutOfBoundsException, ClassCastException, IllegalArgumentException, NegativeArraySizeException, NullPointerException;

    public final <T extends PackedObject> T unsafeCast(Class<T> castArrayType, int castArrayLength) throws ClassCastException, IllegalArgumentException, NegativeArraySizeException, NullPointerException {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        return this.unsafeCastHelperImpl(false, 0, true, castArrayType, castArrayLength);
    }

    public final <T extends PackedObject> T unsafeCast(int startIdx, Class<T> castArrayType, int castArrayLength) throws ArrayIndexOutOfBoundsException, ClassCastException, IllegalArgumentException, NegativeArraySizeException, NullPointerException {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        return this.unsafeCastHelperImpl(true, startIdx, true, castArrayType, castArrayLength);
    }

    public final <T extends PackedObject> T unsafeCast(Class<T> castType) throws ClassCastException, IllegalArgumentException, NullPointerException {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        return this.unsafeCastHelperImpl(false, 0, false, castType, 0);
    }

    public final <T extends PackedObject> T unsafeCast(int startIdx, Class<T> castType) throws ArrayIndexOutOfBoundsException, ClassCastException, IllegalArgumentException, NullPointerException {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        return this.unsafeCastHelperImpl(true, startIdx, false, castType, 0);
    }

    protected final void writeObject(ObjectOutputStream out) throws IOException {
    }

    protected final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    protected final void readObjectNoData() throws ObjectStreamException {
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return this;
    }

    protected final Object readResolve() throws ObjectStreamException {
        return this;
    }

    protected final void writeExternal(ObjectOutput out) throws IOException {
    }

    protected final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public final ByteBuffer asByteBuffer() {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (!this.isNativePacked()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED6"));
        }
        long address = this.getPackedOffset();
        long length = this.getPackedDataSize();
        ByteBuffer buffer = PackedObject.bufferFromPackedImpl(address, length);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static final PackedByte.Array fromByteBuffer(ByteBuffer buffer) {
        if (!VM.PACKED_SUPPORT_ENABLED) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (null == buffer) {
            throw new NullPointerException();
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED7"));
        }
        return PackedObject.packedFromBufferImpl(buffer, PackedByte.Array.class);
    }

    private static final native ByteBuffer bufferFromPackedImpl(long var0, long var2);

    private static final native PackedByte.Array packedFromBufferImpl(ByteBuffer var0, Class<PackedByte.Array> var1);

    private static final JITHelpers getJITHelpers() {
        return JITHelpersGetter.myJITHelpers;
    }

    private static final Unsafe getUnsafe() {
        return JITHelpersGetter.myUnsafe;
    }

    private static final int getPackedOffset32Impl(PackedObject obj) {
        return PackedObject.getUnsafe().getInt(obj, VM.J9PACKED_OFFSET_OFFSET);
    }

    private static final long getPackedOffset64Impl(PackedObject obj) {
        return PackedObject.getUnsafe().getLong(obj, VM.J9PACKED_OFFSET_OFFSET);
    }

    private static final <T extends PackedObject> T getPackedTargetImpl(PackedObject obj) {
        return (T)((PackedObject)PackedObject.getUnsafe().getObject(obj, VM.J9PACKED_TARGET_OFFSET));
    }

    private static final native boolean isContiguousIndexableImpl(PackedObject var0);

    private static final int getPackedIndexableContiguousOffset32Impl(PackedObject obj) {
        return PackedObject.getUnsafe().getInt(obj, VM.J9PACKEDINDEXABLE_CTG_OFFSET_OFFSET);
    }

    private static final long getPackedIndexableContiguousOffset64Impl(PackedObject obj) {
        return PackedObject.getUnsafe().getLong(obj, VM.J9PACKEDINDEXABLE_CTG_OFFSET_OFFSET);
    }

    private static final <T extends PackedObject> T getPackedIndexableContiguousTargetImpl(PackedObject obj) {
        return (T)((PackedObject)PackedObject.getUnsafe().getObject(obj, VM.J9PACKEDINDEXABLE_CTG_TARGET_OFFSET));
    }

    private static final int getPackedIndexableDiscontiguousOffset32Impl(PackedObject obj) {
        return PackedObject.getUnsafe().getInt(obj, VM.J9PACKEDINDEXABLE_DCTG_OFFSET_OFFSET);
    }

    private static final long getPackedIndexableDiscontiguousOffset64Impl(PackedObject obj) {
        return PackedObject.getUnsafe().getLong(obj, VM.J9PACKEDINDEXABLE_DCTG_OFFSET_OFFSET);
    }

    private static final <T extends PackedObject> T getPackedIndexableDiscontiguousTargetImpl(PackedObject obj) {
        return (T)((PackedObject)PackedObject.getUnsafe().getObject(obj, VM.J9PACKEDINDEXABLE_DCTG_TARGET_OFFSET));
    }

    private static final class JITHelpersGetter {
        public static final JITHelpers myJITHelpers = JITHelpers.getHelpers();
        public static final Unsafe myUnsafe = Unsafe.getUnsafe();

        private JITHelpersGetter() {
        }
    }
}

