/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.CpuLoadCalculationConstants;
import com.ibm.lang.management.MemoryUsage;
import com.ibm.lang.management.MemoryUsageRetrievalException;
import com.ibm.lang.management.OperatingSystemMXBeanImpl;
import com.ibm.lang.management.ProcessorUsage;
import com.ibm.lang.management.ProcessorUsageRetrievalException;
import com.ibm.oti.util.Msg;

public class ExtendedOperatingSystem
extends OperatingSystemMXBeanImpl
implements CpuLoadCalculationConstants {
    private static ExtendedOperatingSystem instance = new ExtendedOperatingSystem();
    private static MemoryUsage memObj = new MemoryUsage();
    private static long oldTime = -1L;
    private static long oldCpuTime = -1L;
    private static long interimTime = -1L;
    private static long interimCpuTime = -1L;
    private static long latestTime = -1L;
    private static long latestCpuTime = -1L;

    private ExtendedOperatingSystem() {
    }

    public static ExtendedOperatingSystem getInstance() {
        return instance;
    }

    public MemoryUsage retrieveMemoryUsage() throws MemoryUsageRetrievalException {
        MemoryUsage memoryUsageObj = new MemoryUsage();
        memoryUsageObj = this.getMemoryUsageImpl(memoryUsageObj);
        return memoryUsageObj;
    }

    public MemoryUsage retrieveMemoryUsage(MemoryUsage memoryUsageObj) throws NullPointerException, MemoryUsageRetrievalException {
        if (null == memoryUsageObj) {
            throw new NullPointerException();
        }
        memoryUsageObj = this.getMemoryUsageImpl(memoryUsageObj);
        return memoryUsageObj;
    }

    private native MemoryUsage getMemoryUsageImpl(MemoryUsage var1);

    public long getTotalSwapSpaceSize() {
        try {
            memObj = this.retrieveMemoryUsage(memObj);
        }
        catch (MemoryUsageRetrievalException e) {
            return -1L;
        }
        return memObj.getSwapTotal();
    }

    public long getFreeSwapSpaceSize() {
        try {
            memObj = this.retrieveMemoryUsage(memObj);
        }
        catch (MemoryUsageRetrievalException e) {
            return -1L;
        }
        return memObj.getSwapFree();
    }

    public synchronized double getProcessCpuLoad() {
        double processCpuLoad = -1.0;
        latestTime = System.nanoTime();
        latestCpuTime = this.getProcessCpuTimeByNS();
        if (-1L == oldTime) {
            oldTime = interimTime = latestTime;
            oldCpuTime = interimCpuTime = latestCpuTime;
            return -1.0;
        }
        if (latestTime - interimTime >= 10000000L) {
            processCpuLoad = this.calculateProcessCpuLoad(latestTime, latestCpuTime, interimTime, interimCpuTime);
            if (processCpuLoad >= 0.0) {
                oldTime = interimTime;
                oldCpuTime = interimCpuTime;
                interimTime = latestTime;
                interimCpuTime = latestCpuTime;
                return processCpuLoad;
            }
            interimTime = latestTime;
            interimCpuTime = latestCpuTime;
        }
        if (latestTime - oldTime >= 10000000L && (processCpuLoad = this.calculateProcessCpuLoad(latestTime, latestCpuTime, oldTime, oldCpuTime)) < 0.0) {
            oldTime = latestTime;
            oldCpuTime = latestCpuTime;
        }
        return processCpuLoad;
    }

    private double calculateProcessCpuLoad(long endTs, long endCpuTime, long startTs, long startCpuTime) {
        double timestampDelta = endTs - startTs;
        double processTimeDelta = endCpuTime - startCpuTime;
        if (timestampDelta <= 0.0 || processTimeDelta < 0.0) {
            return -1.0;
        }
        return Math.min(processTimeDelta / ((double)this.getOnlineProcessorsImpl() * timestampDelta), 1.0);
    }

    public ProcessorUsage retrieveTotalProcessorUsage() throws ProcessorUsageRetrievalException {
        ProcessorUsage procUsageObj = new ProcessorUsage();
        procUsageObj = this.getTotalProcessorUsageImpl(procUsageObj);
        return procUsageObj;
    }

    public ProcessorUsage retrieveTotalProcessorUsage(ProcessorUsage procUsageObj) throws NullPointerException, ProcessorUsageRetrievalException {
        if (null == procUsageObj) {
            throw new NullPointerException();
        }
        procUsageObj = this.getTotalProcessorUsageImpl(procUsageObj);
        return procUsageObj;
    }

    public ProcessorUsage[] retrieveProcessorUsage() throws ProcessorUsageRetrievalException {
        return this.getProcessorUsageImpl(null);
    }

    public ProcessorUsage[] retrieveProcessorUsage(ProcessorUsage[] procUsageArr) throws NullPointerException, ProcessorUsageRetrievalException, IllegalArgumentException {
        if (null == procUsageArr) {
            throw new NullPointerException(Msg.getString("K056B"));
        }
        for (ProcessorUsage p : procUsageArr) {
            if (null != p) continue;
            throw new NullPointerException(Msg.getString("K056C"));
        }
        procUsageArr = this.getProcessorUsageImpl(procUsageArr);
        return procUsageArr;
    }

    private native ProcessorUsage getTotalProcessorUsageImpl(ProcessorUsage var1);

    private native ProcessorUsage[] getProcessorUsageImpl(ProcessorUsage[] var1);

    private native int getOnlineProcessorsImpl();
}

