/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class ProcessorUsage {
    private long user;
    private long system;
    private long idle;
    private long wait;
    private long busy;
    private int id;
    private int online;
    private long timestamp;
    private String TOSTRING_VALUE = null;

    public ProcessorUsage() {
    }

    private ProcessorUsage(long user, long system, long idle, long wait, long busy, int id, int online, long timestamp) throws IllegalArgumentException {
        if (user < 0L && user != -1L || system < 0L && system != -1L || idle < 0L && idle != -1L || wait < 0L && wait != -1L || busy < 0L && busy != -1L || id < 0 && id != -1 || online < 0 && online != -1 || online != 0 && online != 1 || timestamp < 0L || user >= 0L && system >= 0L && wait >= 0L && busy >= 0L && busy < user + system + wait) {
            throw new IllegalArgumentException();
        }
        this.user = user;
        this.system = system;
        this.idle = idle;
        this.wait = wait;
        this.busy = busy;
        this.id = id;
        this.online = online;
        this.timestamp = timestamp;
    }

    public long getUser() {
        return this.user;
    }

    public long getSystem() {
        return this.system;
    }

    public long getIdle() {
        return this.idle;
    }

    public long getWait() {
        return this.wait;
    }

    public long getBusy() {
        return this.busy;
    }

    public int getId() {
        return this.id;
    }

    public int getOnline() {
        return this.online;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void updateValues(long user, long system, long idle, long wait, long busy, int id, int online, long timestamp) {
        this.user = user;
        this.system = system;
        this.idle = idle;
        this.wait = wait;
        this.busy = busy;
        this.id = id;
        this.online = online;
        this.timestamp = timestamp;
    }

    public static ProcessorUsage from(CompositeData cd) {
        ProcessorUsage result = null;
        if (null != cd) {
            long timestamp;
            int online;
            int id;
            long busy;
            long wait;
            long idle;
            long system;
            long user;
            if (!ManagementUtils.getProcessorUsageCompositeType().isValue(cd)) {
                throw new IllegalArgumentException("CompositeData is not of the expected type.");
            }
            try {
                user = (Long)cd.get("user");
                system = (Long)cd.get("system");
                idle = (Long)cd.get("idle");
                wait = (Long)cd.get("wait");
                busy = (Long)cd.get("busy");
                id = (Integer)cd.get("id");
                online = (Integer)cd.get("online");
                timestamp = (Long)cd.get("timestamp");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException("CompositeData object does not contain expected key.");
            }
            result = new ProcessorUsage(user, system, idle, wait, busy, id, online, timestamp);
        }
        return result;
    }

    public String toString() {
        if (null == this.TOSTRING_VALUE) {
            StringBuilder sb = new StringBuilder();
            sb.append("user = ");
            sb.append(this.user);
            sb.append("system = ");
            sb.append(this.system);
            sb.append("idle = ");
            sb.append(this.idle);
            sb.append("wait = ");
            sb.append(this.wait);
            sb.append("busy = ");
            sb.append(this.busy);
            sb.append("id = ");
            sb.append(this.id);
            sb.append("online = ");
            sb.append(this.online);
            sb.append("timestamp = ");
            sb.append(this.timestamp);
        }
        return this.TOSTRING_VALUE;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof ProcessorUsage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ProcessorUsage pu = (ProcessorUsage)obj;
        if (pu.getUser() != this.getUser()) {
            return false;
        }
        if (pu.getSystem() != this.getSystem()) {
            return false;
        }
        if (pu.getIdle() != this.getIdle()) {
            return false;
        }
        if (pu.getWait() != this.getWait()) {
            return false;
        }
        if (pu.getBusy() != this.getBusy()) {
            return false;
        }
        if (pu.getId() != this.getId()) {
            return false;
        }
        if (pu.getOnline() != this.getOnline()) {
            return false;
        }
        return pu.getTimestamp() == this.getTimestamp();
    }

    public int hashCode() {
        return new String(Long.toString(this.getUser()) + Long.toString(this.getSystem()) + Long.toString(this.getIdle()) + Long.toString(this.getWait()) + Long.toString(this.getBusy()) + Integer.toString(this.getId()) + Integer.toString(this.getOnline()) + Long.toString(this.getTimestamp())).hashCode();
    }
}

