/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.AttachmentConnection;
import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.javaSE.Reply;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;

class Attachment
extends Thread {
    private Exception lastError;
    private OutputStream responseStream;
    private Socket attacherSocket;
    private final int portNumber;
    private InputStream commandStream;
    private String attachError;
    private final AttachHandler handler;
    private final String key;

    Attachment(AttachHandler attachHandler, Reply rc) {
        this.setName("Attachment " + rc.getPortNumber());
        this.portNumber = rc.getPortNumber();
        this.key = rc.getKey();
        this.handler = attachHandler;
        this.setDaemon(true);
    }

    boolean connectToAttacher(int portNum) {
        try {
            IPC.logMessage("connectToAttacher portNum=", portNum);
            InetAddress localHost = InetAddress.getLocalHost();
            this.attacherSocket = new Socket(localHost, portNum);
            IPC.logMessage("connectToAttacher localPort=", this.attacherSocket.getLocalPort(), " remotePort=", Integer.toString(this.attacherSocket.getPort()));
            this.responseStream = this.attacherSocket.getOutputStream();
            this.commandStream = this.attacherSocket.getInputStream();
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_CONNECTED " + this.key + ' ');
        }
        catch (IOException e) {
            IPC.logMessage("connectToAttacher exception " + e.getMessage() + " " + e.toString());
            try {
                if (null != this.responseStream) {
                    this.responseStream.close();
                }
                if (null != this.commandStream) {
                    this.commandStream.close();
                }
                if (null != this.attacherSocket) {
                    this.attacherSocket.close();
                }
            }
            catch (IOException e1) {
                return false;
            }
            return false;
        }
        catch (Exception otherException) {
            IPC.logMessage("connectToAttacher exception ", otherException.toString());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        boolean terminate = false;
        IPC.logMessage("Attachment run");
        this.connectToAttacher(this.getPortNumber());
        while (!terminate && !this.isInterrupted()) {
            terminate = this.doCommand(this.commandStream, this.responseStream);
        }
        try {
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_DETACHED");
            if (null != this.responseStream) {
                this.responseStream.close();
                this.responseStream = null;
            }
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
        }
        catch (IOException e) {
            this.lastError = e;
        }
        if (null != this.handler) {
            this.handler.removeAttachment(this);
        }
    }

    boolean doCommand(InputStream cmdStream, OutputStream respStream) {
        try {
            String cmd = AttachmentConnection.streamReceiveString(cmdStream);
            IPC.logMessage("doCommand ", cmd);
            if (null == cmd) {
                return true;
            }
            if (cmd.startsWith("ATTACH_DETACH")) {
                return true;
            }
            if (cmd.startsWith("ATTACH_LOADAGENT")) {
                if (this.parseLoadAgent(cmd)) {
                    AttachmentConnection.streamSend(respStream, "ATTACH_ACK");
                } else {
                    AttachmentConnection.streamSend(respStream, "ATTACH_ERR " + this.attachError);
                }
            } else if (cmd.startsWith("ATTACH_GETSYSTEMPROPERTIES")) {
                this.replyWithProperties(System.getProperties());
            } else if (cmd.startsWith("ATTACH_GETAGENTPROPERTIES")) {
                this.replyWithProperties(AttachHandler.getAgentProperties());
            } else {
                AttachmentConnection.streamSend(respStream, "ATTACH_ERR command invalid: " + cmd);
            }
        }
        catch (IOException e) {
            IPC.logMessage("doCommand IOException ", e.toString());
            return true;
        }
        catch (Throwable e) {
            IPC.logMessage("doCommand exception ", e.toString());
            try {
                AttachmentConnection.streamSend(respStream, "ATTACH_ERR unexpected exception or error: " + e.toString());
            }
            catch (IOException e1) {
                IPC.logMessage("IOException sending error response" + e1.toString());
            }
            return true;
        }
        return false;
    }

    private void replyWithProperties(Properties props) throws IOException {
        ByteArrayOutputStream propsBuffer = new ByteArrayOutputStream();
        props.store(propsBuffer, "");
        this.responseStream.write(propsBuffer.toByteArray());
        this.responseStream.write(0);
    }

    synchronized void teardown() {
        try {
            if (null != this.responseStream) {
                this.responseStream.close();
            }
            if (null != this.attacherSocket) {
                this.attacherSocket.close();
            }
            if (null != this.commandStream) {
                this.commandStream.close();
            }
        }
        catch (IOException e) {
            this.lastError = e;
        }
    }

    private boolean parseLoadAgent(String cmd) {
        int openParenIndex = cmd.indexOf(40);
        int closeParenIndex = cmd.lastIndexOf(41);
        int commaIndex = cmd.indexOf(44);
        String optionString = "";
        boolean decorate = true;
        this.attachError = null;
        if (cmd.startsWith("ATTACH_LOADAGENTPATH")) {
            decorate = false;
        }
        if (openParenIndex < 0 || closeParenIndex < 0) {
            this.attachError = "syntax error";
            return false;
        }
        int agentNameEnd = commaIndex < 0 ? closeParenIndex : commaIndex;
        String agentName = cmd.substring(openParenIndex + 1, agentNameEnd);
        if (agentName.length() < 1) {
            this.attachError = "invalid agent name";
            return false;
        }
        if (commaIndex > 0) {
            optionString = cmd.substring(commaIndex + 1, closeParenIndex);
        }
        this.attachError = this.loadAgentLibrary(agentName, optionString, decorate);
        return this.attachError == null;
    }

    String loadAgentLibrary(String agentLibrary, String options, boolean decorate) {
        IPC.logMessage("loadAgentLibrary " + agentLibrary + ':' + options + " decorate=" + decorate);
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        int status = this.loadAgentLibraryImpl(loader, agentLibrary, options, decorate);
        if (0 != status) {
            if (-1 == status) {
                return "AgentLoadException " + agentLibrary + ':' + options;
            }
            return "AgentInitializationException" + status;
        }
        return null;
    }

    private native int loadAgentLibraryImpl(ClassLoader var1, String var2, String var3, boolean var4);

    private int getPortNumber() {
        return this.portNumber;
    }
}

