/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.spi;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.VirtualMachine;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.AttachProviderImpl;
import com.ibm.tools.attach.javaSE.Permissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AttachProvider {
    private static ArrayList<AttachProvider> providers;

    protected AttachProvider() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CREATE_ATTACH_PROVIDER);
        }
    }

    public abstract String name();

    public abstract String type();

    public abstract VirtualMachine attachVirtualMachine(String var1) throws AttachNotSupportedException, IOException;

    public abstract VirtualMachine attachVirtualMachine(VirtualMachineDescriptor var1) throws AttachNotSupportedException, IOException;

    public abstract List<VirtualMachineDescriptor> listVirtualMachines();

    public static synchronized List<AttachProvider> providers() {
        if (providers != null) {
            return providers;
        }
        providers = new ArrayList();
        String providersProperty = System.getProperty("com.ibm.attach.providers");
        if (null == providersProperty || 0 == providersProperty.length()) {
            providers.add(new AttachProviderImpl());
            return providers;
        }
        StringTokenizer providerClasses = new StringTokenizer(providersProperty, ":;");
        while (providerClasses.hasMoreTokens()) {
            ReflectiveOperationException exception = null;
            String providerClassName = providerClasses.nextToken();
            try {
                Class<?> co = Class.forName(providerClassName);
                providers.add((AttachProvider)co.newInstance());
            }
            catch (ClassNotFoundException e) {
                exception = e;
            }
            catch (IllegalAccessException e) {
                exception = e;
            }
            catch (InstantiationException e) {
                exception = e;
            }
            if (exception == null) continue;
            providers = null;
            String msg = Msg.getString("K0540", providerClassName, exception.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
        return providers;
    }
}

