/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.packed.PackedObject;
import com.ibm.jvm.packed.reflect.PackedUnsafe;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.scope.ClassScope;
import sun.reflect.misc.ReflectUtil;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final long serialVersionUID = 3206093459760846163L;
    private static ProtectionDomain AllPermissionsPD;
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int MEMBER_INVALID_TYPE = -1;
    private static final Class[] EmptyParameters;
    private long vmRef;
    private Object classLoader;
    private ProtectionDomain protectionDomain;
    private String classNameString;
    private volatile AnnotationType annotationType;
    transient ClassValue.ClassValueMap classValueMap;
    J9VMInternals.ClassInitializationLock initializationLock;
    private MethodHandle classCastHandle;
    private transient EnumVars enumVars;
    private static long enumVarsOffset;
    private transient ClassRepositoryHolder classRepoHolder;
    private transient AnnotationCache annotationCache;
    private static long annotationCacheOffset;
    static Unsafe unsafe;
    private static Method copyMethod;
    private static Method copyField;
    private static Method copyConstructor;
    private static Field methodParameterTypesField;
    private static Field constructorParameterTypesField;
    private static final Object[] NoArgs;
    private static final CacheKey PublicKey;
    private static final CacheKey DeclaredKey;
    static ReferenceQueue queue;

    static final Unsafe getUnsafe() {
        return unsafe;
    }

    private Class() {
    }

    private void checkMemberAccess(SecurityManager security, ClassLoader callerClassLoader, int type) {
        if (callerClassLoader != ClassLoader.bootstrapClassLoader) {
            ClassLoader loader;
            if (type != -1) {
                security.checkMemberAccess(this, type);
            }
            if (ReflectUtil.needsPackageAccessCheck(callerClassLoader, loader = this.getClassLoaderImpl())) {
                if (Proxy.isProxyClass(this)) {
                    ReflectUtil.checkProxyPackageAccess(callerClassLoader, this.getInterfaces());
                } else {
                    String packageName = this.getPackageName();
                    if (packageName != "") {
                        security.checkPackageAccess(packageName);
                    }
                }
            }
        }
    }

    private void checkNonSunProxyMemberAccess(SecurityManager security, ClassLoader callerClassLoader, int type) {
        if (callerClassLoader != ClassLoader.bootstrapClassLoader) {
            if (type != -1) {
                security.checkMemberAccess(this, type);
            }
            String packageName = this.getPackageName();
            ClassLoader loader = this.getClassLoaderImpl();
            if (!(Proxy.isProxyClass(this) && packageName.equals("com.sun.proxy") || packageName == "" || !ReflectUtil.needsPackageAccessCheck(callerClassLoader, loader))) {
                security.checkPackageAccess(packageName);
            }
        }
    }

    private static void forNameAccessCheck(final SecurityManager sm, final Class<?> callerClass, final Class<?> foundClass) {
        ProtectionDomain pd;
        if (null != callerClass && null != (pd = callerClass.getPDImpl())) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    foundClass.checkMemberAccess(sm, callerClass.getClassLoaderImpl(), -1);
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{pd}));
        }
    }

    @CallerSensitive
    public static Class<?> forName(String className) throws ClassNotFoundException {
        SecurityManager sm = null;
        if (J9VMInternals.initialized) {
            sm = System.getSecurityManager();
        }
        if (null == sm) {
            return Class.forNameImpl(className, true, ClassLoader.callerClassLoader());
        }
        Class caller = Class.getStackClass(1);
        ClassLoader callerClassLoader = null;
        if (null != caller) {
            callerClassLoader = caller.getClassLoaderImpl();
        }
        Class c = Class.forNameImpl(className, false, callerClassLoader);
        Class.forNameAccessCheck(sm, caller, c);
        J9VMInternals.initialize(c);
        return c;
    }

    AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    void setAnnotationType(AnnotationType t) {
        this.annotationType = t;
    }

    @CallerSensitive
    public static Class<?> forName(String className, boolean initializeBoolean, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader callerClassLoader;
        SecurityManager sm = null;
        if (J9VMInternals.initialized) {
            sm = System.getSecurityManager();
        }
        if (null == sm) {
            return Class.forNameImpl(className, initializeBoolean, classLoader);
        }
        Class caller = Class.getStackClass(1);
        if (null == classLoader && null != caller && (callerClassLoader = caller.getClassLoaderImpl()) != ClassLoader.bootstrapClassLoader) {
            sm.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        Class c = Class.forNameImpl(className, false, classLoader);
        Class.forNameAccessCheck(sm, caller, c);
        if (initializeBoolean) {
            J9VMInternals.initialize(c);
        }
        return c;
    }

    private static native Class forNameImpl(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    @CallerSensitive
    public Class<?>[] getClasses() {
        Object[] classes;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkNonSunProxyMemberAccess(security, callerClassLoader, 0);
        }
        Vector<Object> publicClasses = new Vector<Object>();
        for (Class<T> current = this; current != null; current = current.getSuperclass()) {
            classes = current.getDeclaredClassesImpl();
            for (int i = 0; i < classes.length; ++i) {
                if (!Modifier.isPublic(((Class)classes[i]).getModifiers())) continue;
                publicClasses.addElement(classes[i]);
            }
        }
        classes = new Class[publicClasses.size()];
        publicClasses.copyInto(classes);
        return classes;
    }

    @CallerSensitive
    public ClassLoader getClassLoader() {
        ClassLoader loader = this.getClassLoaderImpl();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (loader == ClassLoader.bootstrapClassLoader) {
                return null;
            }
            ClassLoader callersClassLoader = ClassLoader.callerClassLoader();
            if (callersClassLoader != null && callersClassLoader != loader && !callersClassLoader.isAncestorOf(loader)) {
                security.checkPermission(RuntimePermission.permissionToGetClassLoader);
            }
        }
        if (loader == ClassLoader.bootstrapClassLoader) {
            return null;
        }
        return loader;
    }

    ClassLoader getClassLoader0() {
        ClassLoader loader = this.getClassLoaderImpl();
        return loader;
    }

    ClassLoader getClassLoaderImpl() {
        return J9VMInternals.getClassLoader(this);
    }

    public native Class<?> getComponentType();

    private void throwNoSuchMethodException(String name, Class[] types) throws NoSuchMethodException {
        StringBuffer error = new StringBuffer();
        error.append(this.getName()).append('.').append(name).append('(');
        if (types.length > 0) {
            error.append(types[0] == null ? null : types[0].getName());
            for (int i = 1; i < types.length; ++i) {
                error.append(", ").append(types[i] == null ? null : types[i].getName());
            }
        }
        error.append(')');
        throw new NoSuchMethodException(error.toString());
    }

    @CallerSensitive
    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Constructor cachedConstructor;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 0);
        }
        if ((cachedConstructor = this.lookupCachedConstructor(parameterTypes == null ? EmptyParameters : parameterTypes)) != null && Modifier.isPublic(cachedConstructor.getModifiers())) {
            return cachedConstructor;
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            this.throwNoSuchMethodException("<init>", parameterTypes == null ? EmptyParameters : parameterTypes);
        }
        J9VMInternals.prepare(this);
        if (parameterTypes == null || parameterTypes.length == 0) {
            Constructor rc = this.getConstructorImpl(EmptyParameters, "()V");
            if (rc == null) {
                this.throwNoSuchMethodException("<init>", EmptyParameters);
            }
            return this.cacheConstructor(rc);
        }
        int total = 3;
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) {
                sigs[i] = super.getSignature();
                total += sigs[i].length();
                continue;
            }
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(sigs[i]);
        }
        signature.append(")V");
        Constructor rc = this.getConstructorImpl((Class[])parameterTypes.clone(), signature.toString());
        if (rc != null) {
            rc = Class.checkParameterTypes(rc, parameterTypes);
        }
        if (rc == null) {
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        return this.cacheConstructor(rc);
    }

    private native Constructor getConstructorImpl(Class[] var1, String var2);

    @CallerSensitive
    public Constructor<?>[] getConstructors() throws SecurityException {
        Constructor[] cachedConstructors;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 0);
        }
        if ((cachedConstructors = this.lookupCachedConstructors(PublicKey)) != null) {
            return cachedConstructors;
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            return this.cacheConstructors(new Constructor[0], PublicKey);
        }
        J9VMInternals.prepare(this);
        Constructor[] ctors = this.getConstructorsImpl();
        return this.cacheConstructors(ctors, PublicKey);
    }

    private native Constructor[] getConstructorsImpl();

    @CallerSensitive
    public Class<?>[] getDeclaredClasses() throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkNonSunProxyMemberAccess(security, callerClassLoader, 1);
        }
        return this.getDeclaredClassesImpl();
    }

    private native Class[] getDeclaredClassesImpl();

    @CallerSensitive
    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Constructor cachedConstructor;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 1);
        }
        if ((cachedConstructor = this.lookupCachedConstructor(parameterTypes == null ? EmptyParameters : parameterTypes)) != null) {
            return cachedConstructor;
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            this.throwNoSuchMethodException("<init>", parameterTypes == null ? EmptyParameters : parameterTypes);
        }
        J9VMInternals.prepare(this);
        if (parameterTypes == null || parameterTypes.length == 0) {
            Constructor rc = this.getDeclaredConstructorImpl(EmptyParameters, "()V");
            if (rc == null) {
                this.throwNoSuchMethodException("<init>", EmptyParameters);
            }
            return this.cacheConstructor(rc);
        }
        int total = 3;
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) {
                sigs[i] = super.getSignature();
                total += sigs[i].length();
                continue;
            }
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(sigs[i]);
        }
        signature.append(")V");
        Constructor rc = this.getDeclaredConstructorImpl((Class[])parameterTypes.clone(), signature.toString());
        if (rc != null) {
            rc = Class.checkParameterTypes(rc, parameterTypes);
        }
        if (rc == null) {
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        return this.cacheConstructor(rc);
    }

    private native Constructor getDeclaredConstructorImpl(Class[] var1, String var2);

    @CallerSensitive
    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        Constructor[] cachedConstructors;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 1);
        }
        if ((cachedConstructors = this.lookupCachedConstructors(DeclaredKey)) != null) {
            return cachedConstructors;
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            return this.cacheConstructors(new Constructor[0], DeclaredKey);
        }
        J9VMInternals.prepare(this);
        Constructor[] ctors = this.getDeclaredConstructorsImpl();
        return this.cacheConstructors(ctors, DeclaredKey);
    }

    private native Constructor[] getDeclaredConstructorsImpl();

    @CallerSensitive
    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        Field cachedField;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 1);
        }
        if ((cachedField = this.lookupCachedField(name)) != null && cachedField.getDeclaringClass() == this) {
            return cachedField;
        }
        J9VMInternals.prepare(this);
        Field field = this.getDeclaredFieldImpl(name);
        if (VM.PACKED_SUPPORT_ENABLED && this.fieldRequiresPacked(field)) {
            throw new NoSuchFieldException(name);
        }
        return this.cacheField(field);
    }

    private native Field getDeclaredFieldImpl(String var1) throws NoSuchFieldException;

    @CallerSensitive
    public Field[] getDeclaredFields() throws SecurityException {
        Field[] cachedFields;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 1);
        }
        if ((cachedFields = this.lookupCachedFields(DeclaredKey)) != null) {
            return cachedFields;
        }
        J9VMInternals.prepare(this);
        Field[] fields = this.getDeclaredFieldsImpl();
        if (VM.PACKED_SUPPORT_ENABLED) {
            fields = this.filterPackedFields(fields);
        }
        return this.cacheFields(fields, DeclaredKey);
    }

    private native Field[] getDeclaredFieldsImpl();

    @CallerSensitive
    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Class[] params;
        String strSig;
        Method cachedMethod;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 1);
        }
        if ((cachedMethod = this.lookupCachedMethod(name, parameterTypes == null ? EmptyParameters : parameterTypes)) != null && cachedMethod.getDeclaringClass() == this) {
            return cachedMethod;
        }
        J9VMInternals.prepare(this);
        if (this == Unsafe.class && name.equals("getUnsafe")) {
            this.throwNoSuchMethodException(name, parameterTypes);
        }
        if (VM.PACKED_SUPPORT_ENABLED && this == PackedUnsafe.class && name.equals("getUnsafe")) {
            this.throwNoSuchMethodException(name, parameterTypes);
        }
        if (name == null || parameterTypes == null || parameterTypes.length == 0) {
            strSig = "()";
            params = EmptyParameters;
        } else {
            strSig = this.getParameterTypesSignature(name, parameterTypes);
            params = (Class[])parameterTypes.clone();
        }
        Method result = this.getDeclaredMethodImpl(name, params, strSig, null);
        if (result == null) {
            this.throwNoSuchMethodException(name, params);
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            this.throwNoSuchMethodException(name, params);
        }
        if (params.length > 0) {
            ClassLoader loader = this.getClassLoaderImpl();
            for (int i = 0; i < params.length; ++i) {
                Class parameterType = params[i];
                if (parameterType.isPrimitive()) continue;
                try {
                    if (Class.forName(parameterType.getName(), false, loader) == parameterType) continue;
                    this.throwNoSuchMethodException(name, parameterTypes);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.throwNoSuchMethodException(name, parameterTypes);
                }
            }
        }
        Method bestCandidate = result;
        int maxDepth = super.getClassDepth();
        while ((result = this.getDeclaredMethodImpl(name, params, strSig, result)) != null) {
            int resultDepth = super.getClassDepth();
            if (resultDepth <= maxDepth) continue;
            bestCandidate = result;
            maxDepth = resultDepth;
        }
        return this.cacheMethod(bestCandidate);
    }

    private native Method getDeclaredMethodImpl(String var1, Class[] var2, String var3, Method var4);

    @CallerSensitive
    public Method[] getDeclaredMethods() throws SecurityException {
        Method[] cachedMethods;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 1);
        }
        if ((cachedMethods = this.lookupCachedMethods(DeclaredKey)) != null) {
            return cachedMethods;
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            return this.cacheMethods(new Method[0], DeclaredKey);
        }
        J9VMInternals.prepare(this);
        Method[] methods = this.getDeclaredMethodsImpl();
        if (this == Unsafe.class) {
            methods = Class.filterUnsafe(methods);
        }
        if (VM.PACKED_SUPPORT_ENABLED && this == PackedUnsafe.class) {
            methods = Class.filterUnsafe(methods);
        }
        return this.cacheMethods(methods, DeclaredKey);
    }

    private native Method[] getDeclaredMethodsImpl();

    @CallerSensitive
    public Class<?> getDeclaringClass() {
        Class declaringClass = this.getDeclaringClassImpl();
        if (declaringClass == null) {
            return declaringClass;
        }
        if (declaringClass.isClassADeclaredClass(this)) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
                declaringClass.checkMemberAccess(security, callerClassLoader, -1);
            }
            return declaringClass;
        }
        throw new IncompatibleClassChangeError(Msg.getString("K0555", this.getName(), declaringClass.getName()));
    }

    private native boolean isClassADeclaredClass(Class<?> var1);

    private native Class getDeclaringClassImpl();

    @CallerSensitive
    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        Field cachedField;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 0);
        }
        if ((cachedField = this.lookupCachedField(name)) != null && Modifier.isPublic(cachedField.getModifiers())) {
            return cachedField;
        }
        J9VMInternals.prepare(this);
        Field field = this.getFieldImpl(name);
        if (VM.PACKED_SUPPORT_ENABLED && this.fieldRequiresPacked(field)) {
            throw new NoSuchFieldException(name);
        }
        return this.cacheField(field);
    }

    private native Field getFieldImpl(String var1) throws NoSuchFieldException;

    @CallerSensitive
    public Field[] getFields() throws SecurityException {
        Field[] cachedFields;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 0);
        }
        if ((cachedFields = this.lookupCachedFields(PublicKey)) != null) {
            return cachedFields;
        }
        J9VMInternals.prepare(this);
        Field[] fields = this.getFieldsImpl();
        if (VM.PACKED_SUPPORT_ENABLED) {
            fields = this.filterPackedFields(fields);
        }
        return this.cacheFields(fields, PublicKey);
    }

    private native Field[] getFieldsImpl();

    public Class<?>[] getInterfaces() {
        return J9VMInternals.getInterfaces(this);
    }

    @CallerSensitive
    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Class[] params;
        String strSig;
        Method cachedMethod;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 0);
        }
        if ((cachedMethod = this.lookupCachedMethod(name, parameterTypes == null ? EmptyParameters : parameterTypes)) != null && Modifier.isPublic(cachedMethod.getModifiers())) {
            return cachedMethod;
        }
        J9VMInternals.prepare(this);
        if (this == Unsafe.class && name.equals("getUnsafe")) {
            this.throwNoSuchMethodException(name, parameterTypes);
        }
        if (VM.PACKED_SUPPORT_ENABLED && this == PackedUnsafe.class && name.equals("getUnsafe")) {
            this.throwNoSuchMethodException(name, parameterTypes);
        }
        if (name == null || parameterTypes == null || parameterTypes.length == 0) {
            strSig = "()";
            params = EmptyParameters;
        } else {
            strSig = this.getParameterTypesSignature(name, parameterTypes);
            params = (Class[])parameterTypes.clone();
        }
        Method result = this.getMethodImpl(name, params, strSig);
        if (result == null) {
            this.throwNoSuchMethodException(name, params);
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            this.throwNoSuchMethodException(name, params);
        }
        if (params.length > 0) {
            ClassLoader loader = result.getDeclaringClass().getClassLoaderImpl();
            for (int i = 0; i < params.length; ++i) {
                Class parameterType = params[i];
                if (parameterType.isPrimitive()) continue;
                try {
                    if (Class.forName(parameterType.getName(), false, loader) == parameterType) continue;
                    this.throwNoSuchMethodException(name, parameterTypes);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.throwNoSuchMethodException(name, parameterTypes);
                }
            }
        }
        Method bestCandidate = result;
        int maxDepth = super.getClassDepth();
        Class<?> declaringClass = result.getDeclaringClass();
        while ((result = super.getDeclaredMethodImpl(name, params, strSig, result)) != null) {
            int resultDepth;
            if ((result.getModifiers() & 1) == 0 || (resultDepth = super.getClassDepth()) <= maxDepth) continue;
            bestCandidate = result;
            maxDepth = resultDepth;
        }
        return this.cacheMethod(bestCandidate);
    }

    private native Method getMethodImpl(String var1, Class[] var2, String var3);

    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        Method[] methods;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkMemberAccess(security, callerClassLoader, 0);
        }
        if ((methods = this.lookupCachedMethods(PublicKey)) != null) {
            return methods;
        }
        if (this.isPrimitive()) {
            return new Method[0];
        }
        if (VM.PACKED_SUPPORT_ENABLED && PackedObject.isPackedArray(this)) {
            return this.cacheMethods(new Method[0], PublicKey);
        }
        J9VMInternals.prepare(this);
        if (this.isInterface()) {
            methods = this.getInterfaceMethodsImpl();
            return this.cacheMethods(methods, PublicKey);
        }
        int vCount = 0;
        int sCount = 0;
        while (!this.getVirtualMethodsImpl(methods = (Method[])super.allocateAndFillArray((vCount = this.getVirtualMethodCountImpl()) + (sCount = this.getStaticMethodCountImpl())), 0, vCount) || !this.getStaticMethodsImpl(methods, vCount, sCount)) {
        }
        for (int index = 0; index < vCount; ++index) {
            if (methods[index] == null || !methods[index].getDeclaringClass().isInterface()) continue;
            Method[] interfaceMethods = this.getClassInterfaceMethodsImpl();
            int count = interfaceMethods.length;
            block2: for (int i = 0; i < interfaceMethods.length; ++i) {
                if (interfaceMethods[i] == null) continue;
                for (int j = 0; j < vCount; ++j) {
                    Class<?> declaringClass;
                    if (!this.methodsEqual(interfaceMethods[i], methods[j]) || (declaringClass = methods[j].getDeclaringClass()).isInterface() && !declaringClass.equals(interfaceMethods[i].getDeclaringClass())) continue;
                    interfaceMethods[i] = null;
                    --count;
                    continue block2;
                }
            }
            int methodsLength = methods.length;
            Method[] methodResult = new Method[methodsLength + count];
            System.arraycopy((Object)methods, 0, (Object)methodResult, 0, methodsLength);
            int appendIndex = 0;
            for (int k = 0; k < interfaceMethods.length; ++k) {
                if (interfaceMethods[k] == null) continue;
                methodResult[methodsLength + appendIndex] = interfaceMethods[k];
                ++appendIndex;
            }
            return this.cacheMethods(methodResult, PublicKey);
        }
        if (this == Unsafe.class) {
            methods = Class.filterUnsafe(methods);
        }
        if (VM.PACKED_SUPPORT_ENABLED && this == PackedUnsafe.class) {
            methods = Class.filterUnsafe(methods);
        }
        return this.cacheMethods(methods, PublicKey);
    }

    private boolean methodsEqual(Method m1, Method m2) {
        Class<?>[] m2Parms;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        Class<?>[] m1Parms = m1.getParameterTypes();
        if (m1Parms.length != (m2Parms = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < m1Parms.length; ++i) {
            if (m1Parms[i] == m2Parms[i]) continue;
            return false;
        }
        return true;
    }

    private int getInterfaceMethodCountImpl() {
        int count = this.getDeclaredMethods().length;
        Class<?>[] parents = this.getInterfaces();
        for (int i = 0; i < parents.length; ++i) {
            count += super.getInterfaceMethodCountImpl();
        }
        return count;
    }

    private Method[] getInterfaceMethodsImpl() {
        int i;
        Method[] scratch = new Method[this.getInterfaceMethodCountImpl()];
        Method[] local = this.getDeclaredMethods();
        int index = 0;
        for (i = 0; i < local.length; ++i) {
            if (!Modifier.isAbstract(local[i].getModifiers())) continue;
            scratch[index++] = local[i];
        }
        int localIndex = index;
        int indexPrevBlock = index;
        Class<?>[] parents = this.getInterfaces();
        for (i = 0; i < parents.length; ++i) {
            Method[] parentMethods = super.getInterfaceMethodsImpl();
            for (int j = 0; j < parentMethods.length; ++j) {
                int k;
                if (parentMethods[j] == null) continue;
                boolean redundant = false;
                for (k = 0; k < localIndex; ++k) {
                    if (!this.methodsEqual(scratch[k], parentMethods[j])) continue;
                    redundant = true;
                    break;
                }
                if (!redundant) {
                    for (k = localIndex; k < indexPrevBlock; ++k) {
                        if (!scratch[k].equals(parentMethods[j])) continue;
                        redundant = true;
                        break;
                    }
                }
                if (redundant) continue;
                scratch[index] = parentMethods[j];
                ++index;
            }
            indexPrevBlock = index;
        }
        Method[] unique = new Method[index];
        System.arraycopy((Object)scratch, 0, (Object)unique, 0, index);
        return unique;
    }

    private int getClassInterfaceMethodsCountImpl() {
        int count = 0;
        Class<T> parent = this.getSuperclass();
        if (parent != null && !parent.equals(Object.class)) {
            count += super.getClassInterfaceMethodsCountImpl();
        }
        Class<?>[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            count += super.getInterfaceMethodCountImpl();
        }
        return count;
    }

    private Method[] getClassInterfaceMethodsImpl() {
        int index = 0;
        int indexPrevBlock = 0;
        Method[] scratch = new Method[this.getClassInterfaceMethodsCountImpl()];
        Class<T> parent = this.getSuperclass();
        if (parent != null && !parent.equals(Object.class)) {
            Method[] parentsMethods = super.getClassInterfaceMethodsImpl();
            System.arraycopy((Object)parentsMethods, 0, (Object)scratch, 0, parentsMethods.length);
            indexPrevBlock = index = parentsMethods.length;
        }
        Class<?>[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] interfaceMethods = super.getInterfaceMethodsImpl();
            if (index == 0) {
                System.arraycopy((Object)interfaceMethods, 0, (Object)scratch, 0, interfaceMethods.length);
                indexPrevBlock = index = interfaceMethods.length;
                continue;
            }
            for (int j = 0; j < interfaceMethods.length; ++j) {
                if (interfaceMethods[j] == null) continue;
                boolean redundant = false;
                for (int k = 0; k < indexPrevBlock; ++k) {
                    if (scratch[k] == null || !interfaceMethods[j].equals(scratch[k])) continue;
                    redundant = true;
                    break;
                }
                if (redundant) continue;
                scratch[index] = interfaceMethods[j];
                ++index;
            }
            indexPrevBlock = index;
        }
        Method[] unique = new Method[index];
        System.arraycopy((Object)scratch, 0, (Object)unique, 0, index);
        return unique;
    }

    private native int getVirtualMethodCountImpl();

    private native boolean getVirtualMethodsImpl(Method[] var1, int var2, int var3);

    private native int getStaticMethodCountImpl();

    private native boolean getStaticMethodsImpl(Method[] var1, int var2, int var3);

    private native Object[] allocateAndFillArray(int var1);

    public int getModifiers() {
        int rawModifiers = this.getModifiersImpl();
        rawModifiers = this.isArray() ? (rawModifiers &= 0x417) : (rawModifiers &= 0x761F);
        return rawModifiers;
    }

    private native int getModifiersImpl();

    public String getName() {
        String name = this.classNameString;
        if (name != null) {
            return name;
        }
        this.classNameString = name = VM.getClassNameImpl(this).intern();
        return name;
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain result;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToGetProtectionDomain);
        }
        if ((result = this.getPDImpl()) != null) {
            return result;
        }
        if (AllPermissionsPD == null) {
            this.allocateAllPermissionsPD();
        }
        return AllPermissionsPD;
    }

    private void allocateAllPermissionsPD() {
        Permissions collection = new Permissions();
        collection.add(new AllPermission());
        AllPermissionsPD = new ProtectionDomain(null, collection);
    }

    ProtectionDomain getPDImpl() {
        return this.protectionDomain;
    }

    String getPackageName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return "";
    }

    public URL getResource(String resName) {
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == ClassLoader.bootstrapClassLoader) {
            return ClassLoader.getSystemResource(this.toResourceName(resName));
        }
        return loader.getResource(this.toResourceName(resName));
    }

    public InputStream getResourceAsStream(String resName) {
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == ClassLoader.bootstrapClassLoader) {
            return ClassLoader.getSystemResourceAsStream(this.toResourceName(resName));
        }
        return loader.getResourceAsStream(this.toResourceName(resName));
    }

    private String getSignature() {
        if (this.isArray()) {
            return this.getName();
        }
        if (this.isPrimitive()) {
            if (this == Void.TYPE) {
                return "V";
            }
            if (this == Boolean.TYPE) {
                return "Z";
            }
            if (this == Byte.TYPE) {
                return "B";
            }
            if (this == Character.TYPE) {
                return "C";
            }
            if (this == Short.TYPE) {
                return "S";
            }
            if (this == Integer.TYPE) {
                return "I";
            }
            if (this == Long.TYPE) {
                return "J";
            }
            if (this == Float.TYPE) {
                return "F";
            }
            if (this == Double.TYPE) {
                return "D";
            }
        }
        String name = this.getName();
        return new StringBuffer(name.length() + 2).append('L').append(name).append(';').toString();
    }

    public Object[] getSigners() {
        return this.getClassLoaderImpl().getSigners(this);
    }

    public Class<? super T> getSuperclass() {
        return J9VMInternals.getSuperclass(this);
    }

    public native boolean isArray();

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInstance(Object var1);

    public boolean isInterface() {
        return !this.isArray() && (this.getModifiersImpl() & 0x200) != 0;
    }

    public native boolean isPrimitive();

    @CallerSensitive
    public T newInstance() throws IllegalAccessException, InstantiationException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            this.checkNonSunProxyMemberAccess(security, callerClassLoader, 0);
        }
        return (T)J9VMInternals.newInstanceImpl(this);
    }

    private Object newInstancePrototype(Class callerClass) throws InstantiationException {
        throw new InstantiationException(this);
    }

    private String toResourceName(String resName) {
        if (resName.length() > 0 && resName.charAt(0) == '/') {
            return resName.substring(1);
        }
        String qualifiedClassName = this.getName();
        int classIndex = qualifiedClassName.lastIndexOf(46);
        if (classIndex == -1) {
            return resName;
        }
        return qualifiedClassName.substring(0, classIndex + 1).replace('.', '/') + resName;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public Package getPackage() {
        return this.getClassLoaderImpl().getPackage(this.getPackageName());
    }

    static Class getPrimitiveClass(String name) {
        if (name.equals("float")) {
            return new float[0].getClass().getComponentType();
        }
        if (name.equals("double")) {
            return new double[0].getClass().getComponentType();
        }
        if (name.equals("int")) {
            return new int[0].getClass().getComponentType();
        }
        if (name.equals("long")) {
            return new long[0].getClass().getComponentType();
        }
        if (name.equals("char")) {
            return new char[0].getClass().getComponentType();
        }
        if (name.equals("byte")) {
            return new byte[0].getClass().getComponentType();
        }
        if (name.equals("boolean")) {
            return new boolean[0].getClass().getComponentType();
        }
        if (name.equals("short")) {
            return new short[0].getClass().getComponentType();
        }
        if (name.equals("void")) {
            try {
                Method method = Runnable.class.getMethod("run", new Class[0]);
                return method.getReturnType();
            }
            catch (Exception e) {
                VM.dumpString("Cannot initialize Void.TYPE\n");
            }
        }
        throw new Error("Unknown primitive type: " + name);
    }

    public boolean desiredAssertionStatus() {
        ClassLoader cldr = this.getClassLoaderImpl();
        if (cldr != null) {
            return cldr.getClassAssertionStatus(this.getName());
        }
        return false;
    }

    @CallerSensitive
    static final native Class getStackClass(int var0);

    @CallerSensitive
    static final native Class[] getStackClasses(int var0, boolean var1);

    @CallerSensitive
    static int classDepth(String name) {
        Class[] classes = Class.getStackClasses(-1, false);
        for (int i = 1; i < classes.length; ++i) {
            if (!classes[i].getName().equals(name)) continue;
            return i - 1;
        }
        return -1;
    }

    @CallerSensitive
    static int classLoaderDepth() {
        Class[] classes = Class.getStackClasses(-1, true);
        for (int i = 1; i < classes.length; ++i) {
            ClassLoader cl = classes[i].getClassLoaderImpl();
            if (cl.isASystemClassLoader()) continue;
            return i - 1;
        }
        return -1;
    }

    @CallerSensitive
    static ClassLoader currentClassLoader() {
        Class[] classes = Class.getStackClasses(-1, true);
        for (int i = 1; i < classes.length; ++i) {
            ClassLoader cl = classes[i].getClassLoaderImpl();
            if (cl.isASystemClassLoader()) continue;
            return cl;
        }
        return null;
    }

    @CallerSensitive
    static Class currentLoadedClass() {
        Class[] classes = Class.getStackClasses(-1, true);
        for (int i = 1; i < classes.length; ++i) {
            ClassLoader cl = classes[i].getClassLoaderImpl();
            if (cl.isASystemClassLoader()) continue;
            return classes[i];
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        if (annotation == null) {
            throw new NullPointerException();
        }
        return (A)this.getAnnotationCache().annotationMap.get(annotation);
    }

    @Override
    public Annotation[] getAnnotations() {
        Collection<Annotation> annotations = this.getAnnotationCache().annotationMap.values();
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Collection<Annotation> directAnnotations = this.getAnnotationCache().directAnnotationMap.values();
        return directAnnotations.toArray(new Annotation[directAnnotations.size()]);
    }

    private AnnotationCache getAnnotationCache() {
        AnnotationCache annotationCacheResult = this.annotationCache;
        if (annotationCacheResult == null) {
            byte[] annotationsData = this.getDeclaredAnnotationsData();
            if (annotationsData == null) {
                annotationCacheResult = new AnnotationCache(Collections.EMPTY_MAP, this.buildAnnotations(Collections.EMPTY_MAP));
            } else {
                Annotation[] directAnnotations = AnnotationParser.toArray(AnnotationParser.parseAnnotations((byte[])annotationsData, (ConstantPool)new Access().getConstantPool(this), (Class)this));
                LinkedHashMap<Class<? extends Annotation>, Annotation> directAnnotationsMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>(directAnnotations.length * 4 / 3);
                for (Annotation annotation : directAnnotations) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    directAnnotationsMap.put(annotationType, annotation);
                }
                annotationCacheResult = new AnnotationCache(directAnnotationsMap, this.buildAnnotations(directAnnotationsMap));
            }
            if (annotationCacheOffset == -1L) {
                try {
                    Field annotationCacheField = Class.class.getDeclaredField("annotationCache");
                    annotationCacheOffset = Class.getUnsafe().objectFieldOffset(annotationCacheField);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            Class.getUnsafe().putOrderedObject(this, annotationCacheOffset, annotationCacheResult);
        }
        return annotationCacheResult;
    }

    private boolean isInheritedAnnotationType() {
        return this.getAnnotationCache().directAnnotationMap.get(Inherited.class) != null;
    }

    private Map<Class<? extends Annotation>, Annotation> buildAnnotations(Map<Class<? extends Annotation>, Annotation> directAnnotationsMap) {
        Class<T> superClass = this.getSuperclass();
        if (superClass == null) {
            return directAnnotationsMap;
        }
        Map<Class<? extends Annotation>, Annotation> superAnnotations = super.getAnnotationCache().annotationMap;
        LinkedHashMap<Class<? extends Annotation>, Annotation> annotationsMap = null;
        for (Map.Entry<Class<? extends Annotation>, Annotation> entry : superAnnotations.entrySet()) {
            Class<? extends Annotation> annotationType = entry.getKey();
            if (!super.isInheritedAnnotationType()) continue;
            if (annotationsMap == null) {
                annotationsMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>((superAnnotations.size() + directAnnotationsMap.size()) * 4 / 3);
            }
            annotationsMap.put(annotationType, entry.getValue());
        }
        if (annotationsMap == null) {
            return directAnnotationsMap;
        }
        annotationsMap.putAll(directAnnotationsMap);
        return annotationsMap;
    }

    private native byte[] getDeclaredAnnotationsData();

    public boolean isAnnotation() {
        return !this.isArray() && (this.getModifiersImpl() & 0x2000) != 0;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new NullPointerException();
        }
        return this.getAnnotation((Class)annotation) != null;
    }

    public <U> Class<? extends U> asSubclass(Class<U> cls) {
        if (!cls.isAssignableFrom(this)) {
            throw new ClassCastException(this.toString());
        }
        return this;
    }

    public T cast(Object object) {
        if (object != null && !this.isInstance(object)) {
            throw new ClassCastException(Msg.getString("K0336", object.getClass(), this));
        }
        return (T)object;
    }

    public boolean isEnum() {
        return !this.isArray() && (this.getModifiersImpl() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    private EnumVars getEnumVars() {
        EnumVars tempEnumVars = this.enumVars;
        if (tempEnumVars == null) {
            if (enumVarsOffset == -1L) {
                try {
                    Field enumVarsField = Class.class.getDeclaredField("enumVars");
                    enumVarsOffset = Class.getUnsafe().objectFieldOffset(enumVarsField);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            tempEnumVars = new EnumVars();
            Class.getUnsafe().putOrderedObject(this, enumVarsOffset, tempEnumVars);
        }
        return tempEnumVars;
    }

    Map<String, T> enumConstantDirectory() {
        EnumVars localEnumVars = this.getEnumVars();
        Map map = localEnumVars.cachedEnumConstantDirectory;
        if (null == map) {
            T[] enums = this.getEnumConstantsShared();
            if (enums == null) {
                throw new IllegalArgumentException(Msg.getString("K0564", this.getName()));
            }
            map = new HashMap(enums.length * 4 / 3);
            for (int i = 0; i < enums.length; ++i) {
                map.put(((Enum)enums[i]).name(), enums[i]);
            }
            if (EnumVars.enumDirOffset == -1L) {
                try {
                    Field enumDirField = EnumVars.class.getDeclaredField("cachedEnumConstantDirectory");
                    EnumVars.enumDirOffset = Class.getUnsafe().objectFieldOffset(enumDirField);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            Class.getUnsafe().putOrderedObject(localEnumVars, EnumVars.enumDirOffset, map);
        }
        return map;
    }

    T[] getEnumConstantsShared() {
        EnumVars localEnumVars = this.getEnumVars();
        Object[] enums = localEnumVars.cachedEnumConstants;
        if (null == enums) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                PrivilegedExceptionAction<Method> privilegedAction = new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Method method = Class.this.getMethod("values", new Class[0]);
                        method.setAccessible(true);
                        return method;
                    }
                };
                Method values = AccessController.doPrivileged(privilegedAction);
                enums = (Object[])values.invoke((Object)this, new Object[0]);
                if (EnumVars.enumConstantsOffset == -1L) {
                    try {
                        Field enumConstantsField = EnumVars.class.getDeclaredField("cachedEnumConstants");
                        EnumVars.enumConstantsOffset = Class.getUnsafe().objectFieldOffset(enumConstantsField);
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
                Class.getUnsafe().putOrderedObject(localEnumVars, EnumVars.enumConstantsOffset, enums);
            }
            catch (PrivilegedActionException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return enums;
    }

    public T[] getEnumConstants() {
        if (null != this.getEnumConstantsShared()) {
            return (Object[])this.getEnumConstantsShared().clone();
        }
        return null;
    }

    public boolean isSynthetic() {
        return !this.isArray() && (this.getModifiersImpl() & 0x1000) != 0;
    }

    private native String getGenericSignature();

    private CoreReflectionFactory getFactory() {
        return CoreReflectionFactory.make(this, ClassScope.make(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassRepositoryHolder getClassRepositoryHolder() {
        ClassRepositoryHolder localClassRepositoryHolder = this.classRepoHolder;
        if (localClassRepositoryHolder == null) {
            Class clazz = this;
            synchronized (clazz) {
                localClassRepositoryHolder = this.classRepoHolder;
                if (localClassRepositoryHolder == null) {
                    String signature = this.getGenericSignature();
                    if (signature == null) {
                        localClassRepositoryHolder = ClassRepositoryHolder.NullSingleton;
                    } else {
                        ClassRepository classRepo = ClassRepository.make(signature, this.getFactory());
                        localClassRepositoryHolder = new ClassRepositoryHolder(classRepo);
                    }
                    this.classRepoHolder = localClassRepositoryHolder;
                }
            }
        }
        return localClassRepositoryHolder;
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        ClassRepositoryHolder holder = this.getClassRepositoryHolder();
        ClassRepository repository = holder.classRepository;
        if (repository == null) {
            return new TypeVariable[0];
        }
        return repository.getTypeParameters();
    }

    public Type[] getGenericInterfaces() {
        ClassRepositoryHolder holder = this.getClassRepositoryHolder();
        ClassRepository repository = holder.classRepository;
        if (repository == null) {
            return this.getInterfaces();
        }
        return repository.getSuperInterfaces();
    }

    public Type getGenericSuperclass() {
        ClassRepositoryHolder holder = this.getClassRepositoryHolder();
        ClassRepository repository = holder.classRepository;
        if (repository == null) {
            return this.getSuperclass();
        }
        if (this.isInterface()) {
            return null;
        }
        return repository.getSuperclass();
    }

    private native Object getEnclosingObject();

    @CallerSensitive
    public Constructor<?> getEnclosingConstructor() {
        Constructor constructor = null;
        Object enclosing = this.getEnclosingObject();
        if (enclosing instanceof Constructor) {
            constructor = (Constructor)enclosing;
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
                super.checkMemberAccess(security, callerClassLoader, 1);
            }
        }
        return constructor;
    }

    @CallerSensitive
    public Method getEnclosingMethod() {
        Method method = null;
        Object enclosing = this.getEnclosingObject();
        if (enclosing instanceof Method) {
            method = (Method)enclosing;
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
                super.checkMemberAccess(security, callerClassLoader, 1);
            }
        }
        return method;
    }

    private native Class getEnclosingObjectClass();

    @CallerSensitive
    public Class<?> getEnclosingClass() {
        SecurityManager security;
        Class enclosingClass = this.getDeclaringClass();
        if (enclosingClass == null) {
            enclosingClass = this.getEnclosingObjectClass();
        }
        if (enclosingClass != null && (security = System.getSecurityManager()) != null) {
            ClassLoader callerClassLoader = ClassLoader.getStackClassLoader(1);
            enclosingClass.checkMemberAccess(security, callerClassLoader, -1);
        }
        return enclosingClass;
    }

    private native String getSimpleNameImpl();

    public String getSimpleName() {
        String simpleName;
        int arrayCount = 0;
        Class<?> baseType = this;
        if (this.isArray()) {
            arrayCount = 1;
            while ((baseType = baseType.getComponentType()).isArray()) {
                ++arrayCount;
            }
        }
        if ((simpleName = baseType.getSimpleNameImpl()) == null) {
            if (super.getEnclosingObjectClass() != null) {
                simpleName = "";
            } else {
                simpleName = baseType.getName();
                int index = simpleName.lastIndexOf(46);
                if (index != -1) {
                    simpleName = simpleName.substring(index + 1);
                }
            }
        }
        if (arrayCount > 0) {
            StringBuffer result = new StringBuffer(simpleName);
            for (int i = 0; i < arrayCount; ++i) {
                result.append("[]");
            }
            return result.toString();
        }
        return simpleName;
    }

    public String getCanonicalName() {
        String canonicalName;
        int arrayCount = 0;
        Class<?> baseType = this;
        if (this.isArray()) {
            arrayCount = 1;
            while ((baseType = baseType.getComponentType()).isArray()) {
                ++arrayCount;
            }
        }
        if (baseType.getEnclosingObjectClass() != null) {
            return null;
        }
        Class<?> declaringClass = baseType.getDeclaringClass();
        if (declaringClass == null) {
            canonicalName = baseType.getName();
        } else {
            String declaringClassCanonicalName = declaringClass.getCanonicalName();
            if (declaringClassCanonicalName == null) {
                return null;
            }
            String simpleName = baseType.getName().substring(declaringClass.getName().length() + 1);
            canonicalName = declaringClassCanonicalName + '.' + simpleName;
        }
        if (arrayCount > 0) {
            StringBuffer result = new StringBuffer(canonicalName);
            for (int i = 0; i < arrayCount; ++i) {
                result.append("[]");
            }
            return result.toString();
        }
        return canonicalName;
    }

    public boolean isAnonymousClass() {
        return this.getSimpleNameImpl() == null && this.getEnclosingObjectClass() != null;
    }

    public boolean isLocalClass() {
        return this.getEnclosingObjectClass() != null && this.getSimpleNameImpl() != null;
    }

    public boolean isMemberClass() {
        return this.getEnclosingObjectClass() == null && this.getDeclaringClass() != null;
    }

    private native int getClassDepth();

    private String getParameterTypesSignature(String name, Class[] parameterTypes) throws NoSuchMethodException {
        int total = 2;
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class parameterType = parameterTypes[i];
            if (parameterType != null) {
                sigs[i] = parameterType.getSignature();
                total += sigs[i].length();
                continue;
            }
            this.throwNoSuchMethodException(name, parameterTypes);
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(sigs[i]);
        }
        signature.append(')');
        return signature.toString();
    }

    static void initCacheIds() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<Method> mClass = Method.class;
                try {
                    methodParameterTypesField = mClass.getDeclaredField("parameterTypes");
                    methodParameterTypesField.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
                try {
                    copyMethod = mClass.getDeclaredMethod("copy", new Class[0]);
                    copyMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                Class<Field> fClass = Field.class;
                try {
                    copyField = fClass.getDeclaredMethod("copy", new Class[0]);
                    copyField.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                Class<Constructor> cClass = Constructor.class;
                try {
                    constructorParameterTypesField = cClass.getDeclaredField("parameterTypes");
                    constructorParameterTypesField.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
                try {
                    copyConstructor = cClass.getDeclaredMethod("copy", new Class[0]);
                    copyConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private Method lookupCachedMethod(String methodName, Class[] parameters) {
        Method method;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Method: ");
            output.append(this.getName());
            output.append('.');
            output.append(methodName);
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getMethodCache().get(this);
        if (clCache != null && (method = (Method)clCache.get(new CacheKey(methodName, parameters, null))) != null) {
            try {
                Class[] orgParams = (Class[])methodParameterTypesField.get(method);
                for (int i = 0; i < orgParams.length; ++i) {
                    if (parameters[i] == orgParams[i]) continue;
                    return null;
                }
                return (Method)copyMethod.invoke((Object)method, NoArgs);
            }
            catch (IllegalAccessException e) {
                InternalError err = new InternalError(e.toString());
                err.initCause(e);
                throw err;
            }
            catch (InvocationTargetException e) {
                InternalError err = new InternalError(e.toString());
                err.initCause(e);
                throw err;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    private Method cacheMethod(Method method) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return method;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.bootstrapClassLoader) {
            return method;
        }
        if (copyMethod == null) {
            return method;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Method: ");
            output.append(this.getName());
            output.append('.');
            output.append(method.getName());
            System.err.println(output);
        }
        try {
            Method foundMethod;
            ClassLoader.CacheTable cacheTable;
            ClassLoader.CacheTable clCache;
            CacheKey key = new CacheKey(method.getName(), (Class[])methodParameterTypesField.get(method), method.getReturnType());
            Class<?> declaringClass = method.getDeclaringClass();
            ClassLoader loader = this.getClassLoaderImpl();
            if (loader == null) {
                return method;
            }
            if (declaringClass != this) {
                cacheTable = clCache = loader.getMethodCache(declaringClass);
                synchronized (cacheTable) {
                    foundMethod = (Method)clCache.get(key);
                    if (foundMethod == null) {
                        clCache.put(key, new ReflectRef(method, key, clCache));
                    } else {
                        method = foundMethod;
                    }
                    clCache.free();
                }
            }
            cacheTable = clCache = loader.getMethodCache(this);
            synchronized (cacheTable) {
                if (declaringClass == this) {
                    foundMethod = (Method)clCache.get(key);
                    if (foundMethod == null) {
                        clCache.put(key, new ReflectRef(method, key, clCache));
                    } else {
                        method = foundMethod;
                    }
                }
                CacheKey lookupKey = new CacheKey(method.getName(), (Class[])methodParameterTypesField.get(method), null);
                clCache.put(lookupKey, new ReflectRef(method, lookupKey, clCache));
                clCache.free();
            }
            return (Method)copyMethod.invoke((Object)method, NoArgs);
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private Field lookupCachedField(String fieldName) {
        Field field;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Field: ");
            output.append(this.getName());
            output.append('.');
            output.append(fieldName);
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getFieldCache().get(this);
        if (clCache != null && (field = (Field)clCache.get(new CacheKey(fieldName, EmptyParameters, null))) != null) {
            try {
                return (Field)copyField.invoke((Object)field, NoArgs);
            }
            catch (IllegalAccessException e) {
                InternalError err = new InternalError(e.toString());
                err.initCause(e);
                throw err;
            }
            catch (InvocationTargetException e) {
                InternalError err = new InternalError(e.toString());
                err.initCause(e);
                throw err;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    private Field cacheField(Field field) {
        InternalError err;
        Field foundField;
        ClassLoader.CacheTable cacheTable;
        ClassLoader.CacheTable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return field;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.bootstrapClassLoader) {
            return field;
        }
        if (copyField == null) {
            return field;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Field: ");
            output.append(this.getName());
            output.append('.');
            output.append(field.getName());
            System.err.println(output);
        }
        CacheKey key = new CacheKey(field.getName(), EmptyParameters, field.getType());
        Class<?> declaringClass = field.getDeclaringClass();
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == null) {
            return field;
        }
        if (declaringClass != this) {
            cacheTable = clCache = loader.getFieldCache(declaringClass);
            synchronized (cacheTable) {
                foundField = (Field)clCache.get(key);
                if (foundField == null) {
                    clCache.put(key, new ReflectRef(field, key, clCache));
                } else {
                    field = foundField;
                }
                clCache.free();
            }
        }
        cacheTable = clCache = loader.getFieldCache(this);
        synchronized (cacheTable) {
            if (declaringClass == this) {
                foundField = (Field)clCache.get(key);
                if (foundField == null) {
                    clCache.put(key, new ReflectRef(field, key, clCache));
                } else {
                    field = foundField;
                }
            }
            CacheKey lookupKey = new CacheKey(field.getName(), EmptyParameters, null);
            clCache.put(lookupKey, new ReflectRef(field, lookupKey, clCache));
            clCache.free();
        }
        try {
            return (Field)copyField.invoke((Object)field, NoArgs);
        }
        catch (IllegalAccessException e) {
            err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private Constructor lookupCachedConstructor(Class[] parameters) {
        Constructor constructor;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Constructor: ");
            output.append(this.getName()).append('(');
            for (int i = 0; i < parameters.length; ++i) {
                if (i != 0) {
                    output.append(", ");
                }
                output.append(parameters[i].getName());
            }
            output.append(')');
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getConstructorCache().get(this);
        if (clCache != null && (constructor = (Constructor)clCache.get(new CacheKey(this.getName(), parameters, null))) != null) {
            try {
                Class[] orgParams = (Class[])constructorParameterTypesField.get(constructor);
                for (int i = 0; i < orgParams.length; ++i) {
                    if (parameters[i] == orgParams[i]) continue;
                    return null;
                }
                return (Constructor)copyConstructor.invoke((Object)constructor, NoArgs);
            }
            catch (IllegalAccessException e) {
                InternalError err = new InternalError(e.toString());
                err.initCause(e);
                throw err;
            }
            catch (InvocationTargetException e) {
                InternalError err = new InternalError(e.toString());
                err.initCause(e);
                throw err;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    private Constructor cacheConstructor(Constructor constructor) {
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return constructor;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.bootstrapClassLoader) {
            return constructor;
        }
        if (copyConstructor == null) {
            return constructor;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Constructor: ");
            output.append(this.getName()).append('(');
            Class<?>[] params = constructor.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    output.append(", ");
                }
                output.append(params[i].getName());
            }
            output.append(')');
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return constructor;
        }
        ClassLoader.CacheTable clCache = loader.getConstructorCache(this);
        try {
            CacheKey key = new CacheKey(this.getName(), (Class[])constructorParameterTypesField.get(constructor), null);
            ReflectRef ref = new ReflectRef(constructor, key, clCache);
            ClassLoader.CacheTable cacheTable = clCache;
            synchronized (cacheTable) {
                clCache.put(key, ref);
                clCache.free();
            }
            return (Constructor)copyConstructor.invoke((Object)constructor, NoArgs);
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private Method[] copyMethods(Method[] methods) {
        Method[] result = new Method[methods.length];
        try {
            for (int i = 0; i < methods.length; ++i) {
                result[i] = (Method)copyMethod.invoke((Object)methods[i], NoArgs);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private Method[] lookupCachedMethods(CacheKey cacheKey) {
        Method[] methods;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Methods in: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getMethodCache().get(this);
        if (clCache != null && (methods = (Method[])clCache.get(cacheKey)) != null) {
            return this.copyMethods(methods);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    private Method[] cacheMethods(Method[] methods, CacheKey cacheKey) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return methods;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.bootstrapClassLoader) {
            return methods;
        }
        if (copyMethod == null) {
            return methods;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Methods: ");
            output.append(this.getName());
            System.err.println(output);
        }
        try {
            Class<?> lastDeclaringClass = null;
            ClassLoader.CacheTable declaringCache = null;
            ClassLoader loader = this.getClassLoaderImpl();
            if (loader == null) {
                return methods;
            }
            ClassLoader.CacheTable clCache = loader.getMethodCache(this);
            for (int i = 0; i < methods.length; ++i) {
                Method method;
                ClassLoader.CacheTable cacheTable;
                CacheKey key = new CacheKey(methods[i].getName(), (Class[])methodParameterTypesField.get(methods[i]), methods[i].getReturnType());
                Class<?> declaringClass = methods[i].getDeclaringClass();
                if (declaringClass != this) {
                    if (declaringClass != lastDeclaringClass) {
                        if (declaringCache != null) {
                            declaringCache.free();
                        }
                        declaringCache = loader.getMethodCache(declaringClass);
                        lastDeclaringClass = declaringClass;
                    }
                    cacheTable = declaringCache;
                    synchronized (cacheTable) {
                        method = (Method)declaringCache.get(key);
                        if (method == null) {
                            declaringCache.put(key, new ReflectRef(methods[i], key, declaringCache));
                        } else {
                            methods[i] = method;
                        }
                        continue;
                    }
                }
                cacheTable = clCache;
                synchronized (cacheTable) {
                    method = (Method)clCache.get(key);
                    if (method == null) {
                        clCache.put(key, new ReflectRef(methods[i], key, clCache));
                    } else {
                        methods[i] = method;
                    }
                    continue;
                }
            }
            if (declaringCache != null) {
                declaringCache.free();
            }
            ReflectRef ref = new ReflectRef(methods, cacheKey, clCache);
            ClassLoader.CacheTable cacheTable = clCache;
            synchronized (cacheTable) {
                clCache.put(cacheKey, ref);
                clCache.free();
            }
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        return this.copyMethods(methods);
    }

    private Field[] copyFields(Field[] fields) {
        Field[] result = new Field[fields.length];
        try {
            for (int i = 0; i < fields.length; ++i) {
                result[i] = (Field)copyField.invoke((Object)fields[i], NoArgs);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private Field[] lookupCachedFields(CacheKey cacheKey) {
        Field[] fields;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Fields in: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getFieldCache().get(this);
        if (clCache != null && (fields = (Field[])clCache.get(cacheKey)) != null) {
            return this.copyFields(fields);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    private Field[] cacheFields(Field[] fields, CacheKey cacheKey) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return fields;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.bootstrapClassLoader) {
            return fields;
        }
        if (copyField == null) {
            return fields;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Fields: ");
            output.append(this.getName());
            System.err.println(output);
        }
        Class<?> lastDeclaringClass = null;
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == null) {
            return fields;
        }
        ClassLoader.CacheTable clCache = loader.getFieldCache(this);
        ClassLoader.CacheTable declaringCache = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field;
            ClassLoader.CacheTable cacheTable;
            CacheKey key = new CacheKey(fields[i].getName(), EmptyParameters, fields[i].getType());
            Class<?> declaringClass = fields[i].getDeclaringClass();
            if (declaringClass != this) {
                if (declaringClass != lastDeclaringClass) {
                    if (declaringCache != null) {
                        declaringCache.free();
                    }
                    declaringCache = loader.getFieldCache(declaringClass);
                    lastDeclaringClass = declaringClass;
                }
                cacheTable = declaringCache;
                synchronized (cacheTable) {
                    field = (Field)declaringCache.get(key);
                    if (field == null) {
                        declaringCache.put(key, new ReflectRef(fields[i], key, declaringCache));
                    } else {
                        fields[i] = field;
                    }
                    continue;
                }
            }
            cacheTable = clCache;
            synchronized (cacheTable) {
                field = (Field)clCache.get(key);
                if (field == null) {
                    clCache.put(key, new ReflectRef(fields[i], key, clCache));
                } else {
                    fields[i] = field;
                }
                continue;
            }
        }
        if (declaringCache != null) {
            declaringCache.free();
        }
        ReflectRef ref = new ReflectRef(fields, cacheKey, clCache);
        ClassLoader.CacheTable cacheTable = clCache;
        synchronized (cacheTable) {
            clCache.put(cacheKey, ref);
            clCache.free();
        }
        return this.copyFields(fields);
    }

    private Constructor[] copyConstructors(Constructor[] constructors) {
        Constructor[] result = new Constructor[constructors.length];
        try {
            for (int i = 0; i < constructors.length; ++i) {
                result[i] = (Constructor)copyConstructor.invoke((Object)constructors[i], NoArgs);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private Constructor[] lookupCachedConstructors(CacheKey cacheKey) {
        Constructor[] constructors;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Constructors in: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getConstructorCache().get(this);
        if (clCache != null && (constructors = (Constructor[])clCache.get(cacheKey)) != null) {
            return this.copyConstructors(constructors);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    private Constructor[] cacheConstructors(Constructor[] constructors, CacheKey cacheKey) {
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return constructors;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.bootstrapClassLoader) {
            return constructors;
        }
        if (copyConstructor == null) {
            return constructors;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Constructors: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return constructors;
        }
        ClassLoader.CacheTable clCache = loader.getConstructorCache(this);
        try {
            Object key;
            for (int i = 0; i < constructors.length; ++i) {
                key = new CacheKey(this.getName(), (Class[])constructorParameterTypesField.get(constructors[i]), null);
                ClassLoader.CacheTable cacheTable = clCache;
                synchronized (cacheTable) {
                    Constructor constructor = (Constructor)clCache.get(key);
                    if (constructor == null) {
                        clCache.put(key, new ReflectRef(constructors[i], (CacheKey)key, clCache));
                    } else {
                        constructors[i] = constructor;
                    }
                    continue;
                }
            }
            ReflectRef ref = new ReflectRef(constructors, cacheKey, clCache);
            key = clCache;
            synchronized (key) {
                clCache.put(cacheKey, ref);
                clCache.free();
            }
        }
        catch (IllegalAccessException e) {
            InternalError err = new InternalError(e.toString());
            err.initCause(e);
            throw err;
        }
        return this.copyConstructors(constructors);
    }

    private static Constructor checkParameterTypes(Constructor constructor, Class[] parameterTypes) {
        Class<?>[] constructorParameterTypes;
        if (constructorParameterTypesField != null) {
            try {
                constructorParameterTypes = (Class[])constructorParameterTypesField.get(constructor);
            }
            catch (IllegalArgumentException e) {
                throw new InternalError(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.toString());
            }
        } else {
            constructorParameterTypes = constructor.getParameterTypes();
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == constructorParameterTypes[i]) continue;
            return null;
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodHandle getClassCastHandle() throws IllegalAccessException, NoSuchMethodException {
        if (this.classCastHandle == null) {
            Class clazz = this;
            synchronized (clazz) {
                if (this.classCastHandle == null) {
                    this.classCastHandle = MethodHandles.lookup().bind(this, "cast", MethodType.methodType(Object.class, Object.class));
                }
            }
        }
        return this.classCastHandle;
    }

    private static Method[] filterUnsafe(Method[] methods) {
        int length = methods.length;
        for (int i = 0; i < length; ++i) {
            if (!methods[i].getName().equals("getUnsafe")) continue;
            Method[] filtered = new Method[length - 1];
            System.arraycopy((Object)methods, 0, (Object)filtered, 0, i);
            System.arraycopy((Object)methods, i + 1, (Object)filtered, i, length - 1 - i);
            return filtered;
        }
        return methods;
    }

    private final boolean fieldRequiresPacked(Field field) {
        return null != field && (PackedObject.isPackedArray(this) || PackedObject.class.isAssignableFrom(this) && false == Modifier.isStatic(field.getModifiers()));
    }

    private final Field[] filterPackedFields(Field[] fields) {
        boolean classIsPacked = PackedObject.class.isAssignableFrom(this);
        int keepIdx = 0;
        if (PackedObject.isPackedArray(this)) {
            return new Field[0];
        }
        for (int lookIdx = 0; lookIdx < fields.length; ++lookIdx) {
            if (classIsPacked && !Modifier.isStatic(fields[lookIdx].getModifiers())) continue;
            fields[keepIdx] = fields[lookIdx];
            ++keepIdx;
        }
        if (keepIdx < fields.length) {
            fields = Arrays.copyOf(fields, keepIdx);
        }
        return fields;
    }

    static {
        EmptyParameters = new Class[0];
        enumVarsOffset = -1L;
        annotationCacheOffset = -1L;
        unsafe = Unsafe.getUnsafe();
        NoArgs = new Object[0];
        PublicKey = new CacheKey(".m", EmptyParameters, null);
        DeclaredKey = new CacheKey(".d", EmptyParameters, null);
        queue = new ReferenceQueue();
    }

    static final class CacheKey {
        static final int PRIME = 31;
        String name;
        Class[] parameterTypes;
        Class returnType;
        int hashCode;

        public CacheKey(String name, Class[] params, Class returnType) {
            this.name = name;
            this.parameterTypes = params;
            this.returnType = returnType;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = this.name.hashCode();
                if (this.parameterTypes.length > 0) {
                    int arrayHash = 1;
                    for (int i = 0; i < this.parameterTypes.length; ++i) {
                        arrayHash = 31 * arrayHash + (this.parameterTypes[i] == null ? 0 : this.parameterTypes[i].hashCode());
                    }
                    result = 31 * result + arrayHash;
                }
                if (this.returnType != null) {
                    result = 31 * result + this.returnType.hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            CacheKey other = (CacheKey)obj;
            if (this.returnType != other.returnType) {
                return false;
            }
            if (this.parameterTypes.length != other.parameterTypes.length || !this.name.equals(other.name)) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i] == other.parameterTypes[i]) continue;
                return false;
            }
            return true;
        }
    }

    static final class ReflectRef
    extends SoftReference
    implements Runnable {
        CacheKey key;
        ClassLoader.CacheTable clCache;

        public ReflectRef(Object referent, CacheKey keyValue, ClassLoader.CacheTable clCacheValue) {
            super(referent, queue);
            this.key = keyValue;
            this.clCache = clCacheValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader.CacheTable cacheTable = this.clCache;
            synchronized (cacheTable) {
                if (this.clCache.getRef(this.key) == this) {
                    this.clCache.remove(this.key);
                }
            }
            this.clCache.removeEmpty();
        }
    }

    static final class AnnotationCache {
        final Map<Class<? extends Annotation>, Annotation> directAnnotationMap;
        final Map<Class<? extends Annotation>, Annotation> annotationMap;

        AnnotationCache(Map<Class<? extends Annotation>, Annotation> directMap, Map<Class<? extends Annotation>, Annotation> annMap) {
            this.directAnnotationMap = directMap;
            this.annotationMap = annMap;
        }
    }

    static final class ClassRepositoryHolder {
        static final ClassRepositoryHolder NullSingleton = new ClassRepositoryHolder(null);
        final ClassRepository classRepository;

        ClassRepositoryHolder(ClassRepository classRepo) {
            this.classRepository = classRepo;
        }
    }

    static final class EnumVars<T> {
        static long enumDirOffset = -1L;
        static long enumConstantsOffset = -1L;
        Map<String, T> cachedEnumConstantDirectory;
        T[] cachedEnumConstants;

        EnumVars() {
        }
    }
}

