/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PassThroughHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTuple;

abstract class ArgumentMoverHandle
extends PassThroughHandle {
    final MethodHandle next;
    final int[] permute;

    protected ArgumentMoverHandle(MethodType type, MethodHandle next, int[] permute, Object infoAffectingThunks, MethodHandle equivalent, String name) {
        super(equivalent, name, infoAffectingThunks);
        this.next = next;
        this.permute = permute;
    }

    protected ArgumentMoverHandle(ArgumentMoverHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.permute = originalHandle.permute;
    }

    static int[] identityPermute(MethodType type) {
        int[] result = new int[type.parameterCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    static int[] composePermute(int[] inner, int[] outer, int outerExtraIndexOffset) {
        int innerLength = inner.length;
        int[] result = new int[innerLength];
        for (int i = 0; i < innerLength; ++i) {
            int index = inner[i];
            result[i] = 0 <= index && index < outer.length ? outer[inner[i]] : index + outerExtraIndexOffset;
        }
        return result;
    }

    static int[] insertPermute(int[] originalPermute, int insertLocation, int numValues, int startingIndex) {
        int i;
        int[] result = new int[originalPermute.length + numValues];
        for (i = 0; i < insertLocation; ++i) {
            result[i] = originalPermute[i];
        }
        for (i = 0; i < numValues; ++i) {
            result[insertLocation + i] = startingIndex - i;
        }
        for (i = insertLocation; i < originalPermute.length; ++i) {
            result[i + numValues] = originalPermute[i];
        }
        return result;
    }

    @Override
    protected ThunkTuple computeThunks(Object arg) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])arg));
    }

    static native int permuteArgs(int var0);

    private static boolean extra_Z(ArgumentMoverHandle handle, int index) {
        return handle.extra_Z(index);
    }

    private static byte extra_B(ArgumentMoverHandle handle, int index) {
        return handle.extra_B(index);
    }

    private static char extra_C(ArgumentMoverHandle handle, int index) {
        return handle.extra_C(index);
    }

    private static short extra_S(ArgumentMoverHandle handle, int index) {
        return handle.extra_S(index);
    }

    private static int extra_I(ArgumentMoverHandle handle, int index) {
        return handle.extra_I(index);
    }

    private static long extra_J(ArgumentMoverHandle handle, int index) {
        return handle.extra_J(index);
    }

    private static float extra_F(ArgumentMoverHandle handle, int index) {
        return handle.extra_F(index);
    }

    private static double extra_D(ArgumentMoverHandle handle, int index) {
        return handle.extra_D(index);
    }

    private static Object extra_L(ArgumentMoverHandle handle, int index) {
        return handle.extra_L(index);
    }

    native boolean extra_Z(int var1);

    native byte extra_B(int var1);

    native char extra_C(int var1);

    native short extra_S(int var1);

    native int extra_I(int var1);

    native long extra_J(int var1);

    native float extra_F(int var1);

    native double extra_D(int var1);

    native Object extra_L(int var1);

    void compareWithArgumentMover(ArgumentMoverHandle left, Comparator c) {
        c.compareStructuralParameter(left.permute.length, this.permute.length);
        for (int i = 0; i < left.permute.length && i < this.permute.length; ++i) {
            c.compareStructuralParameter(left.permute[i], this.permute[i]);
        }
        c.compareChildHandle(left.next, this.next);
    }
}

