/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkTuple;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;

class ThunkTable {
    private final ConcurrentHashMap<ThunkKey, ThunkTuple> tuples = new ConcurrentHashMap();

    ThunkTable() {
    }

    public ThunkTuple get(ThunkKey key) {
        ThunkTuple result = this.tuples.get(key);
        if (result == null) {
            ThunkTuple existingEntry;
            result = ThunkTuple.newShareable(key.thunkableType);
            if (!Properties.DISABLE_THUNK_SHARING && (existingEntry = this.tuples.putIfAbsent(key, result)) != null) {
                result = existingEntry;
            }
        }
        assert (result != null);
        assert (key.thunkableType.toMethodDescriptorString() == result.thunkableSignature);
        return result;
    }

    public static void load() {
    }

    static class Properties {
        static final boolean DISABLE_THUNK_SHARING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("com.ibm.jsr292.disableThunkSharing");
            }
        });

        Properties() {
        }
    }
}

