/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CPSuri;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.UserNotice;
import java.io.IOException;

public class PolicyQualifierInfo {
    private byte[] encodedInfo;
    private ObjectIdentifier qualifierId;
    private byte[] qualifier;
    private String pqiString;

    public PolicyQualifierInfo(byte[] encoded) throws IOException {
        DerInputStream derin = new DerInputStream(encoded);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        this.encodedInfo = (byte[])encoded.clone();
    }

    public final byte[] getEncoded() {
        return (byte[])this.encodedInfo.clone();
    }

    public final String getPolicyQualifierId() {
        return this.qualifierId.toString();
    }

    public final byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return null;
        }
        return (byte[])this.qualifier.clone();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PolicyQualifierInfo: [\nqualifier ID:\t" + this.getPolicyQualifierId() + "\n");
        if (this.pqiString != null) {
            sb.append("qualifier:\t" + this.pqiString + "\n]");
        } else {
            HexDumpEncoder enc = new HexDumpEncoder();
            sb.append("qualifier:\t" + (this.qualifier == null ? "null" : enc.encodeBuffer(this.qualifier)) + "\n]");
        }
        return sb.toString();
    }

    private void decode(DerValue encoding) throws IOException {
        if (encoding.getTag() != 48) {
            throw new IOException("PolicyQualifierInfo parsing error, not a SEQUENCE");
        }
        this.qualifierId = encoding.getData().getOID();
        DerValue der = encoding.getData().getDerValue();
        byte[] encodedValue = der.toByteArray();
        if (encodedValue == null) {
            this.qualifier = null;
        } else {
            this.qualifier = (byte[])encodedValue.clone();
            if (this.qualifierId.equals(PKIXExtensions.UserNotice_Id)) {
                try {
                    this.pqiString = new UserNotice(this.qualifier).toString();
                }
                catch (IOException ex) {
                    this.pqiString = null;
                }
            } else if (this.qualifierId.equals(PKIXExtensions.CPSuri_Id)) {
                try {
                    this.pqiString = new CPSuri(this.qualifier).toString();
                }
                catch (IOException ex) {
                    this.pqiString = null;
                }
            }
        }
        if (encoding.getData().available() != 0) {
            throw new IOException("PolicyQualifierInfo parsing error - data overrun, bytes = " + encoding.getData().available());
        }
    }
}

