/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ejs.ras;

import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TrSimpleFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String one0 = "0";
    private static String two0 = "00";
    private static String three0 = "000";
    private static String four0 = "0000";
    private static String five0 = "00000";
    private static String six0 = "000000";
    private static String seven0 = "0000000";
    private static String pad1 = " ";
    private static String pad2 = "  ";
    private static String pad3 = "   ";
    private static String pad4 = "    ";
    private static String pad5 = "     ";
    private static String pad6 = "      ";
    private static String pad7 = "       ";
    private static String pad8 = "        ";
    private static String pad9 = "         ";
    private static String pad10 = "          ";
    private static String pad11 = "           ";
    private static String pad12 = "            ";
    SimpleDateFormat dateFormat = new SimpleDateFormat();
    SimpleDateFormat timeFormat = new SimpleDateFormat();
    Date date = new Date();
    StringBuffer timeBuffer = new StringBuffer();
    StringBuffer dateBuffer = new StringBuffer();
    FieldPosition timeField = new FieldPosition(0);
    FieldPosition dateField = new FieldPosition(0);

    public TrSimpleFormatter() {
        this.init();
    }

    public void init() {
        this.dateFormat.applyPattern("yyyy/MM/dd");
        this.timeFormat.applyPattern("HH:mm:ss.SSS");
    }

    public String format(LogRecord logRecord) {
        String string = null;
        this.date.setTime(logRecord.getMillis());
        this.timeBuffer.setLength(0);
        this.dateBuffer.setLength(0);
        String string2 = this.timeFormat.format(this.date, this.timeBuffer, this.timeField).toString();
        String string3 = this.dateFormat.format(this.date, this.dateBuffer, this.dateField).toString();
        string3 = "[" + string3 + " " + string2 + "]";
        String string4 = new String(Integer.toHexString(logRecord.getThreadID()));
        string4 = this.fastThreadFormat(string4);
        String string5 = logRecord.getLoggerName();
        int n = string5.lastIndexOf(".");
        if (n != -1) {
            string5 = string5.substring(n + 1);
        }
        string5 = this.fastClassNameFormat(string5);
        Level level = logRecord.getLevel();
        String string6 = logRecord.getMessage();
        String string7 = string6.toLowerCase();
        String string8 = " 3   ";
        if (level != Level.FINEST) {
            if (level == Level.FINER) {
                if (string7.indexOf("entry") != -1) {
                    string8 = " >   ";
                    string = logRecord.getSourceMethodName();
                    if (string != null) {
                        string6 = string + " " + string6;
                    }
                } else if (string7.indexOf("exit") != -1) {
                    string8 = " <   ";
                    string = logRecord.getSourceMethodName();
                    if (string != null) {
                        string6 = string + " " + string6;
                    }
                } else {
                    string8 = " 2   ";
                }
            } else if (level == Level.INFO) {
                string8 = " I   ";
            } else if (level == Level.WARNING) {
                string8 = " W   ";
            } else if (level == Level.CONFIG) {
                string8 = " C   ";
            } else if (level == Level.SEVERE) {
                string8 = " E   ";
            } else if (level == Level.FINE) {
                string8 = " 1   ";
            }
        }
        String string9 = string3 + " " + string4 + " " + string5 + string8 + string6 + LINE_SEPARATOR;
        return string9;
    }

    private String fastThreadFormat(String string) {
        int n = string.length();
        if (n == 1) {
            return seven0 + string;
        }
        if (n == 2) {
            return six0 + string;
        }
        if (n == 3) {
            return five0 + string;
        }
        if (n == 4) {
            return four0 + string;
        }
        if (n == 5) {
            return three0 + string;
        }
        if (n == 6) {
            return two0 + string;
        }
        if (n == 7) {
            return one0 + string;
        }
        return string;
    }

    private String fastClassNameFormat(String string) {
        int n = string.length();
        if (n > 12) {
            return string.substring(0, 13);
        }
        if (n == 12) {
            return string + pad1;
        }
        if (n == 11) {
            return string + pad2;
        }
        if (n == 10) {
            return string + pad3;
        }
        if (n == 9) {
            return string + pad4;
        }
        if (n == 8) {
            return string + pad5;
        }
        if (n == 7) {
            return string + pad6;
        }
        if (n == 6) {
            return string + pad7;
        }
        if (n == 5) {
            return string + pad8;
        }
        if (n == 4) {
            return string + pad9;
        }
        if (n == 3) {
            return string + pad10;
        }
        if (n == 2) {
            return string + pad11;
        }
        if (n == 1) {
            return string + pad12;
        }
        return string;
    }
}

