/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class LayeredAddressSpace
extends CommonAddressSpace {
    private TreeMap _moduleRanges = new TreeMap();
    private IAbstractAddressSpace _base;
    private MemoryRange[] _moduleRangesArray = null;
    private Integer _lastModuleRange = new Integer(0);

    public LayeredAddressSpace(IAbstractAddressSpace base, boolean isLittleEndian, boolean is64Bit) {
        super(LayeredAddressSpace._extractRanges(base.getMemoryRanges()), isLittleEndian, is64Bit);
        this._base = base;
    }

    private static MemoryRange[] _extractRanges(Iterator memoryRanges) {
        Vector ranges = new Vector();
        while (memoryRanges.hasNext()) {
            ranges.add(memoryRanges.next());
        }
        return ranges.toArray(new MemoryRange[ranges.size()]);
    }

    public Iterator getMemoryRanges() {
        return super.getMemoryRanges();
    }

    public boolean isExecutable(int asid, long address) throws MemoryAccessException {
        return false;
    }

    public boolean isReadOnly(int asid, long address) throws MemoryAccessException {
        return false;
    }

    public boolean isShared(int asid, long address) throws MemoryAccessException {
        return false;
    }

    public int getBytesAt(int asid, long address, byte[] buffer) throws MemoryAccessException {
        MemoryRange range;
        int retI;
        if (null == this._moduleRangesArray) {
            this._moduleRangesArray = this._moduleRanges.keySet().toArray(new MemoryRange[0]);
        }
        if ((retI = LayeredAddressSpace.findWhichMemoryRange(asid, address, this._moduleRangesArray, this._lastModuleRange, false)) > -1 && (range = this._moduleRangesArray[retI]).contains(address)) {
            ClosingFileReader readable = (ClosingFileReader)this._moduleRanges.get(range);
            try {
                long fileOffset = range.getFileOffset() + (address - range.getVirtualAddress());
                readable.seek(fileOffset);
                readable.readFully(buffer);
                return buffer.length;
            }
            catch (IOException ex) {
                System.out.println(">> Memory access exception in getBytesAt");
                throw new MemoryAccessException(asid, address);
            }
        }
        return this._base.getBytesAt(asid, address, buffer);
    }

    public void mapRegion(long virtualAddress, ClosingFileReader residentFile, long fileOffset, long size) {
        MemoryRange range = new MemoryRange(virtualAddress, fileOffset, size);
        this._moduleRanges.put(range, residentFile);
    }
}

