/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DumpReader
implements ResourceReleaser {
    private ImageInputStream _file;
    private boolean _is64Bit;

    public DumpReader(ImageInputStream f, boolean is64Bit) {
        this._file = f;
        this._is64Bit = is64Bit;
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] buffer = new byte[n];
        this._file.readFully(buffer);
        return buffer;
    }

    public int readInt() throws IOException {
        return this._file.readInt();
    }

    public void seek(long position) throws IOException {
        this._file.seek(position);
    }

    public long readLong() throws IOException {
        return this._file.readLong();
    }

    public short readShort() throws IOException {
        return this._file.readShort();
    }

    public byte readByte() throws IOException {
        return this._file.readByte();
    }

    public long readAddress() throws IOException {
        long ptr = 0L;
        ptr = this._is64Bit ? this.readLong() : 0xFFFFFFFFL & (long)this.readInt();
        return ptr;
    }

    public long getPosition() throws IOException {
        return this._file.getStreamPosition();
    }

    public void releaseResources() throws IOException {
        this._file.close();
    }
}

