/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.CompressedFileManager;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.J9FileImageInputStream;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.MultipleCandidateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class ImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    private static final String FACTORY_DTFJ = "com.ibm.dtfj.image.j9.DTFJImageFactory";
    private static final String FACTORY_DDR = "com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory";
    private final ArrayList<Exception> exceptions = new ArrayList();
    private final Logger log = Logger.getLogger("com.ibm.dtfj.log");
    private ClassLoader imageFactoryClassLoader;
    private File tmpdir = null;

    public Image[] getImagesFromArchive(File archive, boolean extract) throws IOException {
        if (archive != null && !FileManager.fileExists(archive)) {
            throw new FileNotFoundException("Archive '" + archive.getAbsolutePath() + "' not found.");
        }
        if (!FileManager.isArchive(archive)) {
            throw new IOException("The specified archive " + archive.getAbsolutePath() + " was not recognised");
        }
        ArrayList<Image> images = new ArrayList<Image>();
        this.exceptions.clear();
        CompressedFileManager manager = (CompressedFileManager)FileManager.getManager(archive);
        List<ManagedImageSource> sources = manager.getImageSources();
        if (extract) {
            File parent = this.getTempDirParent();
            this.tmpdir = FileManager.createTempDir(parent);
        }
        for (ManagedImageSource source : sources) {
            ImageInputStream corestream = null;
            ImageInputStream metastream = null;
            if (extract) {
                manager.extract(source, this.tmpdir);
                File coreFile = new File(source.getPathToExtractedFile());
                corestream = new J9FileImageInputStream(coreFile, source);
                if (source.hasMetaData()) {
                    manager.extract(source.getMetadata(), this.tmpdir);
                    File metaFile = new File(source.getMetadata().getPathToExtractedFile());
                    metastream = new J9FileImageInputStream(metaFile, source.getMetadata());
                }
            } else {
                corestream = manager.getStream(source);
                if (source.hasMetaData()) {
                    metastream = manager.getStream(source.getMetadata());
                }
            }
            try {
                com.ibm.dtfj.image.ImageFactory factory;
                ImageReference imageReference = new ImageReference();
                for (String factory2 : source.getType().getFactoryNames()) {
                    if (this.foundRuntimeInImage(factory2, imageReference, source.toURI(), corestream, metastream)) {
                        if (imageReference.image instanceof ManagedImage) {
                            ((ManagedImage)imageReference.image).setImageSource(source);
                        }
                        images.add(imageReference.image);
                        break;
                    }
                    imageReference.image = null;
                }
                if (imageReference.image != null || !source.getType().equals((Object)ImageSourceType.CORE) || (factory = this.createImageFactory(FACTORY_DDR)) == null) continue;
                imageReference.image = factory.getImage(corestream, source.toURI());
                if (imageReference.image == null) continue;
                images.add(imageReference.image);
            }
            catch (Exception e) {
                this.exceptions.add(e);
            }
        }
        this.printExceptions();
        return images.toArray(new Image[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getImage(File imageFile) throws IOException {
        ImageReference imageReference = new ImageReference();
        if (imageFile != null && !FileManager.fileExists(imageFile)) {
            throw new FileNotFoundException("Image file '" + imageFile.getAbsolutePath() + "' not found.");
        }
        this.exceptions.clear();
        FileManager manager = FileManager.getManager(imageFile);
        List<ManagedImageSource> candidates = manager.getImageSources();
        ManagedImageSource source = null;
        File core = null;
        File meta = null;
        if (FileManager.isArchive(imageFile)) {
            boolean foundCoreFile = false;
            CompressedFileManager archiveManager = (CompressedFileManager)manager;
            for (ManagedImageSource candidate : candidates) {
                if (!candidate.getType().equals((Object)ImageSourceType.CORE)) continue;
                if (foundCoreFile) {
                    throw new MultipleCandidateException(candidates, imageFile);
                }
                source = candidate;
                foundCoreFile = true;
            }
            if (!foundCoreFile) throw new IOException("No core files were detected in " + imageFile.getAbsolutePath());
            File parent = this.getTempDirParent();
            this.tmpdir = FileManager.createTempDir(parent);
            archiveManager.extract(source, this.tmpdir);
            core = source.getExtractedTo();
            if (source.hasMetaData()) {
                archiveManager.extract(source.getMetadata(), this.tmpdir);
                meta = source.getType().equals((Object)ImageSourceType.CORE) ? imageFile : source.getMetadata().getExtractedTo();
            }
        } else {
            if (candidates.size() > 1) {
                throw new MultipleCandidateException(candidates, imageFile);
            }
            source = candidates.get(0);
            core = new File(source.getPath());
            if (source.hasMetaData()) {
                meta = new File(source.getMetadata().getPath());
            }
        }
        for (String factory : source.getType().getFactoryNames()) {
            if (!this.foundImage(factory, imageReference, core, meta)) continue;
            if (!(imageReference.image instanceof ManagedImage)) return imageReference.image;
            ((ManagedImage)imageReference.image).setImageSource(source);
            return imageReference.image;
        }
        this.printExceptions();
        if (!source.getType().equals((Object)ImageSourceType.CORE)) throw new IOException("The file " + imageFile.getAbsolutePath() + " was not recognised by any reader");
        com.ibm.dtfj.image.ImageFactory f = this.createImageFactory(FACTORY_DDR);
        if (null != f) return f.getImage(imageFile);
        this.propagateIOException("Could not create a valid ImageFactory");
        return f.getImage(imageFile);
    }

    public Image getImage(ImageInputStream in, URI sourceID) throws IOException {
        return this.getImage(in, null, sourceID);
    }

    public Image getImage(ImageInputStream in, ImageInputStream meta, URI sourceID) throws IOException {
        ImageReference imageReference = new ImageReference();
        com.ibm.dtfj.image.ImageFactory factory = null;
        this.exceptions.clear();
        if (this.foundRuntimeInImage(FACTORY_DDR, imageReference, sourceID, in, meta)) {
            return imageReference.image;
        }
        if (this.foundRuntimeInImage(FACTORY_DTFJ, imageReference, sourceID, in, meta)) {
            return imageReference.image;
        }
        factory = this.createImageFactory(FACTORY_DDR);
        this.printExceptions();
        if (null == factory) {
            this.propagateIOException("Could not create a valid ImageFactory");
        }
        return factory.getImage(in, meta, sourceID);
    }

    private File getTempDirParent() {
        String tmpdir = System.getProperty("com.ibm.java.diagnostic.tmpdir");
        if (tmpdir == null) {
            return new File(System.getProperty("java.io.tmpdir"));
        }
        return new File(tmpdir);
    }

    public Image getImage(File imageFile, File metadata) throws IOException {
        if (metadata != null && !metadata.exists()) {
            throw new FileNotFoundException("Metadata file '" + metadata.getAbsolutePath() + "' not found.");
        }
        if (imageFile != null && !FileManager.fileExists(imageFile)) {
            throw new FileNotFoundException("Image file '" + imageFile.getAbsolutePath() + "' not found.");
        }
        ImageReference imageReference = new ImageReference();
        com.ibm.dtfj.image.ImageFactory factory = null;
        this.exceptions.clear();
        if (null != metadata) {
            if (this.foundImage(FACTORY_DTFJ, imageReference, imageFile, metadata)) {
                return imageReference.image;
            }
            if (this.foundImage(FACTORY_DDR, imageReference, imageFile, metadata)) {
                return imageReference.image;
            }
        } else {
            if (this.foundImage(FACTORY_DDR, imageReference, imageFile, null)) {
                return imageReference.image;
            }
            if (this.foundImage(FACTORY_DTFJ, imageReference, imageFile, null)) {
                return imageReference.image;
            }
        }
        factory = this.createImageFactory(FACTORY_DDR);
        this.printExceptions();
        if (null == factory) {
            this.propagateIOException("Could not create a valid ImageFactory");
        }
        return factory.getImage(imageFile);
    }

    private void printExceptions() {
        if (0 == this.exceptions.size()) {
            return;
        }
        this.log.fine("Warning : errors encountered whilst creating ImageFactory");
        for (int i = 0; i < this.exceptions.size(); ++i) {
            Exception obj = this.exceptions.get(i);
            if (!(obj instanceof Exception)) continue;
            Exception e = obj;
            this.log.log(Level.FINE, e.getMessage(), e);
        }
    }

    private void propagateIOException(String newExceptionMessage) throws IOException {
        if (this.exceptions.size() == 1 && this.exceptions.get(0) instanceof IOException) {
            throw (IOException)this.exceptions.get(0);
        }
        throw new IOException(newExceptionMessage);
    }

    private boolean foundImage(String className, ImageReference imageReference, File imageFile, File metadata) {
        try {
            com.ibm.dtfj.image.ImageFactory _factory = this.createImageFactory(className);
            if (null == _factory) {
                return false;
            }
            imageReference.image = metadata == null ? _factory.getImage(imageFile) : _factory.getImage(imageFile, metadata);
            boolean foundRuntime = this.hasJavaRuntime(imageReference);
            if (!foundRuntime && imageReference.image != null) {
                imageReference.image.close();
            }
            return foundRuntime;
        }
        catch (Exception e) {
            this.exceptions.add(e);
            return false;
        }
    }

    private boolean foundRuntimeInImage(String className, ImageReference imageReference, URI source, ImageInputStream in, ImageInputStream metadata) {
        try {
            com.ibm.dtfj.image.ImageFactory _factory = this.createImageFactory(className);
            if (null == _factory) {
                return false;
            }
            imageReference.image = metadata == null ? _factory.getImage(in, source) : _factory.getImage(in, metadata, source);
            return this.hasJavaRuntime(imageReference);
        }
        catch (Exception e) {
            this.exceptions.add(e);
            return false;
        }
    }

    private com.ibm.dtfj.image.ImageFactory createImageFactory(String className) {
        if (this.imageFactoryClassLoader == null) {
            this.initClassLoader();
        }
        try {
            Class<?> clazz = Class.forName(className, true, this.imageFactoryClassLoader);
            Object obj = clazz.newInstance();
            if (obj instanceof com.ibm.dtfj.image.ImageFactory) {
                return (com.ibm.dtfj.image.ImageFactory)obj;
            }
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
        return null;
    }

    private boolean hasJavaRuntime(ImageReference imageReference) {
        if (null == imageReference || null == imageReference.image) {
            return false;
        }
        Iterator spaces = imageReference.image.getAddressSpaces();
        while (null != spaces && spaces.hasNext()) {
            Object obj = spaces.next();
            if (null == obj || !(obj instanceof ImageAddressSpace)) continue;
            ImageAddressSpace space = (ImageAddressSpace)obj;
            Iterator procs = space.getProcesses();
            while (null != procs && procs.hasNext()) {
                Object procobj = procs.next();
                if (null == procobj || !(procobj instanceof ImageProcess)) continue;
                ImageProcess proc = (ImageProcess)procobj;
                Iterator runtimes = proc.getRuntimes();
                while (null != runtimes && runtimes.hasNext()) {
                    Object rtobj = runtimes.next();
                    if (null == rtobj || !(rtobj instanceof JavaRuntime)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getDTFJMajorVersion() {
        return 1;
    }

    public int getDTFJMinorVersion() {
        return 11;
    }

    public int getDTFJModificationLevel() {
        return 27026;
    }

    private void initClassLoader() {
        File ddrDir = null;
        String ddrHome = System.getProperty("com.ibm.java.diagnostics.ddr.home");
        ddrDir = ddrHome != null ? new File(ddrHome) : new File(System.getProperty("java.home", ""), "lib/ddr");
        if (ddrDir.isDirectory()) {
            File[] jarFiles = null;
            JarFilter jarFilter = new JarFilter();
            jarFiles = ddrDir.listFiles(jarFilter);
            URL[] urls = new URL[jarFiles.length];
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    urls[i] = jarFiles[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    this.exceptions.add(e);
                }
            }
            this.imageFactoryClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        } else {
            this.imageFactoryClassLoader = this.getClass().getClassLoader();
        }
    }

    class ImageReference {
        Image image;

        ImageReference() {
        }
    }

    private class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

