/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.MemoryAccessException;
import java.util.Properties;

public class ImagePointer
implements com.ibm.dtfj.image.ImagePointer {
    private long _underlyingAddress;
    private com.ibm.dtfj.image.j9.ImageAddressSpace _residentDomain;

    public ImagePointer(com.ibm.dtfj.image.j9.ImageAddressSpace resident, long localAddress) {
        if (null == resident) {
            throw new IllegalArgumentException("Pointer cannot exist in null address space");
        }
        this._residentDomain = resident;
        this._underlyingAddress = localAddress;
    }

    public long getAddress() {
        return this._underlyingAddress;
    }

    public ImageAddressSpace getAddressSpace() {
        return this._residentDomain;
    }

    public com.ibm.dtfj.image.ImagePointer add(long offset) {
        return this._residentDomain.getPointer(this.getAddress() + offset);
    }

    public boolean isExecutable() throws DataUnavailable {
        return this._residentDomain.isExecutableAt(this._underlyingAddress);
    }

    public boolean isReadOnly() throws DataUnavailable {
        return this._residentDomain.isReadOnly(this._underlyingAddress);
    }

    public boolean isShared() throws DataUnavailable {
        return this._residentDomain.isShared(this._underlyingAddress);
    }

    public Properties getProperties() {
        return new Properties();
    }

    public com.ibm.dtfj.image.ImagePointer getPointerAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readPointerAtIndex(this.getAddress() + index);
    }

    public long getLongAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readLongAtIndex(this.getAddress() + index);
    }

    public int getIntAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readIntAtIndex(this.getAddress() + index);
    }

    public short getShortAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readShortAtIndex(this.getAddress() + index);
    }

    public byte getByteAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readByteAtIndex(this.getAddress() + index);
    }

    public float getFloatAt(long index) throws MemoryAccessException, CorruptDataException {
        return Float.intBitsToFloat(this.getIntAt(index));
    }

    public double getDoubleAt(long index) throws MemoryAccessException, CorruptDataException {
        return Double.longBitsToDouble(this.getLongAt(index));
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ImagePointer) {
            ImagePointer local = (ImagePointer)obj;
            isEqual = this._residentDomain.equals(local._residentDomain) && this._underlyingAddress == local._underlyingAddress;
        }
        return isEqual;
    }

    public int hashCode() {
        return this._residentDomain.hashCode() ^ ((int)this._underlyingAddress ^ (int)(this._underlyingAddress >> 32));
    }

    public String toString() {
        return Long.toHexString(this._underlyingAddress);
    }
}

