/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;

public abstract class JavaField
implements com.ibm.dtfj.java.JavaField {
    protected static final String BOOLEAN_SIGNATURE = "Z";
    protected static final String BYTE_SIGNATURE = "B";
    protected static final String CHAR_SIGNATURE = "C";
    protected static final String SHORT_SIGNATURE = "S";
    protected static final String INTEGER_SIGNATURE = "I";
    protected static final String LONG_SIGNATURE = "J";
    protected static final String FLOAT_SIGNATURE = "F";
    protected static final String DOUBLE_SIGNATURE = "D";
    protected static final String OBJECT_PREFIX_SIGNATURE = "L";
    protected static final String ARRAY_PREFIX_SIGNATURE = "[";
    protected JavaRuntime _javaVM;
    private String _name;
    private String _signature;
    private int _modifiers;
    private long _declaringClassID;

    protected JavaField(JavaRuntime vm, String name, String signature, int modifiers, long declaringClassID) {
        if (null == vm) {
            throw new IllegalArgumentException("Java VM for a field must not be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("A Java Field requires a non-null name");
        }
        if (null == signature) {
            throw new IllegalArgumentException("A Java Field requires a non-null signature");
        }
        this._javaVM = vm;
        this._name = name;
        this._signature = signature;
        this._modifiers = modifiers;
        this._declaringClassID = declaringClassID;
    }

    public Object get(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(BOOLEAN_SIGNATURE)) {
            return new Boolean(this.getBoolean(object));
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return new Byte(this.getByte(object));
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return new Character(this.getChar(object));
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return new Short(this.getShort(object));
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return new Integer(this.getInt(object));
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return new Long(this.getLong(object));
        }
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            return new Float(this.getFloat(object));
        }
        if (this.getSignature().equals(DOUBLE_SIGNATURE)) {
            return new Double(this.getDouble(object));
        }
        if (this.getSignature().startsWith(OBJECT_PREFIX_SIGNATURE) || this.getSignature().startsWith(ARRAY_PREFIX_SIGNATURE)) {
            return this.getReferenceType(object);
        }
        throw new IllegalArgumentException("unidentified object signature [" + this.getSignature() + "]");
    }

    public long getLong(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve long");
    }

    public double getDouble(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(DOUBLE_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            return this.getFloat(object);
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve double");
    }

    public float getFloat(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve float");
    }

    public int getInt(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve int");
    }

    public short getShort(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve short");
    }

    protected abstract Object getReferenceType(JavaObject var1) throws CorruptDataException, MemoryAccessException;

    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    public JavaClass getDeclaringClass() throws CorruptDataException {
        JavaClass ret = this._javaVM.getClassForID(this._declaringClassID);
        if (ret == null) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Unknown declaring class ID " + this._declaringClassID, null));
        }
        return ret;
    }

    public String getName() throws CorruptDataException {
        return this._name;
    }

    public String getSignature() throws CorruptDataException {
        return this._signature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(JavaObject hostObject) throws CorruptDataException, MemoryAccessException {
        Object fieldValueObject = this.get(hostObject);
        if (null == fieldValueObject) {
            return null;
        }
        if (!(fieldValueObject instanceof JavaObject)) throw new IllegalArgumentException();
        JavaObject javaObject = (JavaObject)fieldValueObject;
        String stringObject = null;
        if (0L == javaObject.getID().getAddress()) return null;
        JavaClass theClass = javaObject.getJavaClass();
        if (theClass.getName().equals("java/lang/String")) {
            Iterator fields = theClass.getDeclaredFields();
            JavaField value = null;
            JavaField offset = null;
            JavaField count = null;
            while (fields.hasNext()) {
                JavaField aField = (JavaField)fields.next();
                if (aField.getSignature().equals("[C") && aField.getName().equals("value")) {
                    value = aField;
                    continue;
                }
                if (aField.getSignature().equals(INTEGER_SIGNATURE) && aField.getName().equals("offset")) {
                    offset = aField;
                    continue;
                }
                if (!aField.getSignature().equals(INTEGER_SIGNATURE) || !aField.getName().equals("count")) continue;
                count = aField;
            }
            JavaObject characterArray = (JavaObject)value.get(javaObject);
            int length = count.getInt(javaObject);
            char[] ourChars = new char[length];
            int startingIndex = offset.getInt(javaObject);
            characterArray.arraycopy(startingIndex, (Object)ourChars, 0, length);
            return new String(ourChars);
        }
        if (!theClass.getName().equals("null")) throw new IllegalArgumentException();
        return null;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaField) {
            boolean hasSameName;
            JavaField field = (JavaField)obj;
            try {
                hasSameName = this._name.equals(field.getName());
            }
            catch (CorruptDataException cde) {
                hasSameName = false;
            }
            isEqual = hasSameName && this.getClass().equals(field.getClass()) && this._javaVM.equals(field._javaVM) && this._declaringClassID == field._declaringClassID;
        }
        return isEqual;
    }

    public int hashCode() {
        return this._name.hashCode() ^ this._signature.hashCode() ^ this._javaVM.hashCode() ^ ((int)this._declaringClassID ^ (int)(this._declaringClassID >> 32));
    }

    public String toString() {
        try {
            return this.getDeclaringClass().getName() + "." + this.getName() + " : " + this.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
    }
}

