/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import java.util.Collections;
import java.util.Iterator;

public class JCJavaStackFrame
implements JavaStackFrame {
    private ImagePointer fPointer;
    private final JavaLocation fLocation;
    private final JCJavaThread fThread;

    public JCJavaStackFrame(JCJavaThread thread, JavaLocation location) throws JCInvalidArgumentsException {
        if (location == null) {
            throw new JCInvalidArgumentsException("Must have a valid location.");
        }
        if (thread == null) {
            throw new JCInvalidArgumentsException("A java stack frame must be associated with a valid java thread");
        }
        this.fThread = thread;
        this.fLocation = location;
        this.fThread.addStackFrame(this);
    }

    public void setBasePointer(ImagePointer imagePointer) {
        this.fPointer = imagePointer;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        if (this.fPointer == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fPointer;
    }

    public JavaLocation getLocation() throws CorruptDataException {
        return this.fLocation;
    }

    public Iterator getHeapRoots() {
        return Collections.EMPTY_LIST.iterator();
    }
}

