/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JCJavaThread
implements JavaThread {
    private final ImagePointer fThreadID;
    private final CorruptData fCorruptData;
    private final JCJavaRuntime fRuntime;
    private Vector fStackFrames;
    private Vector fStackSections;
    private ImagePointer fJNIEnv;
    private JCImageThread fImageThread;
    private JavaObject fJavaObject;
    private JavaObject blockingJavaObject;
    private String fName;
    private int fPriority;
    private int fState;

    public JCJavaThread(JCJavaRuntime runtime, ImagePointer threadID) throws JCInvalidArgumentsException {
        if (runtime == null) {
            throw new JCInvalidArgumentsException("A Java thread must be associated with a valid Java runtime");
        }
        this.fRuntime = runtime;
        this.fThreadID = this.checkPointer(threadID);
        this.fCorruptData = new JCCorruptData(this.fThreadID);
        this.init(null, -1, -1, null);
        this.fRuntime.addJavaThread(this);
    }

    public JCJavaThread(JCJavaRuntime runtime, ImagePointer threadID, String name) throws JCInvalidArgumentsException {
        if (runtime == null) {
            throw new JCInvalidArgumentsException("A Java thread must be associated with a valid Java runtime");
        }
        this.fRuntime = runtime;
        this.fThreadID = this.checkPointer(threadID);
        this.fCorruptData = new JCCorruptData(this.fThreadID);
        this.init(name, -1, -1, null);
        this.fRuntime.addJavaThread(this);
    }

    private ImagePointer checkPointer(ImagePointer pointer) throws JCInvalidArgumentsException {
        if (pointer == null) {
            throw new JCInvalidArgumentsException("A java thread must have a non null ID");
        }
        return pointer;
    }

    private void init(String name, int priority, int state, JavaObject javaObject) {
        this.fStackFrames = new Vector();
        this.fStackSections = new Vector();
        this.fName = name;
        this.fPriority = priority;
        this.fState = state;
        this.fJavaObject = javaObject;
    }

    public ImageThread getImageThread() throws CorruptDataException, DataUnavailable {
        if (this.fImageThread == null) {
            throw new DataUnavailable("No image thread found for this java thread");
        }
        return this.fImageThread;
    }

    public ImagePointer getJNIEnv() throws CorruptDataException {
        if (this.fJNIEnv == null) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fJNIEnv;
    }

    public String getName() throws CorruptDataException {
        if (this.fName == null) {
            this.fName = "vmthread @" + this.fThreadID.getAddress();
        }
        return this.fName;
    }

    public JavaObject getObject() throws CorruptDataException {
        if (this.fJavaObject == null) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fJavaObject;
    }

    public int getPriority() throws CorruptDataException {
        if (this.fPriority == -1) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fPriority;
    }

    public Iterator getStackFrames() {
        return this.fStackFrames.iterator();
    }

    public void addStackFrame(JavaStackFrame javaStackFrame) {
        if (javaStackFrame != null) {
            this.fStackFrames.add(javaStackFrame);
        }
    }

    public Iterator getStackSections() {
        return this.fStackSections.iterator();
    }

    public int getState() throws CorruptDataException {
        if (this.fState == -1) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fState;
    }

    public void setImageThread(JCImageThread imageThread) {
        this.fImageThread = imageThread;
    }

    public JCImageThread internalGetImageThread() {
        return this.fImageThread;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setPriority(int priority) {
        this.fPriority = priority;
    }

    public void setState(String state) {
        if (state == null) {
            return;
        }
        if (state.equals("R")) {
            this.fState = 5;
        } else if (state.equals("CW")) {
            this.fState = 385;
        } else if (state.equals("P")) {
            this.fState = 641;
        } else if (state.equals("B")) {
            this.fState = 1153;
        } else if (state.equals("MW")) {
            this.fState = 1153;
        }
    }

    public ImagePointer getThreadID() {
        return this.fThreadID;
    }

    public ImagePointer setJNIEnv(ImagePointer env) {
        this.fJNIEnv = env;
        return this.fJNIEnv;
    }

    public void setObject(JavaObject threadObject) {
        this.fJavaObject = threadObject;
    }

    public void setBlockingObject(JavaObject blockingObject) {
        this.blockingJavaObject = blockingObject;
    }

    public JavaObject getBlockingObject() throws CorruptDataException, DataUnavailable {
        return this.blockingJavaObject;
    }
}

