/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaClassLoader;
import com.ibm.dtfj.java.javacore.JCJavaLocation;
import com.ibm.dtfj.java.javacore.JCJavaMethod;
import com.ibm.dtfj.java.javacore.JCJavaMonitor;
import com.ibm.dtfj.java.javacore.JCJavaObject;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import com.ibm.dtfj.java.javacore.JCJavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.javacore.JCJavaStackFrame;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import com.ibm.dtfj.java.javacore.JCJavaVMInitArgs;
import com.ibm.dtfj.java.javacore.JCJavaVMOption;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;
import java.util.HashMap;

public class JavaRuntimeBuilder
extends AbstractBuilderComponent
implements IJavaRuntimeBuilder {
    private JCImageProcess fImageProcess = null;
    private JCJavaRuntime fJavaRuntime = null;
    private JCImageAddressSpace fAddressSpace = null;
    private JCJavaVMInitArgs fJavaVMInitArgs = null;
    private HashMap j9ThreadToJNIEnv = new HashMap();
    private String fId;

    public JavaRuntimeBuilder(JCImageProcess imageProcess, String id) throws JCInvalidArgumentsException {
        super(id);
        if (imageProcess == null) {
            throw new JCInvalidArgumentsException("Must pass non-null image process");
        }
        this.fImageProcess = imageProcess;
        this.fId = id;
        if (this.fId == null) {
            this.fJavaRuntime = new JCJavaRuntime(this.fImageProcess, this.fId);
        }
        this.fAddressSpace = this.fImageProcess.getImageAddressSpace();
    }

    public JavaClassLoader addClassLoader(String classLoaderName, long clID, long objectID) throws BuilderFailureException {
        try {
            JCJavaObject javaObject;
            JCJavaClassLoader classLoader = this.getJavaRuntime().findJavaClassLoader(clID);
            if (classLoader == null) {
                classLoader = new JCJavaClassLoader(this.getJavaRuntime(), clID);
            }
            if ((javaObject = classLoader.getInternalObject()) == null) {
                JCJavaClass javaClass = this.getJavaRuntime().findJavaClass(classLoaderName);
                if (javaClass == null) {
                    javaClass = new JCJavaClass(this.getJavaRuntime(), classLoaderName);
                }
                ImagePointer objectPointer = this.fAddressSpace.getPointer(objectID);
                javaObject = new JCJavaObject(objectPointer, javaClass);
                classLoader.setObject(javaObject);
            }
            return classLoader;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public JavaClass addClass(JavaClassLoader jClassLoader, String name, long classID, long superClassID, String fileName) throws BuilderFailureException {
        try {
            JCJavaClassLoader classLoader = (JCJavaClassLoader)jClassLoader;
            JCJavaClass jClass = this.generateJavaClass(this.getJavaRuntime(), name, classID);
            jClass.setJavaSuperClass(superClassID);
            jClass.setClassLoader(classLoader);
            ImagePointer ip = jClass.getID();
            if (ip != null) {
                classLoader.addClass(name, ip);
            } else if (classLoader.internalGetClass(name) == null) {
                classLoader.addClass(name);
            }
            return jClass;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    private JCJavaClass generateJavaClass(JCJavaRuntime runtime, String name, long classID) throws JCInvalidArgumentsException {
        if (name != null) {
            if (this.fAddressSpace.isValidAddressID(classID)) {
                JCJavaClass jClass = runtime.findJavaClass(classID);
                if (jClass == null) {
                    jClass = runtime.findJavaClass(name);
                    if (jClass != null) {
                        ImagePointer ip = jClass.getID();
                        if (ip == null) {
                            jClass.setID(classID);
                        } else {
                            jClass = new JCJavaClass(runtime, name);
                            jClass.setID(classID);
                        }
                    } else {
                        jClass = new JCJavaClass(runtime, name);
                        jClass.setID(classID);
                    }
                }
                return jClass;
            }
            JCJavaClass jClass = runtime.findJavaClass(name);
            if (jClass == null) {
                jClass = new JCJavaClass(runtime, name);
            }
            if (this.fAddressSpace.isValidAddressID(classID)) {
                jClass.setID(classID);
            }
            return jClass;
        }
        throw new JCInvalidArgumentsException("Failed to add class.  Null class name");
    }

    public ImageProcess getImageProcess() {
        return this.fImageProcess;
    }

    public JavaThread addJavaThread(ImageThread imageThread, String name, long tid, long j9thread_t, long javaObjID, long jniEnv, String state, int priority, long blockingObject, String blockingObjectClass) throws BuilderFailureException {
        try {
            JCJavaObject jobject;
            ImagePointer pointerObjectID;
            JCJavaClass jClass;
            ImagePointer pointer;
            if (j9thread_t != -1L && jniEnv != -1L) {
                ImagePointer pointer2 = this.fAddressSpace.getPointer(jniEnv);
                this.j9ThreadToJNIEnv.put(new Long(j9thread_t), pointer2);
            }
            if (!this.fAddressSpace.isValidAddressID(tid)) {
                throw new JCInvalidArgumentsException("Must pass a valid thread id");
            }
            JCJavaThread javaThread = this.getJavaRuntime().findJavaThread(tid);
            if (javaThread == null) {
                pointer = this.fAddressSpace.getPointer(tid);
                javaThread = new JCJavaThread(this.getJavaRuntime(), pointer);
            }
            javaThread.setName(name);
            javaThread.setPriority(priority);
            javaThread.setState(state);
            javaThread.setImageThread((JCImageThread)imageThread);
            if (jniEnv == -1L) {
                pointer = (ImagePointer)this.j9ThreadToJNIEnv.get(new Long(j9thread_t));
                if (pointer != null) {
                    javaThread.setJNIEnv(pointer);
                } else {
                    javaThread.setJNIEnv(javaThread.getThreadID());
                }
            }
            if (this.fAddressSpace.isValidAddressID(javaObjID)) {
                jClass = this.generateJavaClass(this.getJavaRuntime(), "java/lang/Thread", -1L);
                pointerObjectID = this.fAddressSpace.getPointer(javaObjID);
                jobject = new JCJavaObject(pointerObjectID, jClass);
                javaThread.setObject(jobject);
            }
            if (this.fAddressSpace.isValidAddressID(blockingObject)) {
                jClass = this.generateJavaClass(this.getJavaRuntime(), blockingObjectClass, -1L);
                pointerObjectID = this.fAddressSpace.getPointer(javaObjID);
                jobject = new JCJavaObject(pointerObjectID, jClass);
                javaThread.setBlockingObject(jobject);
            }
            return javaThread;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public JavaStackFrame addJavaStackFrame(JavaThread javaThread, String className, String classFileName, String methodName, String methodType, String compilationLevel, int lineNumber) throws BuilderFailureException {
        try {
            JCJavaThread jThread = (JCJavaThread)javaThread;
            JCJavaClass jclass = this.getJavaRuntime().findJavaClass(className);
            if (jclass == null) {
                jclass = new JCJavaClass(this.getJavaRuntime(), className);
            }
            JCJavaMethod method = new JCJavaMethod(methodName, jclass);
            JCJavaLocation location = new JCJavaLocation(method);
            location.setFilename(classFileName);
            location.setCompilation(compilationLevel);
            location.setLineNumber(lineNumber);
            JCJavaStackFrame stackFrame = new JCJavaStackFrame(jThread, location);
            if ("run".equals(methodName)) {
                try {
                    ImagePointer tid;
                    JavaObject jo = jThread.getObject();
                    if (jo != null && this.fAddressSpace.isValidAddressID((tid = jo.getID()).getAddress())) {
                        JCJavaObject jobject = new JCJavaObject(tid, jclass);
                        jThread.setObject(jobject);
                    }
                }
                catch (CorruptDataException e) {
                    // empty catch block
                }
            }
            return stackFrame;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public JavaMonitor addJavaMonitor(String monitorName, long monitorID, long objectID, String className, long owningThread) throws BuilderFailureException {
        try {
            JCJavaClass jClass;
            JCJavaMonitor monitor = this.getJavaRuntime().findMonitor(monitorID);
            if (monitor == null) {
                ImagePointer pointerMonitorID = this.fAddressSpace.getPointer(monitorID);
                monitor = new JCJavaMonitor(this.getJavaRuntime(), pointerMonitorID, monitorName);
            }
            monitor.setOwner(owningThread);
            if (className != null && (jClass = this.generateJavaClass(this.getJavaRuntime(), className, -1L)) != null && this.fAddressSpace.isValidAddressID(objectID)) {
                ImagePointer pointerObjectID = this.fAddressSpace.getPointer(objectID);
                JCJavaObject jobject = new JCJavaObject(pointerObjectID, jClass);
                monitor.setObject(jobject);
            }
            return monitor;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void addBlockedThread(JavaMonitor monitor, long threadID) throws BuilderFailureException {
        JCJavaMonitor jmonitor = (JCJavaMonitor)monitor;
        ImagePointer pointer = this.fAddressSpace.getPointer(threadID);
        jmonitor.addEnterWaiter(pointer);
    }

    public void addWaitOnNotifyThread(JavaMonitor monitor, long threadID) throws BuilderFailureException {
        JCJavaMonitor jmonitor = (JCJavaMonitor)monitor;
        ImagePointer pointer = this.fAddressSpace.getPointer(threadID);
        jmonitor.addNotifyWaiter(pointer);
    }

    public void addVMInitArgs() throws BuilderFailureException {
        if (this.fJavaVMInitArgs != null) {
            throw new BuilderFailureException("JCJavaVMInitArgs already created for this JavaRuntime");
        }
        try {
            this.fJavaVMInitArgs = new JCJavaVMInitArgs(this.getJavaRuntime(), 0, true);
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void addVMOption(String option) throws BuilderFailureException {
        if (this.fJavaVMInitArgs == null) {
            throw new BuilderFailureException("JCJavaVMInitArgs must be created before options added");
        }
        try {
            this.fJavaVMInitArgs.addOption(new JCJavaVMOption(option, null));
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void addVMOption(String option, long extraInfo) throws BuilderFailureException {
        if (this.fJavaVMInitArgs == null) {
            throw new BuilderFailureException("JCJavaVMInitArgs must be created before options added");
        }
        try {
            ImagePointer pointer = this.fAddressSpace.getPointer(extraInfo);
            this.fJavaVMInitArgs.addOption(new JCJavaVMOption(option, pointer));
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void setJavaVersion(String version) {
        this.getJavaRuntime().setVersion(version);
    }

    private JCJavaRuntime getJavaRuntime() {
        if (this.fJavaRuntime == null) {
            try {
                this.fJavaRuntime = new JCJavaRuntime(this.fImageProcess, this.fId);
            }
            catch (JCInvalidArgumentsException e) {
                IllegalStateException e1 = new IllegalStateException();
                e1.initCause(e);
                throw e1;
            }
        }
        return this.fJavaRuntime;
    }

    public JavaRuntimeMemoryCategory addMemoryCategory(String name, long deepBytes, long deepAllocations, JavaRuntimeMemoryCategory parent) {
        JCJavaRuntimeMemoryCategory category = new JCJavaRuntimeMemoryCategory(name, deepBytes, deepAllocations);
        if (parent != null) {
            ((JCJavaRuntimeMemoryCategory)parent).addChild(category);
        } else {
            this.getJavaRuntime().addTopLevelMemoryCategory(category);
        }
        return category;
    }

    public void setShallowCountersForCategory(JavaRuntimeMemoryCategory category, long shallowBytes, long shallowAllocations) {
        ((JCJavaRuntimeMemoryCategory)category).setShallowCounters(shallowBytes, shallowAllocations);
    }

    public void setJITEnabled(boolean enabled) {
        this.getJavaRuntime().setJITEnabled(enabled);
    }

    public void addJITProperty(String name, String value) {
        this.getJavaRuntime().addJITProperty(name, value);
    }
}

