/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageBuilder;
import com.ibm.dtfj.javacore.builder.IImageBuilderFactory;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.IErrorListener;
import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.parser.IParserController;
import com.ibm.dtfj.javacore.parser.framework.parser.ISectionParser;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.IScannerManager;
import com.ibm.dtfj.javacore.parser.framework.scanner.ScannerException;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ParserController
implements IParserController {
    private List fFramework;
    private IErrorListener fListener;
    private IImageBuilderFactory fImageBuilderFactory;
    private static final String DEFAULT_IMAGE_BUILDER = "default_image_builder";
    private static final String DEFAULT_IMAGE_ADDRESS_SPACE_BUILDER = "default_image_address_space_builder";
    private static final String DEFAULT_IMAGE_PROCESS_BUILDER = "default_image_process_builder";
    private static final String DEFAULT_JAVA_RUNTIME_BUILDER = "default_java_runtime_builder";

    public ParserController(List framework, IImageBuilderFactory imageBuilderFactory) throws ParserException {
        if (imageBuilderFactory == null) {
            throw new ParserException("Must pass a valid image builder factory");
        }
        this.fFramework = framework;
        this.fImageBuilderFactory = imageBuilderFactory;
    }

    public Image parse(IScannerManager scannerManager) throws ParserException {
        ILookAheadBuffer lookAhead = scannerManager.getLookAheadBuffer();
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 1; i <= 2 && i <= lookAhead.maxDepth(); ++i) {
                IParserToken token = lookAhead.lookAhead(i);
                if (token == null) continue;
                sb.append(token.getValue());
            }
        }
        catch (IOException e) {
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (ScannerException e) {
            throw new ParserException(e);
        }
        sb.setLength(Math.min(300, sb.length()));
        String first = sb.toString();
        IImageBuilder imageBuilder = null;
        try {
            imageBuilder = this.generateImageBuilder();
        }
        catch (BuilderFailureException e) {
            throw new ParserException(e);
        }
        boolean anyMatched = false;
        try {
            lookAhead.init();
            Iterator it = this.fFramework.iterator();
            while (it.hasNext()) {
                this.processUnknownData(lookAhead);
                ISectionParser sectionParser = (ISectionParser)it.next();
                sectionParser.readIntoDTFJ(lookAhead, imageBuilder);
                Iterator errors = sectionParser.getErrors();
                if (this.fListener != null && errors.hasNext()) {
                    while (errors.hasNext()) {
                        this.fListener.handleEvent(errors.next().toString());
                    }
                }
                anyMatched |= sectionParser.anyMatched();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ScannerException e) {
            throw new ParserException(e);
        }
        if (!anyMatched) {
            throw new ParserException("Not a javacore file. First line: " + first);
        }
        return imageBuilder.getImage();
    }

    private void processUnknownData(ILookAheadBuffer lookAheadBuffer) throws IOException, ScannerException {
        J9TagManager tagManager = J9TagManager.getCurrent();
        boolean stop = false;
        while (!lookAheadBuffer.allConsumed() && !stop) {
            IParserToken token = lookAheadBuffer.lookAhead(1);
            if (token != null) {
                String type = token.getType();
                if (!tagManager.hasTag(type) || tagManager.isTagInSection(type, "common")) {
                    lookAheadBuffer.consume();
                    continue;
                }
                stop = true;
                continue;
            }
            lookAheadBuffer.consume();
        }
    }

    private IImageBuilder generateImageBuilder() throws BuilderFailureException {
        IImageBuilder imageBuilder = this.fImageBuilderFactory.generateImageBuilder(DEFAULT_IMAGE_BUILDER);
        IImageAddressSpaceBuilder addressSpace = imageBuilder.generateAddressSpaceBuilder(DEFAULT_IMAGE_ADDRESS_SPACE_BUILDER);
        IImageProcessBuilder processBuilder = addressSpace.generateImageProcessBuilder(DEFAULT_IMAGE_PROCESS_BUILDER);
        processBuilder.generateJavaRuntimeBuilder(DEFAULT_JAVA_RUNTIME_BUILDER);
        return imageBuilder;
    }

    public void addErrorListener(IErrorListener listener) {
        this.fListener = listener;
    }
}

