/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.memory;

import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.memory.IMemoryTypes;

public class MemorySectionParser
extends SectionParser
implements IMemoryTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public MemorySectionParser() {
        super("MEMINFO");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        if (this.fImageAddressSpaceBuilder != null) {
            this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        }
        this.memInfo();
    }

    private void memInfo() throws ParserException {
        IAttributeValueMap results = null;
        results = this.processTagLineOptional("1STHEAPALLOC");
        results = this.processTagLineOptional("1STHEAPFREE");
        while ((results = this.processTagLineOptional("1STSEGTYPE")) != null) {
            String segName = results.getTokenValue("memory_segment_name");
            while ((results = this.processTagLineOptional("1STSEGMENT")) != null) {
                long tailSize;
                long freeSize;
                long headSize;
                long id = results.getLongValue("memory_segment_id");
                String name = id != -1L ? segName + " segment 0x" + Long.toHexString(id) : segName;
                long head = results.getLongValue("memory_segment_head");
                long size = results.getLongValue("memory_segment_size");
                long free = results.getLongValue("memory_segment_free");
                long tail = results.getLongValue("memory_segment_tail");
                if (head != -1L && free != -1L && (headSize = free - head) != 0L) {
                    this.fImageAddressSpaceBuilder.addImageSection(name + " head", head, headSize);
                }
                if (free != -1L && tail != -1L && (freeSize = tail - free) != 0L) {
                    this.fImageAddressSpaceBuilder.addImageSection(name + " free", free, freeSize);
                }
                if (head == -1L || tail == -1L || size == -1L || (tailSize = head + size - tail) == 0L) continue;
                this.fImageAddressSpaceBuilder.addImageSection(name + " tail", tail, tailSize);
            }
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

