/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.thread.IThreadTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ThreadSectionParser
extends SectionParser
implements IThreadTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;

    public ThreadSectionParser() {
        super("THREADS");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.currentThreadInfoSubsection();
        this.allThreadInfoSubsection();
    }

    protected void currentThreadInfoSubsection() throws ParserException {
        if (this.processTagLineOptional("1XMCURTHDINFO") != null) {
            this.threadInfo(true, true);
        }
    }

    protected void allThreadInfoSubsection() throws ParserException {
        this.processTagLineRequired("1XMTHDINFO");
        IAttributeValueMap results = this.processTagLineOptional("2XMFULLTHDDUMP");
        if (results != null) {
            int pointerSize = results.getIntValue("pointer_size");
            this.fImageProcessBuilder.setPointerSize(pointerSize);
        }
        this.threadInfo(true, false);
    }

    protected void threadInfo(boolean buildModel, boolean currentThread) throws ParserException {
        IAttributeValueMap results = null;
        int currentLineNumber = this.getCurrentFileLineNumber();
        results = this.processTagLineRequired("3XMTHREADINFO");
        if (results != null) {
            this.processThreadandStackTrace(results, buildModel, currentThread, currentLineNumber);
            if (!currentThread) {
                while ((results = this.processTagLineOptional("3XMTHREADINFO")) != null) {
                    this.processThreadandStackTrace(results, buildModel, false, currentLineNumber);
                }
            }
        }
    }

    protected int processThreadandStackTrace(IAttributeValueMap javaThreadResults, boolean buildModel, boolean currentThread, int currentLineNumber) throws ParserException {
        IAttributeValueMap nativeStack;
        JavaThread javaThread = null;
        IAttributeValueMap nativeResults = this.processTagLineOptional("3XMTHREADINFO1");
        ArrayList<IAttributeValueMap> nativeStacks = new ArrayList<IAttributeValueMap>();
        while ((nativeStack = this.processTagLineOptional("3XMTHREADINFO2")) != null) {
            nativeStacks.add(nativeStack);
        }
        IAttributeValueMap blockerInfo = this.processTagLineOptional("3XMTHREADBLOCK");
        IAttributeValueMap cpuTimes = this.processTagLineOptional("3XMCPUTIME");
        if (buildModel) {
            javaThread = this.addThread(javaThreadResults, nativeResults, nativeStacks, blockerInfo, cpuTimes, currentLineNumber);
        }
        long imageThreadID = nativeResults != null ? nativeResults.getLongValue("native_thread_id") : javaThreadResults.getLongValue("native_thread_id");
        long tid = javaThreadResults.getLongValue("vm_thread_id");
        if (imageThreadID == -1L) {
            imageThreadID = tid;
        }
        this.parseStackTrace(javaThread, currentLineNumber, buildModel);
        this.parseNativeStackTrace(imageThreadID, buildModel);
        if (currentThread) {
            this.fImageProcessBuilder.setCurrentThreadID(imageThreadID);
        }
        return this.getCurrentFileLineNumber();
    }

    private JavaThread addThread(IAttributeValueMap javaThreadResults, IAttributeValueMap nativeResults, List nativeStacks, IAttributeValueMap blockerInfo, IAttributeValueMap cpuTimes, int currentFileLineNumber) throws ParserException {
        String vmthread;
        long javaObjID;
        long imageThreadID = nativeResults != null ? nativeResults.getLongValue("native_thread_id") : javaThreadResults.getLongValue("native_thread_id");
        long tid = javaThreadResults.getLongValue("vm_thread_id");
        if (imageThreadID == -1L) {
            imageThreadID = tid;
        }
        ImageThread imageThread = null;
        JavaThread javaThread = null;
        String threadName = javaThreadResults.getTokenValue("java_thread_name");
        if (threadName != null && threadName.length() >= 2) {
            threadName = threadName.substring(1, threadName.length() - 1);
        }
        String threadState = javaThreadResults.getTokenValue("java_thread_state");
        int threadPriority = javaThreadResults.getIntValue("vm_thread_priority");
        long abstractThreadID = javaThreadResults.getLongValue("abstract_thread_id");
        Properties properties = new Properties();
        if (abstractThreadID != -1L) {
            this.addAsProperty(properties, "abstract_thread_id", "0x" + Long.toHexString(abstractThreadID));
        }
        if (nativeResults != null) {
            this.addAsProperty(properties, "native_thread_priority", nativeResults.getTokenValue("native_thread_priority"));
            this.addAsProperty(properties, "native_thread_policy", nativeResults.getTokenValue("native_thread_policy"));
            this.addAsProperty(properties, "scope", nativeResults.getTokenValue("scope"));
            this.addAsProperty(properties, "vm_thread_state", nativeResults.getTokenValue("vm_thread_state"));
            this.addAsProperty(properties, "vm_thread_flags", nativeResults.getTokenValue("vm_thread_flags"));
        }
        if (cpuTimes != null) {
            this.addAsProperty(properties, "cpu_time_total", cpuTimes.getTokenValue("cpu_time_total"));
            this.addAsProperty(properties, "cpu_time_user", cpuTimes.getTokenValue("cpu_time_user"));
            this.addAsProperty(properties, "cpu_time_system", cpuTimes.getTokenValue("cpu_time_system"));
        }
        String blockerObjectClassName = null;
        long blockerObjectAddress = -1L;
        if (blockerInfo != null) {
            blockerObjectClassName = blockerInfo.getTokenValue("blocker_object_full_java_name");
            blockerObjectAddress = blockerInfo.getLongValue("blocker_object_address");
        }
        if ((javaObjID = javaThreadResults.getLongValue("java_thread_obj")) == -1L && nativeResults == null && (vmthread = javaThreadResults.getTokenValue("vm_thread_id")) != null && !vmthread.startsWith("0x0")) {
            javaObjID = tid;
        }
        try {
            imageThread = this.fImageProcessBuilder.addImageThread(imageThreadID, abstractThreadID, properties);
            if (threadName != null || tid != -1L) {
                javaThread = this.fRuntimeBuilder.addJavaThread(imageThread, threadName, tid, abstractThreadID, javaObjID, -1L, threadState, threadPriority, blockerObjectAddress, blockerObjectClassName);
            }
        }
        catch (BuilderFailureException e) {
            this.handleErrorAtLineNumber(currentFileLineNumber, "Failed to add thread: " + threadName + " " + imageThreadID, e);
        }
        for (IAttributeValueMap stackInfo : nativeStacks) {
            long from = stackInfo.getLongValue("native_stack_from");
            long to = stackInfo.getLongValue("native_stack_to");
            long size = stackInfo.getLongValue("native_stack_size");
            if (from == -1L || size == -1L) continue;
            ImageSection section = this.fImageAddressSpaceBuilder.addImageSection("Native stack section", from, size);
            this.fImageProcessBuilder.addImageStackSection(imageThread, section);
        }
        return javaThread;
    }

    private void parseStackTrace(JavaThread javaThread, int currentFileLineNumber, boolean buildModel) throws ParserException {
        IAttributeValueMap stackTraceResults = null;
        currentFileLineNumber = this.getCurrentFileLineNumber();
        this.processTagLineOptional("3XMTHREADINFO3");
        while ((stackTraceResults = this.processTagLineOptional("4XESTACKTRACE")) != null) {
            if (javaThread == null) continue;
            this.addStackTrace(stackTraceResults, javaThread, currentFileLineNumber);
            currentFileLineNumber = this.getCurrentFileLineNumber();
        }
        this.sovOnlyRules("3XMTHREADINFO");
    }

    private void addStackTrace(IAttributeValueMap stackTraceResults, JavaThread javaThread, int fileLineNumber) throws ParserException {
        if (stackTraceResults == null) {
            return;
        }
        String className = stackTraceResults.getTokenValue("full_location_name");
        String methodName = stackTraceResults.getTokenValue("method_name");
        String methodType = stackTraceResults.getTokenValue("stacktrace_method_type");
        String classFile = null;
        String compilationLevel = null;
        int lineNumber = -1;
        if (methodType.equals("stacktrace_java_method")) {
            classFile = stackTraceResults.getTokenValue("class_file_name");
            compilationLevel = stackTraceResults.getTokenValue("comp_level");
            lineNumber = stackTraceResults.getIntValue("stacktrace_line_number");
        }
        if (methodType.equals("stacktrace_native_method")) {
            classFile = "Native Method";
        }
        try {
            this.fRuntimeBuilder.addJavaStackFrame(javaThread, className, classFile, methodName, methodType, compilationLevel, lineNumber);
        }
        catch (BuilderFailureException e) {
            this.handleErrorAtLineNumber(fileLineNumber, "Failed to add stack frame: " + className + "." + methodName + " " + lineNumber, e);
        }
    }

    private void parseNativeStackTrace(long threadID, boolean buildModel) throws ParserException {
        IAttributeValueMap results = null;
        this.processTagLineOptional("3XMTHREADINFO3");
        while ((results = this.processTagLineOptional("4XENATIVESTACK")) != null) {
            if (!buildModel) continue;
            String module = results.getTokenValue("stack_module");
            String routine = results.getTokenValue("stack_routine");
            long address = results.getLongValue("stack_proc_address");
            long routine_address = results.getLongValue("stack_routine_address");
            long routine_offset = results.getLongValue("stack_routine_offset");
            long module_offset = results.getLongValue("stack_module_offset");
            String file = results.getTokenValue("stack_file");
            int line = results.getIntValue("stack_line");
            if (routine_address == -1L && address != -1L && routine_offset != -1L) {
                routine_address = address - routine_offset;
            } else if (routine_offset == -1L && address != -1L && routine_address != -1L) {
                routine_offset = address - routine_address;
            } else if (address == -1L && routine_offset != -1L && routine_address != -1L) {
                address = routine_address + routine_offset;
            }
            String name = module != null ? module : "";
            if (file != null) {
                name = name + "(" + file;
                if (line != -1) {
                    name = name + ":" + line;
                }
                name = name + ")";
            }
            if (module != null) {
                ImageModule mod = this.fImageProcessBuilder.addLibrary(module);
                if (address != -1L && module_offset != -1L) {
                    String modAddress = "0x" + Long.toHexString(address - module_offset);
                    this.fImageProcessBuilder.addProperty(mod, "Load address", modAddress);
                }
                if (routine != null && address != -1L && routine_offset != -1L && routine_address != -1L) {
                    this.fImageProcessBuilder.addRoutine(mod, routine, routine_address);
                    name = name + "::" + routine + (routine_offset >= 0L ? "+" : "-") + routine_offset;
                } else if (routine_offset != -1L) {
                    name = name + (routine_offset >= 0L ? "+" : "-") + routine_offset;
                } else if (address != -1L) {
                    name = name + "::0x" + Long.toHexString(address);
                }
            } else {
                name = routine != null ? (routine_offset != -1L ? "::" + routine + (routine_offset >= 0L ? "+" : "-") + routine_offset : "::" + routine) : (address != -1L ? "::0x" + Long.toHexString(address) : null);
            }
            this.fImageProcessBuilder.addImageStackFrame(threadID, name, 0L, address);
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

