/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaMonitor;
import com.ibm.dtfj.phd.PHDCorruptJavaThread;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImageProcess;
import com.ibm.dtfj.phd.PHDJavaClass;
import com.ibm.dtfj.phd.PHDJavaClassLoader;
import com.ibm.dtfj.phd.PHDJavaHeap;
import com.ibm.dtfj.phd.PHDJavaMethod;
import com.ibm.dtfj.phd.PHDJavaMonitor;
import com.ibm.dtfj.phd.PHDJavaObject;
import com.ibm.dtfj.phd.PHDJavaThread;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PHDJavaRuntime
implements JavaRuntime {
    private final List<PHDJavaHeap> heaps = new ArrayList<PHDJavaHeap>();
    private final LinkedHashMap<JavaObject, PHDJavaClassLoader> loaders = new LinkedHashMap();
    private final LinkedHashMap<JavaThread, JavaThread> threads = new LinkedHashMap();
    private final ArrayList<JavaMonitor> monitors = new ArrayList();
    private final HashMap<Long, JavaClass> classIdCache = new HashMap();
    private final HashMap<String, JavaClass> classNameCache = new HashMap();
    private final HashMap<Long, JavaObject> extraObjectsCache = new HashMap();
    static final String[] arrayTypeName = new String[]{"[Z", "[C", "[F", "[D", "[B", "[S", "[I", "[J"};
    private final JavaClass[] arrayClasses = new JavaClass[arrayTypeName.length];
    private static final long[] NOREFS = new long[0];
    private final ImageAddressSpace space;
    private final JavaRuntime metaJavaRuntime;
    private final PHDImageProcess process;
    private String full_version;
    long minAddress;
    long maxAddress;
    long minClassAddress;
    long maxClassAddress;
    long maxObjClass;
    int maxObjLen;
    int minInstanceSize;
    private long compressAddressBase1;
    private long compressAddressTop1;
    private long compressAddressBase2;
    private int compressIndexBase1;
    private int compressIndexBase2;
    private int compressShift;
    private long nextClsAddr;

    PHDJavaRuntime(ImageInputStream stream, PHDImage parentImage, ImageAddressSpace space, PHDImageProcess process, JavaRuntime metaJavaRuntime) throws IOException {
        this.space = space;
        this.process = process;
        this.metaJavaRuntime = metaJavaRuntime;
        HeapdumpReader reader = new HeapdumpReader(stream, parentImage);
        this.heaps.add(new PHDJavaHeap(stream, parentImage, space, this));
        PHDJavaClassLoader loader = new PHDJavaClassLoader(stream, parentImage, space, this);
        this.processData(reader, parentImage, loader);
        this.findLoaders(reader);
        this.initClassCache();
        this.initMonitors();
        this.initThreads();
    }

    PHDJavaRuntime(File file, PHDImage parentImage, ImageAddressSpace space, PHDImageProcess process, JavaRuntime metaJavaRuntime) throws IOException {
        this.space = space;
        this.process = process;
        this.metaJavaRuntime = metaJavaRuntime;
        HeapdumpReader reader = new HeapdumpReader(file, parentImage);
        this.heaps.add(new PHDJavaHeap(file, parentImage, space, this));
        PHDJavaClassLoader loader = new PHDJavaClassLoader(file, parentImage, space, this);
        this.processData(reader, parentImage, loader);
        this.findLoaders(reader);
        this.initClassCache();
        this.initMonitors();
        this.initThreads();
    }

    private void processData(HeapdumpReader reader, PHDImage parentImage, PHDJavaClassLoader loader) throws IOException {
        int i;
        this.full_version = reader.full_version();
        reader.close();
        reader = null;
        this.minAddress = loader.minAddress;
        this.maxAddress = loader.maxAddress;
        this.minClassAddress = loader.minClassAddress;
        this.maxClassAddress = loader.maxClassAddress;
        this.minInstanceSize = loader.minInstanceSize;
        this.maxObjClass = loader.maxObjClass;
        this.maxObjLen = loader.maxObjLen;
        this.compressAddressBase1 = Math.min(this.minAddress, this.minClassAddress);
        this.compressAddressTop1 = Math.min(this.maxAddress, this.maxClassAddress);
        long l1 = Math.max(this.minAddress, this.maxClassAddress);
        long l2 = Math.max(this.minClassAddress, this.maxAddress);
        this.compressAddressBase2 = Math.min(l1, l2);
        for (i = 0; i < 10 && (1L << i & loader.bitsAddress) == 0L; ++i) {
        }
        this.compressShift = i;
        this.compressIndexBase1 = Integer.MIN_VALUE;
        this.compressIndexBase2 = (int)(this.compressAddressTop1 - this.compressAddressBase1 >>> this.compressShift) + this.compressIndexBase1 + 1;
        this.loaders.put(null, loader);
        for (int j = 0; j < arrayTypeName.length; ++j) {
            this.arrayClasses[j] = this.findClass(arrayTypeName[j]);
        }
        this.prepThreads();
        this.prepMonitors();
        this.prepClassLoaders();
    }

    public Iterator<JavaMethod> getCompiledMethods() {
        return Collections.emptyList().iterator();
    }

    public Iterator<? extends JavaHeap> getHeaps() {
        return this.heaps.iterator();
    }

    public Iterator<? extends JavaClassLoader> getJavaClassLoaders() {
        return this.loaders.values().iterator();
    }

    public ImagePointer getJavaVM() throws CorruptDataException {
        long addr = 0L;
        if (this.metaJavaRuntime != null) {
            addr = this.metaJavaRuntime.getJavaVM().getAddress();
        }
        return this.space.getPointer(addr);
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this.metaJavaRuntime != null) {
            return this.metaJavaRuntime.getJavaVMInitArgs();
        }
        throw new DataUnavailable();
    }

    public Iterator<JavaMonitor> getMonitors() {
        return this.monitors.iterator();
    }

    public Iterator<? extends JavaThread> getThreads() {
        return this.threads.values().iterator();
    }

    public Object getTraceBuffer(String arg0, boolean arg1) throws CorruptDataException {
        throw new CorruptDataException((CorruptData)new PHDCorruptData("No trace data", null));
    }

    public String getFullVersion() throws CorruptDataException {
        return this.full_version;
    }

    public String getVersion() throws CorruptDataException {
        if (this.metaJavaRuntime != null) {
            return this.metaJavaRuntime.getVersion();
        }
        return this.getFullVersion();
    }

    public Iterator<JavaReference> getHeapRoots() {
        return Collections.emptyList().iterator();
    }

    public JavaObject getObjectAtAddress(ImagePointer address) throws CorruptDataException, IllegalArgumentException, MemoryAccessException, DataUnavailable {
        JavaObject jo;
        long addr = address.getAddress();
        JavaClass cls = this.findClass(addr);
        if (cls != null && (jo = cls.getObject()) != null && address.equals(jo.getID())) {
            return jo;
        }
        jo = this.extraObjectsCache.get(addr);
        if (jo != null) {
            return jo;
        }
        for (PHDJavaHeap heap : this.heaps) {
            try {
                jo = heap.getCachedObjectAtAddress(address, false);
            }
            catch (IOException e) {
                throw new DataUnavailable("The requested object could not be read from the PHD file");
            }
            if (jo == null) continue;
            return jo;
        }
        jo = new PHDJavaObject.Builder(this.heaps.get(0), addr, null, 4, -1).build();
        return jo;
    }

    private void initClassCache() {
        for (PHDJavaClassLoader ldr : this.loaders.values()) {
            Iterator<JavaClass> it = ldr.getDefinedClasses();
            while (it.hasNext()) {
                JavaClass cls = it.next();
                ImagePointer ip = cls.getID();
                if (ip != null) {
                    this.classIdCache.put(ip.getAddress(), cls);
                    continue;
                }
                for (long l = 1L; l <= this.lastDummyClassAddr(); ++l) {
                    if (!cls.equals(ldr.findClass(l))) continue;
                    this.classIdCache.put(l, cls);
                }
            }
        }
    }

    JavaClass findClass(long id) {
        JavaClass cls = this.classIdCache.isEmpty() ? this.findClassUncached(id) : this.classIdCache.get(id);
        return cls;
    }

    private JavaClass findClassUncached(long id) {
        for (PHDJavaClassLoader ldr : this.loaders.values()) {
            JavaClass cls = ldr.findClass(id);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    JavaClass findArrayOfClass(long id) {
        JavaClass cl1 = this.findClass(id);
        if (cl1 != null) {
            try {
                PHDJavaClassLoader ldr;
                JavaClass cls;
                JavaClassLoader jcl = cl1.getClassLoader();
                if (jcl instanceof PHDJavaClassLoader && (cls = (ldr = (PHDJavaClassLoader)jcl).findArrayOfClass(id)) != null) {
                    return cls;
                }
            }
            catch (CorruptDataException e) {
                // empty catch block
            }
        }
        return this.findArrayOfClass2(id);
    }

    private JavaClass findArrayOfClass2(long id) {
        for (PHDJavaClassLoader ldr : this.loaders.values()) {
            JavaClass cls = ldr.findArrayOfClass(id);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    JavaClass findArrayOfType(int id) {
        return this.arrayClasses[id];
    }

    JavaClass arrayOf(long id, long[] refs, int adjustLen) throws CorruptDataException {
        JavaClass jcl = adjustLen == 1 ? (refs.length > 0 ? this.findClass(refs[0]) : null) : this.findArrayOfClass(id);
        return jcl;
    }

    JavaClass arrayOf(long id, LongEnumeration refs, int adjustLen) throws CorruptDataException {
        JavaClass jcl = adjustLen == 1 ? (refs.hasMoreElements() ? this.findClass(refs.nextLong()) : null) : this.findArrayOfClass(id);
        return jcl;
    }

    JavaClass findClass(String clsName) {
        JavaClass cls = this.classNameCache.get(clsName);
        if (cls == null && (cls = this.findClassUncached(clsName)) != null) {
            this.classNameCache.put(clsName, cls);
        }
        return cls;
    }

    JavaClass findClassUncached(String clsName) {
        for (PHDJavaClassLoader ldr : this.loaders.values()) {
            try {
                JavaClass cls = ldr.findClass(clsName);
                if (cls == null) continue;
                return cls;
            }
            catch (CorruptDataException e) {
            }
        }
        return null;
    }

    Object convertRefs(LongEnumeration refs, int skipped) {
        int nrefs = refs.numberOfElements() - skipped;
        int[] ri = this.noCompress() ? null : new int[nrefs];
        long[] rl = this.noCompress() ? new long[nrefs] : null;
        for (int i = 0; i < nrefs; ++i) {
            long l = refs.nextLong();
            if (ri != null) {
                ri[i] = this.compressAddress(l);
                if (this.expandAddress(ri[i]) == l) continue;
                rl = new long[ri.length];
                for (int j = 0; j < i; ++j) {
                    rl[j] = this.expandAddress(ri[j]);
                }
                rl[i] = l;
                ri = null;
                continue;
            }
            rl[i] = l;
        }
        if (ri != null) {
            return ri;
        }
        return rl;
    }

    Object convertRefs(long[] refs, int skipped) {
        int nrefs = refs.length - skipped;
        if (nrefs <= 0) {
            return refs;
        }
        int[] ri = this.noCompress() ? null : new int[nrefs];
        long[] rl = this.noCompress() ? new long[nrefs] : null;
        for (int i = 0; i < nrefs; ++i) {
            long l = refs[skipped + i];
            if (ri != null) {
                ri[i] = this.compressAddress(l);
                if (this.expandAddress(ri[i]) == l) continue;
                rl = new long[ri.length];
                for (int j = 0; j < i; ++j) {
                    rl[j] = this.expandAddress(ri[j]);
                }
                rl[i] = l;
                ri = null;
                continue;
            }
            rl[i] = l;
        }
        if (ri != null) {
            return ri;
        }
        return rl;
    }

    boolean noCompress() {
        return this.compressIndexBase1 == 0;
    }

    int compressAddress(long addr) {
        int ret = addr <= this.compressAddressTop1 ? (int)((addr - this.compressAddressBase1 >>> this.compressShift) + (long)this.compressIndexBase1) : (int)((addr - this.compressAddressBase2 >>> this.compressShift) + (long)this.compressIndexBase2);
        return ret;
    }

    long expandAddress(int ad) {
        long ret = ad < this.compressIndexBase2 ? ((long)ad - (long)this.compressIndexBase1 << this.compressShift) + this.compressAddressBase1 : ((long)ad - (long)this.compressIndexBase2 << this.compressShift) + this.compressAddressBase2;
        return ret;
    }

    boolean is64Bit() {
        return this.process.getPointerSize() == 64;
    }

    int pointerSize() {
        return this.is64Bit() && (this.minInstanceSize == 0 || this.minInstanceSize > 16) ? 8 : 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findLoaders(HeapdumpReader newreader) throws IOException {
        JavaClassLoader jcl2;
        JavaClass j1;
        final PHDJavaClassLoader boot = this.loaders.get(null);
        final JavaClass jlc = this.findClass("java/lang/Class");
        final long jlcAddress = jlc == null || jlc.getID() == null ? 0L : jlc.getID().getAddress();
        JavaClass jcl = this.findClass("java/lang/ClassLoader");
        final HashMap<Long, JavaClass> classLoaderClasses = new HashMap<Long, JavaClass>();
        Iterator<JavaClass> it = boot.getDefinedClasses();
        while (it.hasNext()) {
            JavaClass cls = it.next();
            if (cls instanceof CorruptData) continue;
            try {
                HashSet<JavaClass> supers = new HashSet<JavaClass>();
                for (JavaClass j12 = cls; j12 != null && supers.add(j12); j12 = j12.getSuperclass()) {
                    ImagePointer ip;
                    if (!j12.equals(jcl) && (cls.getSuperclass() != null || j12.isArray() || !j12.getName().endsWith("ClassLoader")) || (ip = cls.getID()) == null) continue;
                    classLoaderClasses.put(ip.getAddress(), cls);
                }
            }
            catch (CorruptDataException e) {
            }
        }
        final int[] onHeapClasses = new int[1];
        final PHDJavaHeap heap = this.heaps.get(0);
        final HashMap classObjects = new HashMap();
        final int adjustLen = newreader.version() == 4 && newreader.isJ9() ? 1 : 0;
        try {
            newreader.parse(new PortableHeapDumpListener(){

                public void classDump(long address, long superAddress, String name, int size, int flags, int hashCode, LongEnumeration refs, boolean isPacked) throws Exception {
                }

                public void objectArrayDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, int length, long instanceSize, boolean isPacked, boolean isNativePacked) throws Exception {
                    if (PHDJavaRuntime.this.extraObjectsCache.containsKey(address)) {
                        PHDJavaObject jo = new PHDJavaObject.Builder(heap, address, PHDJavaRuntime.this.arrayOf(classAddress, refs, adjustLen), flags, hashCode).length(length - adjustLen).instanceSize(instanceSize).build();
                        PHDJavaRuntime.this.extraObjectsCache.put(address, jo);
                    }
                }

                public void objectDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, boolean isPacked, boolean isNativePacked, long instanceSize) throws Exception {
                    PHDJavaObject jo;
                    JavaClass cls = (JavaClass)classLoaderClasses.get(classAddress);
                    if (cls != null) {
                        jo = new PHDJavaObject.Builder(heap, address, cls, flags, hashCode).refs(refs, 0).length(-1).instanceSize(instanceSize).isPacked(isPacked).isNativePacked(isNativePacked).build();
                        PHDJavaClassLoader load = new PHDJavaClassLoader(jo);
                        PHDJavaRuntime.this.loaders.put(jo, load);
                    } else if (classAddress == jlcAddress) {
                        if (boot.findClass(address) == null) {
                            onHeapClasses[0] = onHeapClasses[0] + 1;
                        }
                        jo = new PHDJavaObject.Builder(heap, address, jlc, flags, hashCode).refs(refs, 0).length(-1).instanceSize(instanceSize).isPacked(isPacked).isNativePacked(isNativePacked).build();
                        classObjects.put(address, jo);
                    } else {
                        jo = null;
                    }
                    if (PHDJavaRuntime.this.extraObjectsCache.containsKey(address)) {
                        if (jo == null) {
                            jo = new PHDJavaObject.Builder(heap, address, PHDJavaRuntime.this.findClass(classAddress), flags, hashCode).refs(refs, 0).length(-1).build();
                        }
                        PHDJavaRuntime.this.extraObjectsCache.put(address, jo);
                    }
                }

                public void primitiveArrayDump(long address, int type, int length, int flags, int hashCode, long instanceSize) throws Exception {
                    if (PHDJavaRuntime.this.extraObjectsCache.containsKey(address)) {
                        PHDJavaObject jo = new PHDJavaObject.Builder(heap, address, PHDJavaRuntime.this.findArrayOfType(type), flags, hashCode).refsAsArray(NOREFS, 0).length(length).instanceSize(instanceSize).build();
                        PHDJavaRuntime.this.extraObjectsCache.put(address, jo);
                    }
                }
            });
        }
        catch (Exception e) {
        }
        finally {
            newreader.close();
            newreader = null;
        }
        PHDJavaClassLoader boot2 = null;
        int foundLoader = 0;
        int notFoundLoader = 0;
        int loaderJavaLangCount = 0;
        boolean useFirstObjectRefAsLoader = onHeapClasses[0] == 0;
        Iterator<JavaClass> it2 = boot.getDefinedClasses();
        while (it2.hasNext()) {
            j1 = it2.next();
            PHDJavaClassLoader bestLoader = null;
            Iterator it22 = j1.getReferences();
            while (it22.hasNext()) {
                JavaReference jr = (JavaReference)it22.next();
                try {
                    long addr;
                    JavaObject jo2;
                    if (!jr.isObjectReference()) continue;
                    JavaObject jo = (JavaObject)jr.getTarget();
                    PHDJavaClassLoader newLoader = this.loaders.get(jo);
                    if (newLoader != null) {
                        if (bestLoader == null || !useFirstObjectRefAsLoader) {
                            bestLoader = newLoader;
                        }
                    } else if (onHeapClasses[0] > 0 && (jo2 = (JavaObject)classObjects.get(addr = jo.getID().getAddress())) != null) {
                        ((PHDJavaClass)j1).setJavaObject(jo2);
                    }
                    if (j1.isArray() || !useFirstObjectRefAsLoader || onHeapClasses[0] != 0) continue;
                    break;
                }
                catch (CorruptDataException e) {
                }
                catch (DataUnavailable e) {
                }
            }
            if (bestLoader != null) {
                ++foundLoader;
                bestLoader.prepareToMove(boot, j1);
                try {
                    if (boot2 == null && (j1.equals(jlc) || j1.equals(bestLoader.getObject().getJavaClass()))) {
                        boot2 = bestLoader;
                    }
                    if (boot2 == bestLoader && j1.getName().startsWith("java/lang/")) {
                        ++loaderJavaLangCount;
                    }
                }
                catch (CorruptDataException e) {}
            } else {
                ++notFoundLoader;
            }
            try {
                long addr;
                JavaObject jo2;
                JavaObject jo = j1.getObject();
                if (jo == null || (jo2 = (JavaObject)classObjects.get(addr = jo.getID().getAddress())) == null) continue;
                ((PHDJavaClass)j1).setJavaObject(jo2);
            }
            catch (CorruptDataException e) {}
        }
        if (loaderJavaLangCount < 5) {
            boot2 = null;
        }
        if (this.metaJavaRuntime != null) {
            Iterator i = this.metaJavaRuntime.getJavaClassLoaders();
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof CorruptData) continue;
                jcl2 = (JavaClassLoader)next;
                try {
                    JavaClass loaderClass;
                    ImagePointer addr;
                    JavaObject lo = jcl2.getObject();
                    if (lo == null || (addr = lo.getID()) == null) continue;
                    ImagePointer ip = this.space.getPointer(addr.getAddress());
                    JavaObject jo = this.getObjectAtAddress(ip);
                    PHDJavaClassLoader newLoader = this.loaders.get(jo);
                    if (newLoader == null) {
                        JavaClass javacoreLoaderClass;
                        try {
                            loaderClass = jo.getJavaClass();
                        }
                        catch (CorruptDataException e) {
                            loaderClass = null;
                        }
                        try {
                            javacoreLoaderClass = lo.getJavaClass();
                        }
                        catch (CorruptDataException e) {
                            javacoreLoaderClass = null;
                        }
                        if (loaderClass == null || javacoreLoaderClass == null || !loaderClass.isArray() && (loaderClass.getID() == null || javacoreLoaderClass.getID() == null || loaderClass.getID().getAddress() == javacoreLoaderClass.getID().getAddress())) {
                            newLoader = new PHDJavaClassLoader(jo);
                            this.loaders.put(jo, newLoader);
                        }
                    } else {
                        jo = newLoader.getObject();
                        loaderClass = jo.getJavaClass();
                    }
                    if (newLoader == null) continue;
                    Iterator i2 = jcl2.getDefinedClasses();
                    while (i2.hasNext()) {
                        JavaClass j13;
                        Object next2 = i2.next();
                        if (next2 instanceof CorruptData) continue;
                        JavaClass jc2 = (JavaClass)next2;
                        ImagePointer ip2 = jc2.getID();
                        if (ip2 != null) {
                            long claddr = ip2.getAddress();
                            j13 = boot.findClass(claddr);
                            if (j13 == null) {
                                j13 = boot.findClassUnique(jc2.getName());
                            } else {
                                try {
                                    j13.getName();
                                }
                                catch (CorruptDataException e) {
                                    try {
                                        String actualName = jc2.getName();
                                        PHDJavaClass pj1 = (PHDJavaClass)j13;
                                        pj1.setName(actualName);
                                    }
                                    catch (CorruptDataException e2) {}
                                }
                            }
                        } else {
                            j13 = boot.findClassUnique(jc2.getName());
                        }
                        if (j13 == null) continue;
                        newLoader.prepareToMove(boot, j13);
                        if (j13.equals(loaderClass) || j13.equals(jlc)) {
                            boot2 = newLoader;
                        }
                        Iterator i3 = jc2.getDeclaredMethods();
                        while (i3.hasNext()) {
                            Object next3 = i3.next();
                            if (next3 instanceof CorruptData) continue;
                            JavaMethod jm = (JavaMethod)next3;
                            PHDJavaClass pj1 = (PHDJavaClass)j13;
                            pj1.addMethod(new PHDJavaMethod(this.space, pj1, jm));
                        }
                    }
                }
                catch (CorruptDataException e) {
                }
                catch (DataUnavailable e) {
                }
                catch (MemoryAccessException e) {
                }
            }
        }
        it2 = boot.getDefinedClasses();
        while (it2.hasNext()) {
            j1 = it2.next();
            try {
                jcl2 = j1.getClassLoader();
                if (boot.equals(jcl2) || !(jcl2 instanceof PHDJavaClassLoader)) continue;
                this.transferClass(boot, (PHDJavaClassLoader)jcl2, j1);
            }
            catch (CorruptDataException e) {}
        }
        for (PHDJavaClassLoader loader : this.loaders.values()) {
            loader.initCache();
        }
        if (boot2 != null) {
            it2 = boot.getDefinedClasses();
            while (it2.hasNext()) {
                j1 = it2.next();
                boot2.prepareToMove(boot, j1);
                this.transferClass(boot, boot2, j1);
            }
            boot2.initCache();
            this.loaders.remove(null);
        } else {
            it2 = boot.getDefinedClasses();
            while (it2.hasNext()) {
                j1 = it2.next();
                JavaClass j2 = boot.setArrayType(this, boot, j1);
            }
            boot.initCache();
        }
    }

    private void transferClass(PHDJavaClassLoader from, PHDJavaClassLoader to, JavaClass j1) {
        to.move(from, j1, this.lastDummyClassAddr());
        JavaClass j2 = to.setArrayType(this, from, j1);
        if (j2 != null) {
            to.prepareToMove(from, j2);
            to.move(from, j2, this.lastDummyClassAddr());
        }
    }

    Iterator<JavaClass> getLoaderClasses(JavaObject jo) {
        PHDJavaClassLoader load = this.loaders.get(jo);
        if (load != null) {
            return load.getDefinedClasses();
        }
        return Collections.emptyList().iterator();
    }

    JavaThread getThread(JavaThread th) {
        if (!this.threads.containsKey(th)) {
            this.threads.put(th, new PHDJavaThread(this.space, this.process, this, th));
        }
        return this.threads.get(th);
    }

    private void prepThreads() {
        if (this.metaJavaRuntime != null) {
            PHDJavaClassLoader boot = this.loaders.get(null);
            Iterator it = this.metaJavaRuntime.getThreads();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof CorruptData) continue;
                JavaThread thr = (JavaThread)next;
                try {
                    JavaObject jo = thr.getObject();
                    this.saveExtraObject(boot, jo);
                }
                catch (CorruptDataException e) {}
            }
        }
    }

    private void saveExtraObject(PHDJavaClassLoader boot, JavaObject jo) {
        if (jo != null) {
            JavaClass cls;
            long addr = jo.getID().getAddress();
            try {
                cls = boot.findClassUnique(jo.getJavaClass().getName());
            }
            catch (CorruptDataException e) {
                cls = null;
            }
            PHDJavaObject jo2 = new PHDJavaObject.Builder(this.heaps.get(0), addr, cls, 4, -1).refsAsArray(NOREFS, 0).length(-3).build();
            this.extraObjectsCache.put(addr, jo2);
        }
    }

    private void initThreads() {
        if (this.metaJavaRuntime != null) {
            Iterator it = this.metaJavaRuntime.getThreads();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof CorruptData) {
                    PHDCorruptJavaThread thr = new PHDCorruptJavaThread(this.space, (CorruptData)next);
                    this.threads.put(thr, thr);
                    continue;
                }
                this.getThread((JavaThread)next);
            }
        }
    }

    private void prepMonitors() {
        if (this.metaJavaRuntime != null) {
            PHDJavaClassLoader boot = this.loaders.get(null);
            Iterator it = this.metaJavaRuntime.getMonitors();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof CorruptData) continue;
                JavaMonitor mon = (JavaMonitor)next;
                JavaObject jo = mon.getObject();
                this.saveExtraObject(boot, jo);
            }
        }
    }

    private void initMonitors() {
        if (this.metaJavaRuntime != null) {
            Iterator it = this.metaJavaRuntime.getMonitors();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof CorruptData) {
                    this.monitors.add(new PHDCorruptJavaMonitor(this.space, (CorruptData)next));
                    continue;
                }
                this.monitors.add(new PHDJavaMonitor(this.space, this, (JavaMonitor)next));
            }
        }
    }

    private void prepClassLoaders() {
        if (this.metaJavaRuntime != null) {
            PHDJavaClassLoader boot = this.loaders.get(null);
            Iterator it = this.metaJavaRuntime.getJavaClassLoaders();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof CorruptData) continue;
                JavaClassLoader load = (JavaClassLoader)next;
                try {
                    JavaObject jo = load.getObject();
                    this.saveExtraObject(boot, jo);
                }
                catch (CorruptDataException e) {}
            }
        }
    }

    long nextDummyClassAddr() {
        return ++this.nextClsAddr;
    }

    long lastDummyClassAddr() {
        return this.nextClsAddr;
    }

    public Iterator getMemoryCategories() throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemoryCategories");
    }

    public Iterator getMemorySections(boolean includeFreed) throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemorySections");
    }

    public boolean isJITEnabled() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support isJITEnabled");
    }

    public Properties getJITProperties() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getJITProperies");
    }

    public JavaObject getNestedPackedObject(JavaClass jc, ImagePointer packedDataAddress) throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getNestedPackedObject");
    }

    public JavaObject getNestedPackedArrayObject(JavaClass jc, ImagePointer packedDataAddress, int arrayLength) throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getNestedPackedArrayObject");
    }
}

