/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.CompressedFileManager;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class GZipFileManager
extends CompressedFileManager {
    public GZipFileManager(File file) {
        super(file);
    }

    public void extract(ManagedImageSource file, File todir) throws IOException {
        this.validateImageSource(file);
        this.extract(todir);
    }

    public ImageInputStream getStream(ManagedImageSource source) throws IOException {
        this.validateImageSource(source);
        return this.getStream();
    }

    private void validateImageSource(ManagedImageSource source) throws IOException {
        File archive = new File(source.getPath());
        if (!archive.equals(this.managedFile)) {
            throw new IOException("The specified Image Source : " + source.getArchive().getAbsolutePath() + " does not match the contents of " + this.managedFile.getAbsolutePath());
        }
    }

    public ImageInputStream getStream() throws IOException {
        FileInputStream fis = new FileInputStream(this.managedFile);
        GZIPInputStream gis = new GZIPInputStream(fis);
        return new MemoryCacheImageInputStream(gis);
    }

    public void extract(File todir) throws IOException {
        this.checkDirectoryToExtractTo(todir);
        FileInputStream fis = new FileInputStream(this.managedFile);
        GZIPInputStream gis = new GZIPInputStream(fis);
        File extractTo = new File(todir, this.managedFile.getName());
        extractTo.deleteOnExit();
        this.extractEntry(gis, extractTo);
    }
}

