/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandDescription;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCommand
implements ICommand {
    protected static final String nl = System.getProperty("line.separator");
    protected static final String COMMAND_FORMAT = "%-25s %-20s %s\n";
    protected static final String SUBCOMMAND_FORMAT = "%25s %-20s %s\n";
    private static final String KEY_ID = ":";
    private Map<String, CommandDescription> _commands = new LinkedHashMap<String, CommandDescription>();
    private Map<String, CommandDescription> _subCommands = new LinkedHashMap<String, CommandDescription>();
    private boolean isDirty = false;
    private Set<String> descriptions = new LinkedHashSet<String>();
    protected PluginConfig config;

    public CommandDescription addCommand(String name, String argDescription, String helpDescription) {
        this.isDirty = true;
        CommandDescription description = new CommandDescription(name, argDescription, helpDescription);
        this._commands.put(name.toLowerCase(), description);
        return description;
    }

    public void addSubCommand(String cmdname, String subname, String argDescription, String help) {
        this.isDirty = true;
        CommandDescription subCommand = new CommandDescription(subname, argDescription, help);
        for (CommandDescription cmd : this._commands.values()) {
            if (!cmd.getCommandName().toLowerCase().equals(cmdname.toLowerCase())) continue;
            subCommand.setParent(cmd);
        }
        this._subCommands.put(cmdname + KEY_ID + subname, subCommand);
    }

    @Override
    public boolean recognises(String command, IContext context) {
        return this._commands.containsKey(command.toLowerCase());
    }

    @Override
    public Collection<String> getCommandDescriptions() {
        if (this.isDirty) {
            for (CommandDescription cmd : this._commands.values()) {
                StringBuilder desc = new StringBuilder();
                desc.append(String.format(COMMAND_FORMAT, cmd.getCommandName(), cmd.getArgumentDescription(), cmd.getHelpDescription()));
                for (CommandDescription subcmd : this._subCommands.values()) {
                    if (subcmd.getParent() == null || !subcmd.getParent().getCommandName().equalsIgnoreCase(cmd.getCommandName())) continue;
                    desc.append(String.format(SUBCOMMAND_FORMAT, subcmd.getCommandName(), subcmd.getArgumentDescription(), subcmd.getHelpDescription()));
                }
                this.descriptions.add(desc.toString());
            }
        }
        return this.descriptions;
    }

    @Override
    public Collection<String> getCommandNames() {
        return this._commands.keySet();
    }

    @Override
    public PluginConfig getConfig() {
        return this.config;
    }

    public void setConfig(PluginConfig config) {
        this.config = config;
    }
}

