/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.Entry;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import java.util.Map;

public class DTFJPluginConfig
extends PluginConfig {
    protected String version = "1.*";
    protected boolean runtime = false;
    protected boolean image = false;
    protected String csv = null;

    public DTFJPluginConfig(Entry entry) {
        super(entry);
    }

    public void processAnnotations() {
        ClassInfo info = (ClassInfo)this.entry.getData();
        Annotation annotation = info.getAnnotation("Lcom/ibm/java/diagnostics/utils/plugins/DTFJPlugin;");
        if (annotation == null) {
            throw new IllegalArgumentException("The entry " + this.entry.getName() + " does not have the DTFJ plugin annotation");
        }
        Map<String, Object> values = annotation.getValues();
        for (String key : values.keySet()) {
            if (key.equals("version")) {
                this.version = (String)values.get(key);
            }
            if (key.equals("runtime")) {
                this.runtime = (Boolean)values.get(key);
            }
            if (key.equals("image")) {
                this.image = (Boolean)values.get(key);
            }
            if (!key.equals("cacheOutput")) continue;
            this.cacheOutput = (Boolean)values.get(key);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public boolean isImage() {
        return this.image;
    }

    public String toCSV() {
        if (this.csv == null) {
            ClassInfo info = (ClassInfo)this.entry.getData();
            StringBuilder builder = new StringBuilder();
            builder.append(info.getClassname());
            builder.append(',');
            builder.append(this.version);
            builder.append(",true,");
            builder.append(info.getURL().toString());
            builder.append(',');
            if (null != this.t) {
                builder.append(this.t.getClass().getName());
            }
            this.csv = builder.toString();
        }
        return this.csv;
    }

    public String toString() {
        return "DTFJ Plugin " + this.getClassName();
    }
}

