/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReaderFactory;
import com.ibm.j9ddr.corereaders.debugger.JniReader;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReaderFactory;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.tdump.TDumpReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class CoreReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final List<Class<? extends ICoreFileReader>> coreReaders;

    public static ICore readCoreFile(String path) throws IOException {
        Enum accruedResult = null;
        IOException thrown = null;
        for (Class<? extends ICoreFileReader> clazz : coreReaders) {
            try {
                ICoreFileReader reader = clazz.newInstance();
                ICoreFileReader.DumpTestResult result = reader.testDump(path);
                if (result == ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT) {
                    return reader.processDump(path);
                }
                accruedResult = result.accrue((ICoreFileReader.DumpTestResult)accruedResult);
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, "IllegalAccessException thrown creating " + clazz.getName(), e);
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, "Exception thrown creating " + clazz.getName(), e.getCause());
            }
            catch (InvalidDumpFormatException e) {
                logger.log(Level.WARNING, "InvalidDumpFormatException thrown creating " + clazz.getName(), e);
            }
            catch (IOException e) {
                if (thrown != null) continue;
                thrown = e;
            }
        }
        if (accruedResult == null) {
            if (thrown != null) {
                throw new IOException("I/O problems reading core file: " + thrown.getMessage());
            }
            throw new Error("No core file readers found");
        }
        switch (1.$SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult[accruedResult.ordinal()]) {
            case 1: {
                throw new FileNotFoundException("Could not find: " + new File(path).getAbsolutePath());
            }
            case 2: {
                throw new IOException("Dump: " + path + " not recognised by any core reader");
            }
        }
        throw new IllegalStateException("Unexpected state: " + accruedResult);
    }

    public static ICore readCoreFile(ImageInputStream in) throws IOException {
        Enum accruedResult = null;
        IOException thrown = null;
        for (Class<? extends ICoreFileReader> clazz : coreReaders) {
            try {
                ICoreFileReader reader = clazz.newInstance();
                ICoreFileReader.DumpTestResult result = reader.testDump(in);
                if (result == ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT) {
                    return reader.processDump(in);
                }
                accruedResult = result.accrue((ICoreFileReader.DumpTestResult)accruedResult);
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, "IllegalAccessException thrown creating " + clazz.getName(), e);
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, "Exception thrown creating " + clazz.getName(), e.getCause());
            }
            catch (InvalidDumpFormatException e) {
                logger.log(Level.WARNING, "InvalidDumpFormatException thrown creating " + clazz.getName(), e);
            }
            catch (IOException e) {
                if (thrown != null) continue;
                thrown = e;
            }
        }
        if (accruedResult == null) {
            if (thrown != null) {
                throw new IOException("I/O problems reading core file: " + thrown.getMessage());
            }
            throw new Error("No core file readers found");
        }
        switch (1.$SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult[accruedResult.ordinal()]) {
            case 2: {
                throw new IOException("Dump input stream : not recognised by any core reader");
            }
        }
        throw new IllegalStateException("Unexpected state: " + accruedResult);
    }

    public static byte[] getFileHeader(String path) throws IOException {
        FileImageInputStream iis = new FileImageInputStream(new File(path));
        return CoreReader.getFileHeader(iis);
    }

    public static byte[] getFileHeader(ImageInputStream iis) throws IOException {
        byte[] data = new byte[2048];
        try {
            iis.seek(0L);
            iis.readFully(data);
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            iis.seek(0L);
        }
        return data;
    }

    static {
        ArrayList<Class<AIXDumpReaderFactory>> localReaders = new ArrayList<Class<AIXDumpReaderFactory>>();
        localReaders.add(JniReader.class);
        localReaders.add(MiniDumpReader.class);
        localReaders.add(ELFDumpReaderFactory.class);
        localReaders.add(TDumpReader.class);
        localReaders.add(AIXDumpReaderFactory.class);
        coreReaders = Collections.unmodifiableList(localReaders);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult;

        static {
            $SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult = new int[ICoreFileReader.DumpTestResult.values().length];
            try {
                1.$SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult[ICoreFileReader.DumpTestResult.FILE_NOT_FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult[ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

