/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AIX64DumpReader
extends AIXDumpReader {
    private static final long THRDENTRY64_V1_SIZE = 424L;
    private static final long THRDENTRY64_V2_SIZE = 512L;
    private static final long THRDCTX64_V1 = 1000L;
    private static final long THRDCTX64_V2 = 1088L;
    private static final int GPR_COUNT = 32;
    private static final String VMID = "j9vmap64";
    private boolean hasVersionBeenDetermined = false;
    private long sizeofThreadCtx64 = 1000L;
    private long sizeofThreadEntry64 = 424L;

    public AIX64DumpReader(File file, ClosingFileReader fileReader) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = file;
        this.setReader(fileReader);
        this.readCore();
    }

    public AIX64DumpReader(ImageInputStream in) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = null;
        this.setReader(in);
        this.readCore();
    }

    public String getVMID() {
        return VMID;
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return this._fileReader.readInt();
    }

    @Override
    protected long userInfoOffset() {
        return 1216L;
    }

    @Override
    public boolean is64Bit() {
        return true;
    }

    @Override
    protected Map<String, Number> readRegisters(long threadOffset) throws IOException {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(threadOffset);
        }
        this._fileReader.seek(threadOffset + this.sizeofThreadEntry64);
        TreeMap<String, Number> registers = new TreeMap<String, Number>();
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, this.readLong());
        }
        registers.put("msr", this.readLong());
        registers.put("iar", this.readLong());
        registers.put("lr", this.readLong());
        registers.put("ctr", this.readLong());
        registers.put("cr", this.readInt());
        registers.put("xer", this.readInt());
        registers.put("fpscr", this.readInt());
        return registers;
    }

    public void calculateThreadStructureSizes(long threadOffset) {
        long address;
        try {
            this._fileReader.seek(threadOffset + 424L + 8L);
            address = this.readLong();
        }
        catch (IOException e) {
            return;
        }
        if (null == this.getProcess().getMemoryRangeForAddress(address)) {
            this.sizeofThreadEntry64 = 512L;
            this.sizeofThreadCtx64 = 1088L;
        } else {
            this.sizeofThreadEntry64 = 424L;
            this.sizeofThreadCtx64 = 1000L;
        }
        this.hasVersionBeenDetermined = true;
    }

    @Override
    protected long threadSize(long threadOffset) {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(threadOffset);
        }
        return this.sizeofThreadCtx64;
    }

    @Override
    protected long getStackPointerFrom(Map<String, Number> registers) {
        return (Long)registers.get("gpr1");
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return (Long)registers.get("iar");
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return (Long)registers.get("lr");
    }

    @Override
    protected int sizeofTopOfStack() {
        return 304;
    }

    @Override
    protected int pointerSize() {
        return 64;
    }

    @Override
    protected long readAddress() throws IOException {
        return this.readLong();
    }
}

