/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class AIXDumpReaderFactory
implements ICoreFileReader {
    public ICore processDump(String path) throws InvalidDumpFormatException, IOException {
        return AIXDumpReader.getReaderForFile(new File(path));
    }

    public ICoreFileReader.DumpTestResult testDump(String path) throws IOException {
        File dumpFile = new File(path);
        if (!dumpFile.exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        byte[] header = CoreReader.getFileHeader(path);
        return AIXDumpReader.isAIXDump(header, dumpFile.length()) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    public ICoreFileReader.DumpTestResult testDump(ImageInputStream in) throws IOException {
        byte[] header = CoreReader.getFileHeader(in);
        return AIXDumpReader.isAIXDump(header, Long.MAX_VALUE) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    public ICore processDump(ImageInputStream in) throws InvalidDumpFormatException, IOException {
        return AIXDumpReader.getReaderForFile(in);
    }
}

