/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import com.ibm.j9ddr.corereaders.memory.EnvironmentUtils;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.ProcessAddressSpace;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AIXProcessAddressSpace
extends ProcessAddressSpace {
    private AIXDumpReader reader;

    public AIXProcessAddressSpace(int pointerSizeBytes, ByteOrder byteOrder, AIXDumpReader core) {
        super(pointerSizeBytes, byteOrder, core);
        this.reader = core;
    }

    @Override
    public ICore getCore() {
        return this.reader;
    }

    @Override
    public String getCommandLine() throws CorruptDataException {
        return this.reader.getCommandLine();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AIXProcessAddressSpace)) {
            return false;
        }
        AIXProcessAddressSpace space = (AIXProcessAddressSpace)o;
        return this.reader.equals(space.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public Properties getEnvironmentVariables() throws CorruptDataException {
        return EnvironmentUtils.readEnvironment(this, this.reader.getEnvironmentHandle());
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        return this.reader.getExecutable();
    }

    public List<IModule> getModules() throws CorruptDataException {
        return this.reader.getModules();
    }

    @Override
    public long getProcessId() throws CorruptDataException {
        return this.reader.getProcessId();
    }

    public List<? extends IOSThread> getThreads() throws CorruptDataException {
        return this.reader.getThreads();
    }

    @Override
    public Platform getPlatform() {
        return Platform.AIX;
    }

    IMemoryRange getMemoryRangeForAddress(long address) {
        return this.memorySources.getRangeForAddress(address);
    }

    @Override
    public int getSignalNumber() throws DataUnavailableException {
        throw new DataUnavailableException("Signal number not available on AIX");
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        throw new DataUnavailableException("Not available on this platform");
    }
}

