/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.corereaders.memory.BaseMemoryRange;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.minidump.EarlyInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import java.io.IOException;
import java.util.ArrayList;

class Memory64Stream
extends EarlyInitializedStream {
    public Memory64Stream(int dataSize, int location) {
        super(dataSize, location);
    }

    public void readFrom(MiniDumpReader dump) throws IOException {
        long location = this.getLocation();
        dump.seek(location);
        long numberOfMemoryRanges = dump.readLong();
        long baseAddress = dump.readLong();
        ArrayList<BaseMemoryRange> memorySources = new ArrayList<BaseMemoryRange>();
        BaseMemoryRange memoryRange = null;
        int i = 0;
        while ((long)i < numberOfMemoryRanges) {
            long size;
            long start = dump.is64Bit() ? dump.readLong() : dump.readLong() & 0xFFFFFFFFL;
            long l = size = dump.is64Bit() ? dump.readLong() : dump.readLong() & 0xFFFFFFFFL;
            if (null == memoryRange) {
                memoryRange = new DumpMemorySource(start, size, baseAddress, dump, false, false, true);
            } else if (memoryRange.getBaseAddress() + memoryRange.getSize() == start) {
                memoryRange = new DumpMemorySource(memoryRange.getBaseAddress(), memoryRange.getSize() + size, ((DumpMemorySource)memoryRange).getFileOffset(), dump, false, false, true);
            } else {
                memorySources.add(memoryRange);
                memoryRange = new DumpMemorySource(start, size, ((DumpMemorySource)memoryRange).getFileOffset() + memoryRange.getSize(), dump, false, false, true);
            }
            ++i;
        }
        if (null != memoryRange) {
            memorySources.add(memoryRange);
        }
        dump.setMemorySources(memorySources);
    }
}

