/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.corereaders.minidump.EarlyInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import java.io.IOException;

class SystemInfoStream
extends EarlyInitializedStream {
    public SystemInfoStream(int dataSize, int location) {
        super(dataSize, location);
    }

    public void readFrom(MiniDumpReader dump) throws IOException {
        dump.seek(this.getLocation());
        short processorArchitecture = dump.readShort();
        short processorLevel = dump.readShort();
        short processorRevision = dump.readShort();
        byte numberOfProcessors = dump.readByte();
        byte productType = dump.readByte();
        int majorVersion = dump.readInt();
        int minorVersion = dump.readInt();
        int buildNumber = dump.readInt();
        byte model = (byte)(processorRevision >> 8 & 0xFF);
        byte stepping = (byte)(processorRevision & 0xFF);
        String procSubtype = "Level " + processorLevel + " Model " + model + " Stepping " + stepping;
        dump.setProcessorArchitecture(processorArchitecture, procSubtype, numberOfProcessors);
        dump.setWindowsType(productType, majorVersion, minorVersion, buildNumber);
    }

    public int readPtrSize(MiniDumpReader dump) {
        short processorArchitecture = 0;
        try {
            dump.seek(this.getLocation());
            byte[] buffer = new byte[2];
            dump.readFully(buffer);
            processorArchitecture = (short)((0xFF & buffer[1]) << 8 | 0xFF & buffer[0]);
        }
        catch (IOException e) {
            return 0;
        }
        return 9 == processorArchitecture || 6 == processorArchitecture || 7 == processorArchitecture || 10 == processorArchitecture ? 64 : 32;
    }
}

