/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.xml;

import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.j9.ImageFactory;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.j9ddr.tools.xml.DTFJTest;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory;
import java.io.File;
import java.util.Iterator;
import org.junit.After;
import org.junit.Before;

public class DTFJHeapSectionUnitTest
extends DTFJTest {
    public static final String PROPERTY_CORE_FILE_PATH = "core";
    public static final String PROPERTY_OUTPUT_PATH = "output";
    private boolean testJ9DDR = false;
    private String[] filesToCompare = new String[2];

    public String getConfigPath() {
        return "data/xpath configs/ DTFJHeapSectionUnitTest.properties";
    }

    public String[] getFilesToCompare() {
        return this.filesToCompare;
    }

    public com.ibm.dtfj.image.ImageFactory getImageFactory() {
        if (this.testJ9DDR) {
            return new J9DDRImageFactory();
        }
        return new ImageFactory();
    }

    @Before
    public void setUp() throws Exception {
        File core = this.parseCoreFilePath(this.getSystemProperty(PROPERTY_CORE_FILE_PATH));
        File output = new File(this.getSystemProperty(PROPERTY_OUTPUT_PATH));
        if (!output.exists()) {
            output.mkdirs();
        }
        JavaRuntime rt = this.getRuntime(core);
        File jxoutput = new File(output, "dtfj.xml");
        this.filesToCompare[0] = jxoutput.getPath();
        this.generateXML(jxoutput, rt);
        this.testJ9DDR = true;
        rt = this.getRuntime(core);
        File ddroutput = new File(output, "ddr.xml");
        this.filesToCompare[1] = ddroutput.getPath();
        this.generateXML(ddroutput, rt);
    }

    private String getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("The system property " + key + " has not been defined");
        }
        System.out.println("Property " + key + " = " + value);
        return value;
    }

    public void generateXML(File path, JavaRuntime rt) throws Exception {
        this.createWriter(path);
        this.startTag("<heaps>\n");
        Iterator heaps = rt.getHeaps();
        while (heaps.hasNext()) {
            JavaHeap heap = (JavaHeap)heaps.next();
            this.startTag("<heap name=\"" + heap.getName() + "\">\n");
            this.writeSections(heap);
            this.endTag("</heap>\n");
        }
        this.endTag("</heaps>\n");
        this.closeWriter();
    }

    private void writeSections(JavaHeap heap) throws Exception {
        Iterator sections = heap.getSections();
        while (sections.hasNext()) {
            ImageSection section = (ImageSection)sections.next();
            this.writeSection(section);
        }
    }

    @After
    public void tearDown() throws Exception {
    }
}

