/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9DDRImageModule
implements ImageModule {
    private final IProcess process;
    private final IModule delegate;
    private final String moduleNameOverride;

    public J9DDRImageModule(IProcess process, IModule module, String nameOverride) {
        if (module == null) {
            throw new NullPointerException("Module cannot be null");
        }
        if (process == null) {
            throw new NullPointerException("Process cannot be null");
        }
        this.process = process;
        this.delegate = module;
        this.moduleNameOverride = nameOverride;
    }

    public J9DDRImageModule(IProcess process, IModule module) {
        this(process, module, null);
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.moduleNameOverride != null) {
            return this.moduleNameOverride;
        }
        try {
            return this.delegate.getName();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
    }

    public Properties getProperties() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.delegate.getProperties();
        }
        catch (DataUnavailableException e) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, e.getMessage()), e);
        }
    }

    public Iterator getSections() {
        Collection<? extends IMemoryRange> ranges = this.delegate.getMemoryRanges();
        ArrayList<J9DDRImageSection> sections = new ArrayList<J9DDRImageSection>(ranges.size());
        for (IMemoryRange iMemoryRange : ranges) {
            sections.add(new J9DDRImageSection(this.process, iMemoryRange.getBaseAddress(), iMemoryRange.getSize(), iMemoryRange.getName()));
        }
        return sections.iterator();
    }

    public Iterator<?> getSymbols() {
        Collection<? extends ISymbol> symbols;
        try {
            symbols = this.delegate.getSymbols();
        }
        catch (DataUnavailableException e) {
            Collection<? extends IMemoryRange> memoryRanges = this.delegate.getMemoryRanges();
            long l = 0L;
            for (IMemoryRange iMemoryRange : memoryRanges) {
                if (!iMemoryRange.getName().contains(".text")) continue;
                l = iMemoryRange.getBaseAddress();
                break;
            }
            return Collections.singletonList(new J9DDRCorruptData(this.process, e.getMessage(), l)).iterator();
        }
        ArrayList<J9DDRImageSymbol> dtfjSymbols = new ArrayList<J9DDRImageSymbol>(symbols.size());
        for (ISymbol iSymbol : symbols) {
            dtfjSymbols.add(new J9DDRImageSymbol(iSymbol.getName(), new J9DDRImagePointer(this.process, iSymbol.getAddress())));
        }
        return dtfjSymbols.iterator();
    }

    public boolean equals(Object obj) {
        if (obj instanceof J9DDRImageModule) {
            J9DDRImageModule other = (J9DDRImageModule)obj;
            if (!this.process.equals(other.process)) {
                return false;
            }
            return this.delegate.equals(other.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        try {
            return "ImageModule: " + this.getName();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return "ImageModule: <couldn't get name>";
        }
    }

    public long getLoadAddress() throws DataUnavailable {
        return this.delegate.getLoadAddress();
    }
}

