/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class J9RASImageDataFactory {
    public static ProcessData getProcessData(IProcess p) {
        return (ProcessData)J9RASImageDataFactory.getRasData(p);
    }

    public static MachineData getMachineData(ICore c) {
        Collection<? extends IAddressSpace> addressSpaces = c.getAddressSpaces();
        for (IAddressSpace iAddressSpace : addressSpaces) {
            MachineData data = J9RASImageDataFactory.getMachineData(iAddressSpace);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static MachineData getMachineData(IAddressSpace a) {
        Collection<? extends IProcess> processes = a.getProcesses();
        for (IProcess iProcess : processes) {
            MachineData data = J9RASImageDataFactory.getMachineData(iProcess);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static MachineData getMachineData(IProcess p) {
        return (MachineData)J9RASImageDataFactory.getRasData(p);
    }

    private static Object getRasData(IProcess p) {
        try {
            IVMData vmData = VMDataFactory.getVMData(p);
            Object[] passBackArray = new Object[1];
            try {
                vmData.bootstrapRelative("view.dtfj.J9RASInfoBootstrapShim", new Object[]{passBackArray});
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            return passBackArray[0];
        }
        catch (IOException e) {
        }
        catch (UnsupportedOperationException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MachineData {
        public long memoryBytes() throws CorruptDataException;

        public String osVersion() throws CorruptDataException;

        public String osArch() throws CorruptDataException;

        public String osName() throws CorruptDataException;

        public String hostName() throws DataUnavailableException, CorruptDataException;

        public Iterator<Object> ipaddresses() throws DataUnavailableException, CorruptDataException;

        public int cpus() throws CorruptDataException;

        public IProcess getProcess();

        public Properties systemInfo() throws DataUnavailableException, CorruptDataException;
    }

    public static interface ProcessData {
        public long pid() throws CorruptDataException, DataUnavailable;

        public long tid() throws CorruptDataException, DataUnavailable;

        public String gpInfo() throws CorruptDataException;

        public IProcess getProcess();

        public long getEnvironment() throws CorruptDataException;
    }
}

