/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AVLTree;
import com.ibm.j9ddr.vm23.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm23.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm23.types.UDATA;

class AVLTree_23_V0
extends AVLTree {
    private final J9AVLTreePointer _tree;
    private final IAVLSearchComparator _searchComparator;
    private static final long AVL_BALANCEMASK = 3L;

    AVLTree_23_V0(J9AVLTreePointer structure, IAVLSearchComparator comparator) {
        super(30, 0);
        this._tree = structure;
        this._searchComparator = comparator;
    }

    private J9AVLTreeNodePointer findNode(UDATA searchValue) throws CorruptDataException {
        int dir;
        J9AVLTreeNodePointer walk = this._tree.rootNode();
        while (walk.notNull() && 0 != (dir = this._searchComparator.searchComparator(this._tree, searchValue, walk))) {
            if (dir < 0) {
                walk = AVLTree_23_V0.AVL_GETNODE(walk.leftChild());
                continue;
            }
            walk = AVLTree_23_V0.AVL_GETNODE(walk.rightChild());
        }
        return walk;
    }

    private static J9AVLTreeNodePointer AVL_GETNODE(J9AVLTreeNodePointer ptr) {
        return J9AVLTreeNodePointer.cast(UDATA.cast(ptr).bitAnd(-4L));
    }

    public J9AVLTreeNodePointer search(UDATA searchValue) throws CorruptDataException {
        return this.findNode(searchValue);
    }
}

