/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.gc.GCMixedObjectModel_V1;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.structure.J9Object;
import com.ibm.j9ddr.vm23.types.UDATA;

public abstract class GCMixedObjectModel {
    protected J9JavaVMPointer vm;

    protected GCMixedObjectModel(J9JavaVMPointer vm) throws CorruptDataException {
        this.vm = vm;
    }

    public static GCMixedObjectModel fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_MODEL_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectModel_V1(vm);
    }

    public abstract UDATA getSizeInBytesWithoutHeader(J9ClassPointer var1) throws CorruptDataException;

    public UDATA getSizeInBytesWithoutHeader(J9ObjectPointer object) throws CorruptDataException {
        return this.getSizeInBytesWithoutHeader(object.clazz());
    }

    public UDATA getSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return this.getSizeInBytesWithoutHeader(object).add(new UDATA(J9Object.SIZEOF));
    }

    public UDATA getSizeInSlotsWithoutHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithoutHeader(object));
    }

    public UDATA getSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithHeader(object));
    }
}

