/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.structure.J9IndexableObject;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9IndexableObject.class)
public class J9IndexableObjectPointer
extends StructurePointer {
    public static final J9IndexableObjectPointer NULL = new J9IndexableObjectPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    public String getClassName() throws CorruptDataException {
        return this.clazz().getName();
    }

    public void getData(Object dst, int start, int length, int destStart) throws CorruptDataException {
        String className = this.getClassName();
        int arraySize = (int)this.size().longValue();
        if (start + length > arraySize) {
            throw new ArrayIndexOutOfBoundsException("Requested range " + start + " to " + (start + length) + " overflows array of length " + arraySize);
        }
        switch (className.charAt(1)) {
            case 'B': {
                if (!(dst instanceof byte[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with byte array (expects byte[])");
                }
                this.getByteData((byte[])dst, start, length, destStart);
                break;
            }
            case 'C': {
                if (!(dst instanceof char[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with char array (expects char[])");
                }
                this.getCharData((char[])dst, start, length, destStart);
                break;
            }
            case 'D': {
                if (!(dst instanceof double[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with double array (expects double[])");
                }
                this.getDoubleData((double[])dst, start, length, destStart);
                break;
            }
            case 'F': {
                if (!(dst instanceof float[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with float array (expects float[])");
                }
                this.getFloatData((float[])dst, start, length, destStart);
                break;
            }
            case 'I': {
                if (!(dst instanceof int[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with int array (expects int[])");
                }
                this.getIntData((int[])dst, start, length, destStart);
                break;
            }
            case 'J': {
                if (!(dst instanceof long[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with long array (expects long[])");
                }
                this.getLongData((long[])dst, start, length, destStart);
                break;
            }
            case 'S': {
                if (!(dst instanceof short[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with short array (expects short[])");
                }
                this.getShortData((short[])dst, start, length, destStart);
                break;
            }
            case 'Z': {
                if (!(dst instanceof boolean[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with boolean array (expects boolean[])");
                }
                this.getBooleanData((boolean[])dst, start, length, destStart);
                break;
            }
            case 'L': 
            case '[': {
                if (!(dst instanceof J9ObjectPointer[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with Object array (expects J9ObjectPointer[])");
                }
                this.getObjectData((J9ObjectPointer[])dst, start, length, destStart);
                break;
            }
            default: {
                throw new CorruptDataException("The data identifier : " + className.charAt(1) + " was not recognised");
            }
        }
    }

    public void getByteData(byte[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = this.getByteAtOffset(J9IndexableObject.SIZEOF + (long)(start + i));
        }
    }

    public void getCharData(char[] dst, int start, int length, int destStart) throws CorruptDataException {
        long offset = J9IndexableObject.SIZEOF;
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = this.getBaseCharAtOffset(offset + (long)((i + start) * 2));
        }
    }

    public void getDoubleData(double[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            long bits = this.getLongAtOffset(J9IndexableObject.SIZEOF + (long)((i + start) * 8));
            dst[destStart + i] = Double.longBitsToDouble(bits);
        }
    }

    public void getFloatData(float[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            int bits = this.getIntAtOffset(J9IndexableObject.SIZEOF + (long)((i + start) * 4));
            dst[destStart + i] = Float.intBitsToFloat(bits);
        }
    }

    public void getIntData(int[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = this.getIntAtOffset(J9IndexableObject.SIZEOF + (long)((i + start) * 4));
        }
    }

    public void getLongData(long[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = this.getLongAtOffset(J9IndexableObject.SIZEOF + (long)((i + start) * 8));
        }
    }

    public void getShortData(short[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = this.getShortAtOffset(J9IndexableObject.SIZEOF + (long)((i + start) * 2));
        }
    }

    public void getBooleanData(boolean[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = 0 != this.getByteAtOffset(J9IndexableObject.SIZEOF + (long)(i + start));
        }
    }

    public void getObjectData(J9ObjectPointer[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = J9ObjectPointer.cast(this.getPointerAtOffset(J9IndexableObject.SIZEOF + (long)((i + start) * UDATA.SIZEOF)));
        }
    }

    public Object getData() throws CorruptDataException {
        String className = this.getClassName();
        int arraySize = (int)this.size().longValue();
        switch (className.charAt(1)) {
            case 'B': {
                byte[] data = new byte[arraySize];
                this.getByteData(data, 0, arraySize, 0);
                return data;
            }
            case 'C': {
                char[] data = new char[arraySize];
                this.getCharData(data, 0, arraySize, 0);
                return data;
            }
            case 'D': {
                double[] data = new double[arraySize];
                this.getDoubleData(data, 0, arraySize, 0);
                return data;
            }
            case 'F': {
                float[] data = new float[arraySize];
                this.getFloatData(data, 0, arraySize, 0);
                return data;
            }
            case 'I': {
                int[] data = new int[arraySize];
                this.getIntData(data, 0, arraySize, 0);
                return data;
            }
            case 'J': {
                long[] data = new long[arraySize];
                this.getLongData(data, 0, arraySize, 0);
                return data;
            }
            case 'S': {
                short[] data = new short[arraySize];
                this.getShortData(data, 0, arraySize, 0);
                return data;
            }
            case 'Z': {
                boolean[] data = new boolean[arraySize];
                this.getBooleanData(data, 0, arraySize, 0);
                return data;
            }
            case 'L': 
            case '[': {
                J9ObjectPointer[] data = new J9ObjectPointer[arraySize];
                this.getObjectData(data, 0, arraySize, 0);
                return data;
            }
        }
        throw new CorruptDataException("The data identifier : " + className.charAt(1) + " was not recognised");
    }

    protected J9IndexableObjectPointer(long address) {
        super(address);
    }

    public static J9IndexableObjectPointer cast(AbstractPointer structure) {
        return J9IndexableObjectPointer.cast(structure.getAddress());
    }

    public static J9IndexableObjectPointer cast(UDATA udata) {
        return J9IndexableObjectPointer.cast(udata.longValue());
    }

    public static J9IndexableObjectPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9IndexableObjectPointer(address);
    }

    public J9IndexableObjectPointer add(long count) {
        return J9IndexableObjectPointer.cast(this.address + J9IndexableObject.SIZEOF * count);
    }

    public J9IndexableObjectPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9IndexableObjectPointer addOffset(long offset) {
        return J9IndexableObjectPointer.cast(this.address + offset);
    }

    public J9IndexableObjectPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9IndexableObjectPointer sub(long count) {
        return J9IndexableObjectPointer.cast(this.address - J9IndexableObject.SIZEOF * count);
    }

    public J9IndexableObjectPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9IndexableObjectPointer subOffset(long offset) {
        return J9IndexableObjectPointer.cast(this.address - offset);
    }

    public J9IndexableObjectPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9IndexableObjectPointer untag(long mask) {
        return J9IndexableObjectPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9IndexableObjectPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9IndexableObject.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_clazzOffset_", declaredType="struct J9Class*")
    public J9ClassPointer clazz() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9IndexableObject._clazzOffset_);
        return J9ClassPointer.cast(pointer);
    }

    public PointerPointer clazzEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9IndexableObject._clazzOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
    public U32 flags() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9IndexableObject._flagsOffset_));
    }

    public U32Pointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9IndexableObject._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_monitorOffset_", declaredType="UDATA")
    public UDATA monitor() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9IndexableObject._monitorOffset_));
    }

    public UDATAPointer monitorEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9IndexableObject._monitorOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_sizeOffset_", declaredType="U32")
    public U32 size() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9IndexableObject._sizeOffset_));
    }

    public U32Pointer sizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9IndexableObject._sizeOffset_);
    }
}

