/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm23.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm23.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm23.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm23.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm23.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import java.io.PrintStream;

public class StackWalkCommand
extends Command {
    public StackWalkCommand() {
        this.addCommand("stack", "<thread>", "Walks the Java stack for <thread>");
        this.addCommand("stackslots", "<thread>", "Walks the Java stack (including objects) for <thread>");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        J9VMThreadPointer thread = J9VMThreadPointer.cast(address);
        StackWalkerUtils.enableVerboseLogging(3, out);
        WalkState walkState = new WalkState();
        walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
        if (command.equalsIgnoreCase("!stackslots")) {
            walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
        }
        walkState.walkThread = thread;
        walkState.callBacks = new BaseStackWalkerCallbacks();
        StackWalkResult result = StackWalker.walkStackFrames(walkState);
        if (result != StackWalkResult.NONE) {
            out.println("Stack walk result: " + (Object)((Object)result));
        }
        StackWalkerUtils.disableVerboseLogging();
        out.flush();
    }
}

