/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.types.I64;
import com.ibm.j9ddr.vm23.types.IScalar;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U16;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.U8;
import com.ibm.j9ddr.vm23.types.UDATA;

public class IDATA
extends IScalar {
    public static final int SIZEOF = J9BuildFlags.env_data64 ? 8 : 4;
    public static final long MASK = SIZEOF == 8 ? -1L : 0xFFFFFFFFL;
    public static final IDATA MIN = SIZEOF == 8 ? new IDATA(Long.MIN_VALUE) : new IDATA(0x80000000L);
    public static final IDATA MAX = SIZEOF == 8 ? new IDATA(Long.MAX_VALUE) : new IDATA(Integer.MAX_VALUE);

    public IDATA(long value) {
        super(value & MASK);
    }

    public IDATA(Scalar parameter) {
        super(parameter);
    }

    public IDATA add(U8 parameter) {
        return this.add(new IDATA(parameter));
    }

    public IDATA add(U16 parameter) {
        return this.add(new IDATA(parameter));
    }

    public IDATA add(U32 parameter) {
        return this.add(new IDATA(parameter));
    }

    public boolean eq(U32 parameter) {
        return this.eq(new IDATA(parameter));
    }

    public UDATA add(UDATA parameter) {
        return new UDATA(this).add(parameter);
    }

    public boolean eq(UDATA parameter) {
        return new UDATA(this).eq(parameter);
    }

    public IDATA add(IScalar parameter) {
        return this.add(new IDATA(parameter));
    }

    public IDATA add(IDATA parameter) {
        return new IDATA(this.data + parameter.data);
    }

    public I64 add(I64 parameter) {
        return new I64(this).add(parameter);
    }

    public IDATA sub(U8 parameter) {
        return this.sub(new IDATA(parameter));
    }

    public IDATA sub(U16 parameter) {
        return this.sub(new IDATA(parameter));
    }

    public IDATA sub(U32 parameter) {
        return this.sub(new IDATA(parameter));
    }

    public UDATA sub(UDATA parameter) {
        return new UDATA(this).sub(parameter);
    }

    public IDATA sub(IScalar parameter) {
        return this.sub(new IDATA(parameter));
    }

    public IDATA sub(IDATA parameter) {
        return new IDATA(this.data - parameter.data);
    }

    public IDATA sub(long parameter) {
        return new IDATA(this.data - parameter);
    }

    public I64 sub(I64 parameter) {
        return new I64(this).sub(parameter);
    }

    public int intValue() {
        if (SIZEOF == 8 && super.intValue() < 0) {
            throw new InvalidDataTypeException("IDATA is 32 bits wide and contains a number larger than MAX_INT");
        }
        return super.intValue();
    }

    public long longValue() {
        if (SIZEOF == 4) {
            return (int)this.data;
        }
        return this.data;
    }

    public IDATA bitOr(int parameter) {
        return new IDATA(this.data | (long)parameter);
    }

    public IDATA bitOr(U8 parameter) {
        return this.bitOr(new IDATA(parameter));
    }

    public IDATA bitOr(U16 parameter) {
        return this.bitOr(new IDATA(parameter));
    }

    public IDATA bitOr(U32 parameter) {
        return this.bitOr(new IDATA(parameter));
    }

    public UDATA bitOr(UDATA parameter) {
        return new UDATA(this).bitOr(parameter);
    }

    public IDATA bitOr(IScalar parameter) {
        return this.bitOr(new IDATA(parameter));
    }

    public IDATA bitOr(IDATA parameter) {
        return new IDATA(this.data | parameter.data);
    }

    public I64 bitOr(I64 parameter) {
        return new I64(this).bitOr(parameter);
    }

    public IDATA bitAnd(int parameter) {
        return new IDATA(this.data & (long)parameter);
    }

    public IDATA bitAnd(U8 parameter) {
        return this.bitAnd(new IDATA(parameter));
    }

    public IDATA bitAnd(U16 parameter) {
        return this.bitAnd(new IDATA(parameter));
    }

    public IDATA bitAnd(U32 parameter) {
        return this.bitAnd(new IDATA(parameter));
    }

    public UDATA bitAnd(UDATA parameter) {
        return new UDATA(this).bitAnd(parameter);
    }

    public IDATA bitAnd(IScalar parameter) {
        return this.bitAnd(new IDATA(parameter));
    }

    public IDATA bitAnd(IDATA parameter) {
        return new IDATA(this.data & parameter.data);
    }

    public I64 bitAnd(I64 parameter) {
        return new I64(this).bitAnd(parameter);
    }

    public IDATA leftShift(int i) {
        return new IDATA(this.data << i);
    }

    public IDATA rightShift(int i) {
        if (SIZEOF == 4) {
            long newData = this.data >>> i;
            if ((this.data & Integer.MIN_VALUE) != 0L) {
                newData |= (long)(-1 << Math.max(0, 32 - i));
            }
            return new IDATA(newData);
        }
        return new IDATA(this.data >> i);
    }

    public IDATA bitNot() {
        return new IDATA(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IDATA mult(int parameter) {
        return new IDATA(this.data * (long)parameter);
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static IDATA cast(AbstractPointer ptr) {
        if (ptr != null) {
            return new IDATA(ptr.getAddress());
        }
        return new IDATA(0L);
    }
}

