/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AVLTree;
import com.ibm.j9ddr.vm24.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm24.pointer.IDATAPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.UDATA;

class AVLTree_24_V0
extends AVLTree {
    private final J9AVLTreePointer tree;
    private final IAVLSearchComparator searchComparator;
    private static final long AVL_BALANCEMASK = 3L;

    AVLTree_24_V0(J9AVLTreePointer tree, IAVLSearchComparator searchComparator) {
        super(40, 0);
        this.tree = tree;
        this.searchComparator = searchComparator;
    }

    private J9AVLTreeNodePointer findNode(UDATA search) throws CorruptDataException {
        int dir;
        J9AVLTreeNodePointer walk = this.tree.rootNode();
        while (walk.notNull() && 0 != (dir = this.searchComparator.searchComparator(this.tree, search, walk))) {
            if (dir < 0) {
                walk = this.AVL_SRP_GETNODE(walk.leftChild(), walk.leftChildEA());
                continue;
            }
            walk = this.AVL_SRP_GETNODE(walk.rightChild(), walk.rightChildEA());
        }
        return walk;
    }

    private J9AVLTreeNodePointer AVL_SRP_GETNODE(IDATA srp, IDATAPointer srpEA) {
        return AVLTree_24_V0.AVL_GETNODE(srp).notNull() ? J9AVLTreeNodePointer.cast(srpEA.addOffset(IDATA.cast(AVLTree_24_V0.AVL_GETNODE(srp)))) : J9AVLTreeNodePointer.NULL;
    }

    private static J9AVLTreeNodePointer AVL_GETNODE(IDATA ptr) {
        return J9AVLTreeNodePointer.cast(new UDATA(ptr).bitAnd(-4L));
    }

    public J9AVLTreeNodePointer search(UDATA searchValue) throws CorruptDataException {
        return this.findNode(searchValue);
    }
}

