/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.types.UDATA;

public class J9ObjectFieldOffset {
    private final J9ROMFieldShapePointer field;
    private final UDATA offsetOrAddress;

    public J9ObjectFieldOffset(J9ROMFieldShapePointer field, UDATA offsetOrAddress) {
        this.field = field;
        this.offsetOrAddress = offsetOrAddress;
    }

    public boolean isStatic() {
        try {
            return this.field.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic);
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    public J9ROMFieldShapePointer getField() {
        return this.field;
    }

    public UDATA getOffsetOrAddress() {
        return this.offsetOrAddress;
    }

    public String toString() {
        return String.format("%s: %s isStatic: %s", this.field, this.offsetOrAddress, this.isStatic());
    }

    public String getName() throws CorruptDataException {
        return J9ROMFieldShapeHelper.getName(this.field);
    }

    public String getSignature() throws CorruptDataException {
        return J9ROMFieldShapeHelper.getSignature(this.field);
    }
}

