/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.structure.J9MemorySegment;
import com.ibm.j9ddr.vm24.types.U32;
import java.io.PrintStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROMClassesIterator
implements Iterator<J9ROMClassPointer> {
    private J9MemorySegmentPointer nextSegment;
    private long heapPtr;
    private final PrintStream out;
    private J9ROMClassPointer nextClass;

    public ROMClassesIterator(PrintStream out, J9MemorySegmentListPointer segmentList) {
        this.out = out;
        try {
            this.nextSegment = segmentList.nextSegment();
        }
        catch (CorruptDataException e) {
            this.nextSegment = J9MemorySegmentPointer.NULL;
        }
        this.heapPtr = 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.nextSegment.isNull()) {
            return false;
        }
        this.nextClass = this.getNextClass();
        return !this.nextClass.isNull();
    }

    @Override
    public J9ROMClassPointer next() {
        return this.nextClass;
    }

    public J9MemorySegmentPointer getMemorySegmentPointer() {
        return this.nextSegment;
    }

    private J9ROMClassPointer getNextClass() {
        try {
            while (!this.nextSegment.isNull()) {
                if (this.nextSegment.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_ROM_CLASS)) {
                    if (this.heapPtr < this.nextSegment.heapBase().longValue() || this.heapPtr > this.nextSegment.heapAlloc().longValue()) {
                        this.heapPtr = this.nextSegment.heapBase().longValue();
                    }
                    while (this.heapPtr < this.nextSegment.heapAlloc().longValue()) {
                        J9ROMClassPointer clazzPtr = J9ROMClassPointer.cast(this.heapPtr);
                        try {
                            U32 romSize = clazzPtr.romSize();
                            if (romSize.eq(0L)) {
                                this.out.append("Rom class size (0) is invalid. Skipping to next segment.\n");
                                this.heapPtr = this.nextSegment.heapAlloc().longValue();
                                continue;
                            }
                            this.heapPtr += romSize.longValue();
                            return clazzPtr;
                        }
                        catch (CorruptDataException e) {
                            this.out.append("Unable to read rom class size at " + clazzPtr.getHexAddress() + ". Skipping to next segment.\n");
                            this.heapPtr = this.nextSegment.heapAlloc().longValue();
                        }
                    }
                }
                this.nextSegment = this.nextSegment.nextSegment();
            }
        }
        catch (Exception e) {
            return J9ROMClassPointer.NULL;
        }
        return J9ROMClassPointer.NULL;
    }

    @Override
    public void remove() {
    }
}

